/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.TransparencyRGBImageFilter;
import tsukuba_bunko.peko.resource.ResourceManager;

public class ImageManager {
    private static ImageManager _instance = null;
    static /* synthetic */ Class class$0;

    protected ImageManager() {
    }

    public Image getImage(String name) {
        return this.getImage(name, false);
    }

    public Image getImage(String name, boolean transparentize) {
        Image image = null;
        BufferedImage source = null;
        try {
            source = ImageIO.read(this.getURL(name));
        }
        catch (IOException ioe) {
            Logger.debug("[canvas.stage] fail to load image :" + name, ioe);
            return null;
        }
        if (transparentize) {
            int transColor = source.getRGB(0, 0);
            if ((transColor & 0xFF000000) != 0) {
                TransparencyRGBImageFilter filter = new TransparencyRGBImageFilter();
                filter.setTransparencyColor(transColor & 0xFFFFFF);
                FilteredImageSource imageSource = new FilteredImageSource(source.getSource(), filter);
                image = Toolkit.getDefaultToolkit().createImage(imageSource);
                source.flush();
            } else {
                image = source;
            }
        } else {
            image = source;
        }
        return image;
    }

    public void putImage(String name, Image image) {
        if (image != null) {
            image.flush();
        }
    }

    protected URL getURL(String name) {
        ResourceManager resources = ResourceManager.getInstance();
        try {
            return new URL(resources.getLocationResources().getImagesDirecotryURL(), name);
        }
        catch (Exception e) {
            Logger.error("[scene.stage] fatal error!", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageManager getInstance() {
        if (_instance != null) return _instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.peko.canvas.stage.ImageManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_instance != null) return _instance;
            _instance = new ImageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }
}

