/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.stage;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.AudioClip;
import tsukuba_bunko.peko.canvas.stage.audio.MP3AudioClip;
import tsukuba_bunko.peko.canvas.stage.audio.SampledAudioClip;
import tsukuba_bunko.peko.resource.ResourceManager;

public class AudioPlayer
implements Serializable {
    private transient Map _clips = new HashMap(17);
    private Map _bgmRegistry = new HashMap(17);
    private Map _seRegistry = new HashMap(17);

    public void playBGM(String id, String clipName, boolean loop) {
        ResourceManager resources = ResourceManager.getInstance();
        try {
            if (this._clips.containsKey(id)) {
                Logger.error("[canvas.stage] specified bgm clip id was already used. :" + id);
                return;
            }
            this._bgmRegistry.put(id, new Object[]{clipName, loop ? Boolean.TRUE : Boolean.FALSE});
            URL clipURL = new URL(resources.getLocationResources().getSoundsDirecotryURL(), clipName);
            this.playClip(id, clipURL, loop);
        }
        catch (Exception e) {
            Logger.error("[canvas.stage] fail to play bgm :" + clipName, (Throwable)e);
        }
    }

    public void playSE(String id, String clipName, boolean loop) {
        ResourceManager resources = ResourceManager.getInstance();
        try {
            if (this._clips.containsKey(id)) {
                Logger.error("[canvas.stage] specified se clip id was already used. :" + id);
                return;
            }
            this._seRegistry.put(id, new Object[]{clipName, loop ? Boolean.TRUE : Boolean.FALSE});
            URL clipURL = new URL(resources.getLocationResources().getSoundsDirecotryURL(), clipName);
            this.playClip(id, clipURL, loop);
        }
        catch (Exception e) {
            Logger.error("[canvas.stage] fail to play bgm :" + clipName, (Throwable)e);
        }
    }

    protected void playClip(String id, URL clipURL, boolean loop) {
        try {
            AudioClip clip = this.getAudioClip(id, clipURL);
            if (clip != null) {
                this.register(clip);
                clip.play(loop);
            }
        }
        catch (Exception e) {
            Logger.error("[canvas.stage] fail to play clip. :" + clipURL, (Throwable)e);
        }
    }

    protected void register(AudioClip clip) {
        clip.setAudioPlayer(this);
        this._clips.put(clip.getID(), clip);
        Logger.debug("[canvas.stage] registered clip :" + clip.getID());
    }

    protected void unregister(AudioClip clip) {
        this._clips.remove(clip.getID());
        this._bgmRegistry.remove(clip.getID());
        this._seRegistry.remove(clip.getID());
        Logger.debug("[canvas.stage] unregistered clip :" + clip.getID());
    }

    public void stop(String id) {
        AudioClip clip = (AudioClip)this._clips.get(id);
        if (clip != null) {
            clip.stop();
        }
    }

    public void stopAll() {
        AudioClip[] clips = this._clips.values().toArray(new AudioClip[this._clips.size()]);
        int i = 0;
        while (i < clips.length) {
            clips[i].stop();
            ++i;
        }
    }

    protected AudioClip getAudioClip(String id, URL clipURL) {
        String clipName = clipURL.getFile().toLowerCase();
        if (clipName.endsWith(".mid") || clipName.equals(".smf")) {
            Logger.error("[canvas.stage] unsupported format :" + clipURL);
            return null;
        }
        if (clipName.endsWith("mp3")) {
            return new MP3AudioClip(id, clipURL);
        }
        if (clipName.endsWith(".wav") || clipName.endsWith(".au")) {
            return new SampledAudioClip(id, clipURL);
        }
        Logger.error("[canvas.stage] unsupported format :" + clipURL);
        return null;
    }

    public void prepare() {
        int i;
        if (this._clips == null) {
            Logger.debug("[cavnas.stage] initialize clips.");
            this._clips = new HashMap(17);
        }
        String[] id = null;
        Object[] clip = null;
        Map registry = this._bgmRegistry;
        if (registry.size() > 0) {
            id = registry.keySet().toArray(new String[registry.size()]);
            i = 0;
            while (i < id.length) {
                clip = (Object[])registry.get(id[i]);
                this.playBGM(id[i], (String)clip[0], (Boolean)clip[1]);
                ++i;
            }
        }
        if ((registry = this._seRegistry).size() > 0) {
            id = registry.keySet().toArray(new String[registry.size()]);
            i = 0;
            while (i < id.length) {
                clip = (Object[])registry.get(id[i]);
                this.playSE(id[i], (String)clip[0], (Boolean)clip[1]);
                ++i;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Logger.prepare();
        if (args.length < 1) {
            System.err.println("\u306b\u3087\u308f\u30fc");
            return;
        }
        File target = new File(args[0]);
        if (!target.exists()) {
            System.err.println("\u306d\u3047\u305e\u3054\u3089\u3041\uff01");
            return;
        }
        boolean loop = false;
        if (args.length >= 2) {
            loop = args[1].equals("loop");
        }
        long span = -1L;
        if (args.length >= 3) {
            span = Long.parseLong(args[2]);
        }
        SampledAudioClip clip = new SampledAudioClip("hoge", target.toURL());
        clip.play(loop);
        if (span > 0L) {
            SampledAudioClip sampledAudioClip = clip;
            synchronized (sampledAudioClip) {
                clip.wait(span);
            }
            ((AudioClip)clip).stop();
        }
    }
}

