/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.select;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.select.SelectCanvas;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.text.Line;

public class SelectItemButton
extends JComponent
implements MouseListener {
    public static final String STYLE_WIDTH = "select.button.witdth";
    public static final String STYLE_BACKGROUND_COLOR = "select.button.background.color";
    public static final String STYLE_BACKGROUND_TRANSPARENCY = "select.button.background.transparency";
    public static final String STYLE_FOREGROUND_SELECTED = "select.button.foreground.selected";
    public static final String STYLE_FOREGROUND_UNSELECTED = "select.button.foreground.unselected";
    public static final String STYLE_FOREGROUND_SHADOW = "select.button.foreground.shadow";
    public static final String STYLE_FONT = "select.button.font";
    private SelectCanvas _owner = null;
    private SelectItem _item = null;
    private List _lines = null;
    private Color _foregroundActive = null;
    private Color _foregroundNonActive = null;
    private Color _shadow = null;
    private AlphaComposite _alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    private boolean _selected = false;
    private Dimension _size = new Dimension();

    public SelectItemButton(SelectCanvas owner) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.addMouseListener(this);
        this._owner = owner;
    }

    public void addNotify() {
        super.addNotify();
        SelectItemButton selectItemButton = this;
        synchronized (selectItemButton) {
            this.notify();
        }
    }

    public void setSelectItem(SelectItem item) {
        this._item = item;
    }

    public SelectItem getSelectItem() {
        return this._item;
    }

    public void prepare(Map style) {
        Font fontValue;
        Color colorValue = (Color)style.get(STYLE_FOREGROUND_SELECTED);
        this._foregroundActive = colorValue != null ? colorValue : Color.white;
        colorValue = (Color)style.get(STYLE_FOREGROUND_UNSELECTED);
        this._foregroundNonActive = colorValue != null ? colorValue : Color.darkGray;
        colorValue = (Color)style.get(STYLE_BACKGROUND_COLOR);
        if (colorValue != null) {
            this.setBackground(colorValue);
        } else {
            this.setBackground(Color.black);
        }
        colorValue = (Color)style.get(STYLE_FOREGROUND_SHADOW);
        this._shadow = colorValue != null ? colorValue : Color.black;
        this.setForeground(this._foregroundNonActive);
        Float fv = (Float)style.get(STYLE_BACKGROUND_TRANSPARENCY);
        if (fv != null) {
            if (fv.floatValue() != this._alphaComposite.getAlpha()) {
                this._alphaComposite = AlphaComposite.getInstance(3, fv.floatValue());
            }
        } else if (this._alphaComposite.getAlpha() != 0.5f) {
            this._alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        }
        float width = 320.0f;
        Integer intValue = (Integer)style.get(STYLE_WIDTH);
        if (intValue != null) {
            width = intValue.floatValue();
        }
        if ((fontValue = (Font)style.get(STYLE_FONT)) != null) {
            this.setFont(fontValue);
        }
        this.prepareLabel(width, 2);
    }

    public void prepareLabel(float width, int maxRows) {
        if (this._item == null) {
            Logger.error("[canvas.text] not specified corresponding SelectItem.");
            return;
        }
        Graphics2D g2 = (Graphics2D)PekoSystem.getInstance().getMainWindow().getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<Line> lines = new ArrayList<Line>();
        float lineWidth = width - 10.0f;
        float lineHeight = 0.0f;
        String text = this._item.getText();
        AttributedString astring = new AttributedString(text);
        astring.addAttribute(TextAttribute.FONT, this.getFont());
        LineBreakMeasurer lbm = new LineBreakMeasurer(astring.getIterator(), g2.getFontRenderContext());
        int length = text.length();
        Line line = null;
        int i = 0;
        while (i < maxRows && lbm.getPosition() < length) {
            line = new Line();
            line.setTextLayout(lbm.nextLayout(width));
            line.setShadowColor(this._shadow);
            lines.add(line);
            lineHeight += line.getAscent();
            lineHeight += line.getDescent();
            ++i;
        }
        this._lines = lines;
        Dimension componentSize = new Dimension((int)width, (int)lineHeight + 10);
        this.setPreferredSize(componentSize);
        this.setSize(componentSize);
    }

    public void setSelected(boolean selected) {
        if (this._selected == selected) {
            return;
        }
        if (selected) {
            this.setForeground(this._foregroundActive);
            this._owner.itemSelecting(this);
        } else {
            this.setForeground(this._foregroundNonActive);
            this._owner.itemDeselected(this);
        }
        this._selected = selected;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(this._alphaComposite);
        g2.setColor(this.getBackground());
        Dimension size = this.getSize(this._size);
        g2.fillRect(0, 0, size.width, size.height);
        List lines = this._lines;
        if (lines != null) {
            g2 = (Graphics2D)g;
            int length = lines.size();
            float x = 5.0f;
            float y = 5.0f;
            Line line = null;
            int i = 0;
            while (i < length) {
                line = (Line)lines.get(i);
                line.setForeground(this.getForeground());
                line.draw(g2, x, y += line.getAscent());
                y += line.getDescent();
                ++i;
            }
        }
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
        this.setSelected(true);
    }

    public void mouseExited(MouseEvent ev) {
        this.setSelected(false);
    }

    public void mouseClicked(MouseEvent ev) {
        if (this._selected && ev.getModifiers() == 16) {
            this._owner.itemSelected(this);
        }
    }
}

