/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.select;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.select.SelectItemButton;

public class SelectCanvas
extends JComponent
implements KeyListener {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int VALIGN_TOP = 0;
    public static final int VALIGN_MIDDLE = 1;
    public static final int VALIGN_BOTTOM = 2;
    private boolean _active = false;
    private List _buttons = null;
    private String _id = null;
    private SelectItemButton _selected = null;
    private int _selectedIndex = -1;
    private int _lastKeyCode = -1;
    private int _align = 1;
    private int _verticalAlign = 0;
    private int _columns = 1;
    private int _columnSpan = 20;
    private int _rowSpan = 20;
    private int _boundSpan = 20;
    private Map _buttonStyle = null;
    private Dimension _dimensionCache = null;

    public void setAlignment(int align) {
        if (align != 1 && align != 0 && align != 2) {
            throw new IllegalArgumentException("invalid alignment type is specified.");
        }
        this._align = align;
    }

    public int getAlignment() {
        return this._align;
    }

    public void setVerticalAlignment(int valign) {
        if (valign != 1 && valign != 0 && valign != 2) {
            throw new IllegalArgumentException("invalid vertical alignment type is specified.");
        }
        this._verticalAlign = valign;
    }

    public int getVericalAlignment() {
        return this._verticalAlign;
    }

    public void setColumns(int columns) {
        this._columns = columns;
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumnSpan(int span) {
        this._columnSpan = span;
    }

    public int getColumnSpan() {
        return this._columnSpan;
    }

    public void setRowSpan(int span) {
        this._rowSpan = span;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public void setBoundSpan(int span) {
        this._boundSpan = span;
    }

    public int getBoundSpan() {
        return this._boundSpan;
    }

    public void setButtonStyle(Map styles) {
        this._buttonStyle = styles;
    }

    public Map getButtonStyle() {
        return this._buttonStyle;
    }

    public String select(List selectItems) {
        return this.select(selectItems, -1L);
    }

    public String select(List selectItems, long timeout) {
        int size;
        if (this._buttonStyle == null) {
            throw new IllegalStateException("button styles is not specified.");
        }
        if (this._active) {
            Logger.debug("[canvas.select] already show selection.");
            return null;
        }
        SelectCanvas selectCanvas = this;
        synchronized (selectCanvas) {
            this._id = null;
            Dimension canvasSize = this.getSize(this._dimensionCache);
            size = selectItems.size();
            int buttonWidth = 320;
            Integer intValue = (Integer)this._buttonStyle.get("select.button.witdth");
            if (intValue != null) {
                buttonWidth = intValue;
            }
            this.setVisible(false);
            SelectItem item = null;
            SelectItemButton button = null;
            ArrayList<SelectItemButton> buttons = new ArrayList<SelectItemButton>(size);
            int x = 0;
            int y = 0;
            int rowHeight = 0;
            Dimension buttonSize = new Dimension(0, 0);
            int i = 0;
            while (i < size) {
                if (i % this._columns == 0) {
                    y += rowHeight;
                    if (item != null) {
                        y += this._rowSpan;
                    }
                    x = 0;
                    rowHeight = 0;
                } else {
                    x += buttonSize.width + this._columnSpan;
                }
                item = (SelectItem)selectItems.get(i);
                button = new SelectItemButton(this);
                button.setSelectItem(item);
                button.prepare(this._buttonStyle);
                buttons.add(button);
                this.add(button);
                button.setLocation(x, y);
                buttonSize = button.getSize(buttonSize);
                if (buttonSize.height > rowHeight) {
                    rowHeight = buttonSize.height;
                }
                ++i;
            }
            int areaWidth = buttonWidth * this._columns + this._columnSpan * (this._columns - 1);
            int leftPosition = 0;
            if (areaWidth > canvasSize.width) {
                leftPosition = 0;
            } else if (areaWidth + this._boundSpan > canvasSize.width) {
                leftPosition = (canvasSize.width - areaWidth) / 2;
            } else if (this._align == 1) {
                leftPosition = (canvasSize.width - areaWidth) / 2;
            } else if (this._align == 0) {
                leftPosition = this._boundSpan;
            } else if (this._align == 2) {
                leftPosition = canvasSize.width - areaWidth - this._boundSpan;
            }
            int areaHeight = y + rowHeight;
            int topPosition = 0;
            if (areaHeight > canvasSize.height) {
                topPosition = 0;
            } else if (areaHeight + this._boundSpan > canvasSize.height) {
                topPosition = (canvasSize.height - areaHeight) / 2;
            } else if (this._verticalAlign == 0) {
                topPosition = this._boundSpan;
            } else if (this._verticalAlign == 1) {
                topPosition = (canvasSize.height - areaHeight) / 2;
            } else if (this._verticalAlign == 2) {
                topPosition = canvasSize.height - areaHeight - this._boundSpan;
            }
            this.setLocation(leftPosition, topPosition);
            this._buttons = buttons;
            this._active = true;
            this.setVisible(true);
        }
        Logger.debug("[canvas.select] wait for selecting.");
        ActionControler controler = PekoSystem.getInstance().getActionControler();
        if (timeout > 0L) {
            controler.stop(timeout);
        } else {
            controler.stop();
        }
        SelectCanvas selectCanvas2 = this;
        synchronized (selectCanvas2) {
            size = this._buttons.size();
            int i = 0;
            while (i < size) {
                this.remove((SelectItemButton)this._buttons.get(i));
                ++i;
            }
            this._buttons.clear();
            this._buttons = null;
        }
        Logger.debug("[canvas.select] id: " + this._id);
        return this._id;
    }

    public void cancel() {
        this._active = false;
        SelectCanvas selectCanvas = this;
        synchronized (selectCanvas) {
            if (this._buttons != null) {
                this._id = null;
                ActionControler controler = PekoSystem.getInstance().getActionControler();
                controler.start();
                Logger.debug("[cenvas.select] canceled.");
            }
        }
    }

    public void itemSelecting(SelectItemButton button) {
        SelectItemButton old = this._selected;
        this._selected = button;
        if (old != null && old != button) {
            old.setSelected(false);
        }
        this._selectedIndex = this._buttons.indexOf(button);
    }

    public void itemDeselected(SelectItemButton button) {
        if (this._selected == button) {
            this._selected = null;
            this._selectedIndex = -1;
        }
    }

    public void itemSelected(SelectItemButton button) {
        if (this._active) {
            SelectCanvas selectCanvas = this;
            synchronized (selectCanvas) {
                if (this._active) {
                    this._selected = null;
                    this._selectedIndex = -1;
                    this._id = button.getSelectItem().getID();
                    this._active = false;
                    Logger.debug("[canvas.select] selected: " + this._id);
                    ActionControler controler = PekoSystem.getInstance().getActionControler();
                    controler.start();
                }
            }
        }
    }

    public void keyPressed(KeyEvent ev) {
        if (this._active) {
            int code = ev.getKeyCode();
            if (this._lastKeyCode == -1) {
                this._lastKeyCode = code;
            } else if (this._lastKeyCode != code) {
                this._lastKeyCode = -1;
            }
            int index = this._selectedIndex;
            int size = this._buttons.size();
            if (code == 40) {
                index = (index + 1) % size;
            } else if (code == 39 && this._columns > 1) {
                index = (index + 1) % size;
            } else if (code == 38) {
                if (--index < 0) {
                    index = this._buttons.size() - 1;
                }
            } else if (code == 37 && this._columns > 1) {
                if (--index < 0) {
                    index = this._buttons.size() - 1;
                }
            } else {
                return;
            }
            SelectItemButton button = (SelectItemButton)this._buttons.get(index);
            button.setSelected(true);
        }
    }

    public void keyReleased(KeyEvent ev) {
        if (!this._active || this._buttons == null) {
            return;
        }
        int code = ev.getKeyCode();
        if (code != this._lastKeyCode) {
            this._lastKeyCode = -1;
            return;
        }
        if (code == 10 && this._selected != null) {
            this.itemSelected(this._selected);
        }
        this._lastKeyCode = -1;
    }

    public void keyTyped(KeyEvent ev) {
    }
}

