/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import tsukuba_bunko.peko.ActionControler;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.canvas.MessageIDs;
import tsukuba_bunko.peko.canvas.select.SelectCanvas;
import tsukuba_bunko.peko.canvas.select.SelectItem;
import tsukuba_bunko.peko.canvas.stage.Stage;
import tsukuba_bunko.peko.canvas.stage.StageCanvas;
import tsukuba_bunko.peko.canvas.text.Page;
import tsukuba_bunko.peko.canvas.text.TextCanvas;
import tsukuba_bunko.peko.resource.FontManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.Session;

public class CanvasManager {
    private TextCanvas _text = null;
    private StageCanvas _stage = null;
    private SelectCanvas _select = null;
    private List _history = null;
    private int _maxHistoryCount = 0;
    private Page _currentPage = null;
    private boolean _selecting = false;
    private Map _selectStyle = null;
    private Map _titleStyle = null;

    public void initialize() {
        PekoSystem system = PekoSystem.getInstance();
        ResourceManager resources = ResourceManager.getInstance();
        this._history = new ArrayList();
        JFrame mainWindow = system.getMainWindow();
        String title = (String)resources.getResource("game-info.title");
        Dimension canvasSize = (Dimension)resources.getResource("peko.canvas.canvas-size");
        ImageIcon icon = (ImageIcon)resources.getResource("game-info.icon");
        mainWindow.setTitle(title);
        if (icon.getIconHeight() > 0 && icon.getIconWidth() > 0) {
            mainWindow.setIconImage(icon.getImage());
        }
        mainWindow.setResizable(true);
        JComponent contentPane = (JComponent)mainWindow.getContentPane();
        contentPane.setPreferredSize(canvasSize);
        contentPane.setSize(canvasSize);
        contentPane.setLayout(null);
        this._stage = new StageCanvas();
        this._stage.setStage(new Stage());
        contentPane.add(this._stage);
        this._stage.setLocation(0, 0);
        this._text = new TextCanvas();
        this._text.setPreferredSize(canvasSize);
        this._text.setSize(canvasSize);
        this._text.setVisible(false);
        this._stage.add(this._text);
        this._text.setLocation(0, 0);
        this._select = new SelectCanvas();
        this._select.setPreferredSize(canvasSize);
        this._select.setSize(canvasSize);
        this._select.setVisible(false);
        this._stage.add(this._select);
        this._select.setLocation(0, 0);
        mainWindow.addKeyListener(this._select);
        Integer maxHistory = (Integer)resources.getResource("peko.canvas.text-history");
        this._maxHistoryCount = maxHistory == null ? 10 : maxHistory;
        this.initializeSelectStyle();
        this.initializeTitleStyle();
    }

    protected void initializeSelectStyle() {
        ResourceManager resources = ResourceManager.getInstance();
        this._selectStyle = new HashMap(17);
        Color colorValue = (Color)resources.getResource("peko.canvas.select.button.background.color");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.color", "black"});
            colorValue = Color.black;
        }
        this._selectStyle.put("select.button.background.color", colorValue);
        Float floatValue = (Float)resources.getResource("peko.canvas.select.button.background.transparency");
        if (floatValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            floatValue = new Float(0.5f);
        } else if (floatValue.floatValue() < 0.0f) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            floatValue = new Float(0.5f);
        }
        this._selectStyle.put("select.button.background.transparency", floatValue);
        Integer intValue = (Integer)resources.getResource("peko.canvas.select.button.width");
        if (intValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.witdth", "320"});
            intValue = new Integer(320);
        }
        this._selectStyle.put("select.button.witdth", intValue);
        colorValue = (Color)resources.getResource("peko.canvas.select.button.foreground.selected");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.selected", "white"});
            colorValue = Color.white;
        }
        this._selectStyle.put("select.button.foreground.selected", colorValue);
        colorValue = (Color)resources.getResource("peko.canvas.select.button.foreground.unselected");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.unselected", "darkGray"});
            colorValue = Color.darkGray;
        }
        this._selectStyle.put("select.button.foreground.unselected", colorValue);
        colorValue = (Color)resources.getResource("peko.canvas.select.button.foreground.shadow");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.shadow", "black"});
            colorValue = Color.black;
        }
        this._selectStyle.put("select.button.foreground.shadow", colorValue);
        Font fontValue = (Font)resources.getResource("peko.canvas.select.button.font");
        if (fontValue == null) {
            HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>(17);
            attributes.put(TextAttribute.FAMILY, "SansSerif");
            attributes.put(TextAttribute.SIZE, new Float(16.0f));
            fontValue = FontManager.getInstance().getFont(attributes);
        }
        this._selectStyle.put("select.button.font", fontValue);
    }

    protected void initializeTitleStyle() {
        ResourceManager resources = ResourceManager.getInstance();
        this._titleStyle = new HashMap(17);
        Color colorValue = (Color)resources.getResource("peko.title.style.button.background.color");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.color", "black"});
            colorValue = Color.black;
        }
        this._titleStyle.put("select.button.background.color", colorValue);
        Float floatValue = (Float)resources.getResource("peko.title.style.button.background.transparency");
        if (floatValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            floatValue = new Float(0.5f);
        } else if (floatValue.floatValue() < 0.0f) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.background.transparency", "0.5f"});
            floatValue = new Float(0.5f);
        }
        this._titleStyle.put("select.button.background.transparency", floatValue);
        Integer intValue = (Integer)resources.getResource("peko.title.style.button.width");
        if (intValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.witdth", "320"});
            intValue = new Integer(320);
        }
        this._titleStyle.put("select.button.witdth", intValue);
        colorValue = (Color)resources.getResource("peko.title.style.button.foreground.selected");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.selected", "white"});
            colorValue = Color.white;
        }
        this._titleStyle.put("select.button.foreground.selected", colorValue);
        colorValue = (Color)resources.getResource("peko.title.style.button.foreground.unselected");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.unselected", "darkGray"});
            colorValue = Color.darkGray;
        }
        this._titleStyle.put("select.button.foreground.unselected", colorValue);
        colorValue = (Color)resources.getResource("peko.title.style.button.foreground.shadow");
        if (colorValue == null) {
            Logger.warn(MessageIDs.CVS3003W, new Object[]{"select.button.foreground.shadow", "black"});
            colorValue = Color.black;
        }
        this._titleStyle.put("select.button.foreground.shadow", colorValue);
        Font fontValue = (Font)resources.getResource("peko.title.style.button.font");
        if (fontValue == null) {
            HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>(17);
            attributes.put(TextAttribute.FAMILY, "SansSerif");
            attributes.put(TextAttribute.SIZE, new Float(16.0f));
            fontValue = FontManager.getInstance().getFont(attributes);
        }
        this._titleStyle.put("select.button.font", fontValue);
    }

    public TextCanvas getTextCanvas() {
        return this._text;
    }

    public StageCanvas getStageCanvas() {
        return this._stage;
    }

    public Stage getStage() {
        return this._stage.getStage();
    }

    public Page getCurrentPage() {
        return this._text.getPage();
    }

    public Page advancesNewPage() {
        Page page = this._text.getPage();
        if (page != null) {
            Page page2 = page;
            synchronized (page2) {
                this.putTextHistory(page);
                page.clearLines();
            }
        } else {
            page = new Page();
            this._text.setPage(page);
        }
        this._currentPage = page;
        return page;
    }

    protected void putTextHistory(Page page) {
        if (page.getLineCount() == 0) {
            return;
        }
        Page previous = null;
        if (this._history.size() >= this._maxHistoryCount) {
            previous = (Page)this._history.remove(0);
            page.clone(previous);
        } else {
            previous = (Page)page.clone();
        }
        this._history.add(previous);
    }

    public boolean readAgain(int index) {
        if (this._selecting) {
            this._select.setVisible(false);
        }
        Page previous = (Page)this._history.get(this._history.size() - index);
        this._text.setPage(previous);
        this._text.updateCanvas();
        this._text.updateText();
        return this._history.size() - index > 0;
    }

    public void returnCurrent() {
        this._text.setPage(this._currentPage);
        this._text.updateCanvas();
        this._text.updateText();
        if (this._selecting) {
            this._select.setVisible(true);
            this._text.setVisible(false);
        }
    }

    public int getPageHistoryCount() {
        return this._history.size();
    }

    public boolean isShowingSelect() {
        return this._selecting;
    }

    public String showSelect(List selectItems) {
        ResourceManager resources = ResourceManager.getInstance();
        String alignment = (String)resources.getResource("peko.canvas.select.align");
        if (alignment == null) {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        } else if ("center".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(1);
        } else if ("left".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(0);
        } else if ("right".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        }
        String valign = (String)resources.getResource("peko.canvas.select.vertical-align");
        if (valign == null) {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"middle"});
            this._select.setVerticalAlignment(1);
        } else if ("top".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(0);
        } else if ("middle".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(1);
        } else if ("bottom".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"middle"});
            this._select.setVerticalAlignment(1);
        }
        Integer columns = (Integer)resources.getResource("peko.canvas.select.columns");
        if (columns == null) {
            Logger.warn(MessageIDs.CVS3002W, new Object[]{"1"});
            this._select.setColumns(1);
        } else {
            this._select.setColumns(columns);
        }
        Integer span = (Integer)resources.getResource("peko.canvas.select.span.column");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3004W, new Object[]{"5"});
            this._select.setColumnSpan(5);
        } else {
            this._select.setColumnSpan(span);
        }
        span = (Integer)resources.getResource("peko.canvas.select.span.row");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3005W, new Object[]{"5"});
            this._select.setRowSpan(5);
        } else {
            this._select.setRowSpan(span);
        }
        span = (Integer)resources.getResource("peko.canvas.select.span.bound");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3007W, new Object[]{"20"});
            this._select.setBoundSpan(20);
        } else {
            this._select.setBoundSpan(span);
        }
        this._select.setButtonStyle(this._selectStyle);
        boolean v = this._text.isVisible();
        if (v) {
            this.hideTextCanvas();
        }
        Page page = this.advancesNewPage();
        page.commit();
        ActionControler controler = PekoSystem.getInstance().getActionControler();
        boolean last = controler.isActive();
        if (controler.getPlayMode() == 1) {
            controler.setPlayModeToNormal();
        }
        controler.setActive(false);
        this._selecting = true;
        this._select.setVisible(true);
        String id = this._select.select(selectItems);
        this._select.setVisible(false);
        this._selecting = false;
        if (v) {
            this._text.updateText();
        }
        controler.setActive(last);
        return id;
    }

    public String showTitle(boolean showTitle) {
        String exitCaption;
        String resumeCaption;
        ResourceManager resources = ResourceManager.getInstance();
        String alignment = (String)resources.getResource("peko.title.style.align");
        if (alignment == null) {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        } else if ("center".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(1);
        } else if ("left".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(0);
        } else if ("right".equalsIgnoreCase(alignment)) {
            this._select.setAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3001W, new Object[]{"center"});
            this._select.setAlignment(1);
        }
        String valign = (String)resources.getResource("peko.title.style.vertical-align");
        if (valign == null) {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"bottom"});
            this._select.setVerticalAlignment(2);
        } else if ("top".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(0);
        } else if ("middle".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(1);
        } else if ("bottom".equalsIgnoreCase(valign)) {
            this._select.setVerticalAlignment(2);
        } else {
            Logger.warn(MessageIDs.CVS3006W, new Object[]{"bottom"});
            this._select.setVerticalAlignment(2);
        }
        Integer columns = (Integer)resources.getResource("peko.title.style.columns");
        if (columns == null) {
            Logger.warn(MessageIDs.CVS3002W, new Object[]{"1"});
            this._select.setColumns(1);
        } else {
            this._select.setColumns(columns);
        }
        String startCaption = (String)resources.getResource("peko.title.caption.start");
        if (startCaption == null) {
            startCaption = "Start";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"start", startCaption});
        }
        if ((resumeCaption = (String)resources.getResource("peko.title.caption.resume")) == null) {
            resumeCaption = "Load";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"resume", resumeCaption});
        }
        if ((exitCaption = (String)resources.getResource("peko.title.caption.exit")) == null) {
            exitCaption = "Exit";
            Logger.warn(MessageIDs.CVS4001W, new Object[]{"exit", exitCaption});
        }
        this._select.setButtonStyle(this._titleStyle);
        Integer span = (Integer)resources.getResource("peko.title.style.span.column");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3004W, new Object[]{"5"});
            this._select.setColumnSpan(5);
        } else {
            this._select.setColumnSpan(span);
        }
        span = (Integer)resources.getResource("peko.title.style.span.row");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3005W, new Object[]{"5"});
            this._select.setRowSpan(5);
        } else {
            this._select.setRowSpan(span);
        }
        span = (Integer)resources.getResource("peko.title.style.span.bound");
        if (span == null) {
            Logger.warn(MessageIDs.CVS3007W, new Object[]{"20"});
            this._select.setBoundSpan(20);
        } else {
            this._select.setBoundSpan(span);
        }
        ArrayList<SelectItem> items = new ArrayList<SelectItem>(3);
        SelectItem item = new SelectItem();
        item.setID("start");
        item.setText(startCaption);
        items.add(item);
        item = new SelectItem();
        item.setID("resume");
        item.setText(resumeCaption);
        items.add(item);
        item = new SelectItem();
        item.setID("exit");
        item.setText(exitCaption);
        items.add(item);
        if (showTitle) {
            String imageName = (String)resources.getResource("peko.title.image");
            if (imageName != null && imageName.length() > 0) {
                this._stage.getStage().setBackgroundImage(imageName);
            } else {
                this._stage.getStage().setBackgroundColor("white");
            }
            this._stage.updateCanvas("mofing");
            String bgmName = (String)resources.getResource("peko.title.bgm", true);
            if (bgmName != null && bgmName.length() > 0) {
                Logger.debug("playBGM: " + bgmName);
                this._stage.getStage().getAudioPlayer().playBGM("opening", bgmName, true);
            }
        }
        this.hideTextCanvas();
        this._selecting = true;
        this._select.setVisible(true);
        String id = this._select.select(items);
        this._select.setVisible(false);
        this._selecting = false;
        return id;
    }

    public void hideTextCanvas() {
        this._text.setVisible(false);
        this._stage.paintPageBackground(false);
    }

    public void showTextCanvas() {
        this._stage.paintPageBackground(true);
        this._text.setVisible(true);
    }

    public synchronized void clearAll() {
        Logger.debug("[canvas] clear All.");
        this._select.setVisible(false);
        this.hideTextCanvas();
        this._select.cancel();
        this._stage.getStage().getAudioPlayer().stopAll();
        this.advancesNewPage();
        this._text.getPage().commit();
        this._history.clear();
        Stage stage = this._stage.getStage();
        stage.exitAll();
        stage.setBackgroundColor("black");
        stage.hideSlide();
        this._stage.updateCanvas("mofing");
        stage.commit();
    }

    public void resume(Session session) {
        Stage stage = this._stage.getStage();
        stage.setBackgroundColor("black");
        stage.updateCanvas("mofing");
        this._stage.setVisible(false);
        try {
            SerializableForm form = (SerializableForm)session.getSessionAttribute("canvasManager");
            this._text.setPage(form.page);
            this._stage.setStage(form.stage);
            form.stage.prepare();
            form.page.rollback();
        }
        catch (Throwable th) {
            Logger.fatal("[canvas] unsupported serializable form.", th);
        }
        this._stage.setVisible(true);
        this._stage.getStage().getAudioPlayer().prepare();
    }

    public void saveState(Session session) {
        SerializableForm serializable = new SerializableForm();
        serializable.page = this._text.getPage();
        serializable.stage = this._stage.getStage();
        session.setSessionAttribute("canvasManager", serializable);
    }

    public static class SerializableForm
    implements Serializable {
        public Stage stage = null;
        public Page page = null;
    }
}

