/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.TextHistoryControler;
import tsukuba_bunko.peko.canvas.CanvasManager;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.util.GenericListener;

public class ActionControler
implements KeyListener,
MouseListener {
    public static final long SM_DEFAULT = -1L;
    public static final long SM_NONSTOP = 0L;
    public static final int PM_SKIP = 1;
    public static final int PM_NORMAL = 0;
    public static final int PM_AUTOMATIC = 2;
    private Object _lock = this;
    private boolean _activity = false;
    private int _playMode = -1;
    private JMenuItem[] _buttons = new JMenuItem[3];
    private JMenuItem _usingEffectMenu = null;
    private JMenuItem _saveMenu = null;
    private JMenuItem _loadMenu = null;
    private JMenuItem _returnTileMenu = null;
    private JMenuItem _readAgainMenu = null;
    private Timer _timer = new Timer(true);
    private TimerTask _lastTask = null;
    private TextHistoryControler _readAgainControler = null;
    private int _lastKeyCode = -1;
    private boolean _waitingActivate = false;
    private boolean _hiddenText = false;
    static /* synthetic */ Class class$0;

    public ActionControler() {
        this.prepareMenuBar();
        this.setPlayModeToNormal();
    }

    public void setActive(boolean activity) {
        this._activity = activity;
        if (!activity) {
            this._lastKeyCode = -1;
        } else if (this._playMode != 0 && this._waitingActivate) {
            Object object = this._lock;
            synchronized (object) {
                if (this._waitingActivate) {
                    this._lock.notify();
                }
            }
        }
    }

    public boolean isActive() {
        return this._activity;
    }

    public synchronized void setSaveEnabled(boolean enabled) {
        this._saveMenu.setEnabled(enabled);
    }

    public int getPlayMode() {
        return this._playMode;
    }

    protected void setPlayMode(int playMode) {
        this._playMode = playMode;
        this._buttons[playMode].setSelected(true);
        PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect(!this._usingEffectMenu.isSelected() && playMode != 1);
        if (this._playMode != 0 && !PekoSystem.getInstance().getCanvasManager().isShowingSelect()) {
            this.start();
        }
    }

    public void setPlayModeToSKip() {
        this.setPlayMode(1);
    }

    public void setPlayModeToNormal() {
        this.setPlayMode(0);
    }

    public void setPlayModeToAutomatic() {
        this.setPlayMode(2);
    }

    public void changeUsingEffect() {
        PekoSystem.getInstance().getCanvasManager().getStageCanvas().setUsingEffect(!this._usingEffectMenu.isSelected() && this._playMode != 1);
    }

    public void showReadAgain() {
        this.setActive(false);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(false);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        if (this._readAgainControler == null) {
            this._readAgainControler = new TextHistoryControler();
            this._readAgainControler.setLocationRelativeTo(PekoSystem.getInstance().getMainWindow());
        }
        this._readAgainControler.show();
        this.setActive(true);
        this._saveMenu.setEnabled(true);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
    }

    public void showLoadDialog() {
        this.setActive(false);
        this._loadMenu.setEnabled(false);
        PekoSystem system = PekoSystem.getInstance();
        if (!system.load()) {
            this.setActive(true);
        }
        this._loadMenu.setEnabled(true);
    }

    public synchronized void showSaveDialog() {
        PekoSystem system = PekoSystem.getInstance();
        this.setActive(false);
        this._saveMenu.setEnabled(false);
        system.save();
        this._saveMenu.setEnabled(true);
        this.setActive(true);
    }

    public void returnTitle() {
        this.returnTitle(false);
    }

    public void returnTitle(boolean silence) {
        this.setActive(false);
        this.setPlayMode(0);
        this._saveMenu.setEnabled(false);
        this._loadMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(false);
        this._readAgainMenu.setEnabled(false);
        if (silence) {
            PekoSystem.getInstance().showTitle();
        } else {
            String title;
            ResourceManager resources = ResourceManager.getInstance();
            String message = (String)resources.getResource("peko.dialog.return-title.message");
            if (message == null) {
                message = "Are you return title ?";
            }
            if ((title = (String)resources.getResource("peko.dialog.return-title.title")) == null) {
                title = "Confirm";
            }
            if (JOptionPane.showConfirmDialog(PekoSystem.getInstance().getMainWindow(), message, title, 2) == 0) {
                PekoSystem.getInstance().showTitle();
            }
        }
        this._saveMenu.setEnabled(true);
        this._returnTileMenu.setEnabled(true);
        this._readAgainMenu.setEnabled(true);
    }

    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._lastTask != null) {
                this._lastTask.cancel();
            }
            this._lastTask = null;
            this._lock.notify();
            Logger.debug("[system.controler] notify to finish wait.");
        }
    }

    public void stop() {
        this.stop(-1L);
    }

    public void stop(long wait) {
        Object object;
        Logger.debug("[system.controler] stop :" + wait);
        if (wait != 0L && this._playMode != 1) {
            if (wait < 0L) {
                object = this._lock;
                synchronized (object) {
                    try {
                        if (this._playMode == 2) {
                            TimerTask task = new TimerTask(){

                                public void run() {
                                    Object object = ActionControler.this._lock;
                                    synchronized (object) {
                                        ActionControler.this._lock.notify();
                                    }
                                }
                            };
                            this._timer.schedule(task, 1000L);
                            this._lastTask = task;
                        }
                        this._lock.wait();
                    }
                    catch (InterruptedException ie) {
                        Logger.debug("[system.action] interrupted.");
                    }
                }
            }
            object = this._lock;
            synchronized (object) {
                try {
                    TimerTask task = new TimerTask(){

                        public void run() {
                            Object object = ActionControler.this._lock;
                            synchronized (object) {
                                ActionControler.this._lock.notify();
                            }
                        }
                    };
                    this._timer.schedule(task, wait);
                    this._lastTask = task;
                    this._lock.wait();
                }
                catch (InterruptedException ie) {
                    Logger.debug("[system.action] interrupted.");
                }
            }
        }
        if (!this._activity && this._lastTask != null) {
            object = this._lock;
            synchronized (object) {
                if (!this._activity && this._lastTask != null) {
                    this._waitingActivate = true;
                    try {
                        this._lock.wait();
                        this._lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._waitingActivate = false;
                }
            }
        }
        this._lastTask = null;
        Logger.debug("[system.controler] finish wait.");
    }

    private void prepareMenuBar() {
        PekoSystem system = PekoSystem.getInstance();
        ResourceManager resources = ResourceManager.getInstance();
        JMenuBar menubar = new JMenuBar();
        JMenu menu = null;
        JMenuItem item = null;
        menu = new JMenu((String)resources.getResource("peko.menu.system.menu-caption"));
        menu.setMnemonic('S');
        menubar.add(menu);
        item = new JMenuItem((String)resources.getResource("peko.menu.system.save"));
        item.setEnabled(false);
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz, "actionPerformed", "showSaveDialog", true);
        menu.add(item);
        this._saveMenu = item;
        item = new JMenuItem((String)resources.getResource("peko.menu.system.load"));
        item.setEnabled(false);
        item.setMnemonic('O');
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz2, "actionPerformed", "showLoadDialog", true);
        menu.add(item);
        this._loadMenu = item;
        menu.addSeparator();
        item = new JMenuItem((String)resources.getResource("peko.menu.system.return-title"));
        item.setEnabled(false);
        item.setMnemonic('T');
        item.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz3, "actionPerformed", "returnTitle", true);
        menu.add(item);
        this._returnTileMenu = item;
        item = new JMenuItem((String)resources.getResource("peko.menu.system.read-again"));
        item.setEnabled(false);
        item.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        item.setMnemonic('R');
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz4, "actionPerformed", "showReadAgain");
        menu.add(item);
        this._readAgainMenu = item;
        menu.addSeparator();
        item = new JMenuItem((String)resources.getResource("peko.menu.system.exit"));
        item.setMnemonic('X');
        item.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, system, clazz5, "actionPerformed", "exit");
        menu.add(item);
        menu = new JMenu((String)resources.getResource("peko.menu.config.menu-caption"));
        menu.setMnemonic('C');
        menubar.add(menu);
        JMenu submenu = new JMenu((String)resources.getResource("peko.menu.config.playmode.menu-caption"));
        submenu.setMnemonic('P');
        menu.add(submenu);
        ButtonGroup group = new ButtonGroup();
        item = new JRadioButtonMenuItem((String)resources.getResource("peko.menu.config.playmode.normal"));
        item.setMnemonic('N');
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz6, "actionPerformed", "setPlayModeToNormal");
        group.add(item);
        submenu.add(item);
        this._buttons[0] = item;
        item = new JRadioButtonMenuItem((String)resources.getResource("peko.menu.config.playmode.automatic"));
        item.setMnemonic('A');
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz7, "actionPerformed", "setPlayModeToAutomatic");
        group.add(item);
        submenu.add(item);
        this._buttons[2] = item;
        item = new JRadioButtonMenuItem((String)resources.getResource("peko.menu.config.playmode.skip"));
        item.setMnemonic('S');
        item.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz8, "actionPerformed", "setPlayModeToSKip");
        group.add(item);
        submenu.add(item);
        this._buttons[1] = item;
        menu.addSeparator();
        item = new JCheckBoxMenuItem((String)resources.getResource("peko.menu.config.use-effect"));
        item.setSelected(false);
        item.setMnemonic('E');
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, this, clazz9, "actionPerformed", "changeUsingEffect");
        menu.add(item);
        this._usingEffectMenu = item;
        menu = new JMenu((String)resources.getResource("peko.menu.help.menu-caption"));
        menu.setMnemonic('H');
        menubar.add(menu);
        item = new JMenuItem((String)resources.getResource("peko.menu.help.help-contents"));
        item.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        item.setMnemonic('H');
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem((String)resources.getResource("peko.menu.help.version"));
        item.setMnemonic('A');
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, system, clazz10, "actionPerformed", "showGameVersionInfo");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem((String)resources.getResource("peko.menu.help.about-pvns"));
        item.setMnemonic('P');
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("java.awt.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericListener.connect(item, system, clazz11, "actionPerformed", "showSystemVersionInfo");
        menu.add(item);
        JFrame mainWindow = system.getMainWindow();
        mainWindow.setJMenuBar(menubar);
        mainWindow.pack();
        mainWindow.setResizable(false);
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseClicked(MouseEvent ev) {
        int code = ev.getModifiers();
        if (this._activity && code == 16) {
            this.start();
        } else {
            if (this._playMode == 1 && code == 4) {
                this.setPlayModeToNormal();
                return;
            }
            if (this._hiddenText) {
                CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
                canvasManager.hideTextCanvas();
                this.setActive(true);
            }
        }
    }

    public void keyPressed(KeyEvent ev) {
        if (this._activity) {
            int code = ev.getKeyCode();
            if (this._lastKeyCode == -1) {
                this._lastKeyCode = code;
            } else if (this._lastKeyCode != code) {
                this._lastKeyCode = -1;
            }
        }
    }

    public void keyReleased(KeyEvent ev) {
        int code = ev.getKeyCode();
        if (code != this._lastKeyCode) {
            this._lastKeyCode = -1;
            return;
        }
        if (this._hiddenText) {
            CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
            canvasManager.showTextCanvas();
            this._saveMenu.setEnabled(true);
            this._loadMenu.setEnabled(true);
            this._returnTileMenu.setEnabled(true);
            this._hiddenText = false;
        } else if (this._activity && code == 10) {
            this.start();
        } else if (this._playMode != 0 && code == 27) {
            this.setPlayModeToNormal();
        } else if (!this._hiddenText && code == 32) {
            CanvasManager canvasManager = PekoSystem.getInstance().getCanvasManager();
            this._saveMenu.setEnabled(false);
            this._loadMenu.setEnabled(false);
            this._returnTileMenu.setEnabled(false);
            canvasManager.hideTextCanvas();
            this._hiddenText = true;
        }
        this._lastKeyCode = -1;
    }

    public void keyTyped(KeyEvent ev) {
    }
}

