/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlme.decoder;

import java.io.IOException;
import java.io.InputStream;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.PushBackStream;

public final class BitStream {
    static final byte INITIAL_SYNC = 0;
    static final byte STRICT_SYNC = 1;
    private static final int BUFFER_INT_SIZE = 433;
    private static final int[] bitmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private static PushBackStream source;
    private static final int[] framebuffer;
    private static int framesize;
    private static final byte[] frame_bytes;
    private static int wordpointer;
    private static int bitindex;
    private static int syncword;
    private static boolean single_ch_mode;
    private static final Header header;
    private static final byte[] syncbuf;
    static int read;
    static boolean sync;
    static int sum;
    static int returnvalue;
    static int bytesread;
    static int headerstring;
    static int b;
    static int k;
    static byte b0;
    static byte b1;
    static byte b2;
    static byte b3;

    public BitStream(InputStream inputStream) {
        source = new PushBackStream(inputStream, 512);
        this.closeFrame();
    }

    public final boolean isSyncCurrentPosition(int n) throws IOException {
        read = source.read(syncbuf, 0, 4);
        if (read > 0) {
            source.unread(syncbuf, 0, read);
            if (read == 4) {
                headerstring = syncbuf[0] << 24 & 0xFF000000 | syncbuf[1] << 16 & 0xFF0000 | syncbuf[2] << 8 & 0xFF00 | syncbuf[3] << 0 & 0xFF;
                return this.isSyncMark(headerstring, n, syncword);
            }
        }
        return true;
    }

    public final boolean isSyncMark(int n, int n2, int n3) {
        if (n2 == 0) {
            sync = (n & 0xFFF00000) == -1048576;
        } else {
            boolean bl = (n & 0xFFF80C00) == n3 && (n & 0xC0) == 192 == single_ch_mode ? true : (sync = false);
        }
        if (sync && (sync = (n >>> 10 & 3) != 3) && (sync = (n >>> 17 & 3) != 0)) {
            sync = (n >>> 19 & 3) != 1;
        }
        return sync;
    }

    public final int readbits(int n) {
        sum = bitindex + n;
        if (sum <= 32) {
            returnvalue = framebuffer[wordpointer] >>> 32 - sum & bitmask[n];
            if ((bitindex += n) == 32) {
                bitindex = 0;
                ++wordpointer;
            }
            return returnvalue;
        }
        returnvalue = (framebuffer[wordpointer++] & 0xFFFF) << 16 & 0xFFFF0000 | (framebuffer[wordpointer] & 0xFFFF0000) >>> 16 & 0xFFFF;
        returnvalue >>>= 48 - sum;
        bitindex = sum - 32;
        return returnvalue &= bitmask[n];
    }

    public void close() throws IOException {
        source.close();
    }

    public Header readFrame() throws IOException {
        header.read_header(this);
        return header;
    }

    public final void unreadFrame() throws IOException {
        if (wordpointer == -1 && bitindex == -1 && framesize > 0) {
            source.unread(frame_bytes, 0, framesize);
        }
    }

    public void closeFrame() {
        bitindex = -1;
        wordpointer = -1;
        framesize = -1;
    }

    final void set_syncword(int n) {
        syncword = n & 0xFFFFFF3F;
        single_ch_mode = (n & 0xC0) == 192;
    }

    int syncHeader(byte by) throws IOException {
        bytesread = source.read(syncbuf, 0, 3);
        if (bytesread != 3) {
            return -1;
        }
        headerstring = syncbuf[0] << 16 & 0xFF0000 | syncbuf[1] << 8 & 0xFF00 | syncbuf[2] << 0 & 0xFF;
        do {
            headerstring <<= 8;
            if (source.read(syncbuf, 3, 1) == 1) continue;
            return -1;
        } while (!this.isSyncMark(headerstring |= syncbuf[3] & 0xFF, by, syncword));
        return headerstring;
    }

    final void read_frame_data(int n) throws IOException {
        if (n >= 0) {
            framesize = n;
            bitindex = -1;
            wordpointer = -1;
            source.read(frame_bytes, 0, n);
        }
    }

    final void parse_frame() {
        k = 0;
        b = 0;
        while (k < framesize) {
            b0 = frame_bytes[k];
            if (k + 3 < framesize) {
                b3 = frame_bytes[k + 3];
                b2 = frame_bytes[k + 2];
                b1 = frame_bytes[k + 1];
            } else if (k + 2 < framesize) {
                b3 = 0;
                b2 = frame_bytes[k + 2];
                b1 = frame_bytes[k + 1];
            } else if (k + 1 < framesize) {
                b3 = 0;
                b2 = 0;
                b1 = frame_bytes[k + 1];
            }
            BitStream.framebuffer[BitStream.b++] = b0 << 24 & 0xFF000000 | b1 << 16 & 0xFF0000 | b2 << 8 & 0xFF00 | b3 & 0xFF;
            k += 4;
        }
        bitindex = 0;
        wordpointer = 0;
    }

    static {
        framebuffer = new int[433];
        frame_bytes = new byte[1732];
        header = new Header();
        syncbuf = new byte[4];
    }
}

