unit Unit6; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs,
  ButtonPanel, StdCtrls, Buttons, list_utils;

type

  { TFormInput }

  TFormInput = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ButtonPanel1: TButtonPanel;
    CheckBox1: TCheckBox;
    Editinputquery: TEdit;
    LabelLow: TLabel;
    Labelspac2: TLabel;
    LabelUp: TLabel;
    LabelTimestamp: TLabel;
    LabelWarning: TLabel;
    OpenDialog3: TOpenDialog;
    procedure BitBtn2Click(Sender: TObject);
    procedure EditinputqueryKeyPress(Sender: TObject; var Key: char);
    procedure LabelLowClick(Sender: TObject);
    procedure LabelTimestampClick(Sender: TObject);
    procedure LabelUpClick(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FormInput: TFormInput;
  tsstyle:integer;

implementation

{ TFormInput }

procedure apply_timestamptofilename(var s:ansistring);
var
   dt_stamp,s0,s1,s2:ansistring;
begin
case tsstyle of
   0: dt_stamp:=formatdatetime('.yyyymmdd.hhnnss',now);
   1: dt_stamp:=formatdatetime('.yyyymmdd',now);
   2: dt_stamp:=formatdatetime('yyyymmdd.hhnnss.',now);
   3: dt_stamp:=formatdatetime('yyyymmdd.',now);
   end;
s0:=extractfilepath(s);
s1:=extractfilename(s);
cutextension(s1);
s2:=extractfileext(s);
case tsstyle of
   2: s1:=dt_stamp+s1;
   3: s1:=dt_stamp+s1;
   else s1:=s1+dt_stamp;
end;
s:=s0+s1+s2;
end;

procedure TFormInput.EditinputqueryKeyPress(Sender: TObject; var Key: char);
begin
if Key=char(13) then
   begin
   FormInput.Close;
   FormInput.ModalResult:=1;
   end;
end;

procedure TFormInput.LabelLowClick(Sender: TObject);
begin
Editinputquery.Text:=LowerCase(Editinputquery.Text);
end;

procedure TFormInput.LabelTimestampClick(Sender: TObject);
var
   s:ansistring;
begin
s:=Editinputquery.Text;
apply_timestamptofilename(s);
Editinputquery.Text:=s;
end;

procedure TFormInput.LabelUpClick(Sender: TObject);
begin
Editinputquery.Text:=UpperCase(Editinputquery.Text);
end;

procedure TFormInput.BitBtn2Click(Sender: TObject);
begin
if FormInput.OpenDialog3.Execute then
   if FormInput.OpenDialog3.FileName<>'' then
      begin
      {$IFDEF MSWINDOWS}
      FormInput.Editinputquery.Caption:='"'+FormInput.OpenDialog3.FileName+'"';
      {$ELSE}
      FormInput.Editinputquery.Caption:=''''+FormInput.OpenDialog3.FileName+'''';
      {$ENDIF}
      end;
end;

initialization
  {$I unit6.lrs}

end.

