[Setup]
AppId={{7FE8B3DF-A738-4DD5-AC0F-B2B72DF7C109}
AppName=PeaUtils
AppVerName=PeaUtils 1.0
AppPublisher=Giorgio Tani
AppPublisherURL=http://www.peazip.org
AppSupportURL=http://www.peazip.org
AppUpdatesURL=http://www.peazip.org
DefaultDirName={pf}\PeaUtils
DisableDirPage=yes
DefaultGroupName=PeaUtils
DisableProgramGroupPage=yes
LicenseFile=C:\input-peautils\peautils-1.0.WINDOWS\copying.txt
InfoBeforeFile=C:\input-peautils\peautils-1.0.WINDOWS\readme_peautils.txt
OutputDir=C:\output\
OutputBaseFilename=peautils-1.0.WINDOWS
SetupIconFile=peazip-icon-green.ico
Compression=lzma2
SolidCompression=yes
ChangesAssociations=yes

[Languages]
Name: "default"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "C:\input-peautils\peautils-1.0.WINDOWS\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[INI]
Filename: "{app}\peautils.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://www.peazip.org"

[Icons]
Name: "{group}\PeaUtils"; Filename: "{app}\pea.exe"
Name: "{group}\{cm:ProgramOnTheWeb,PeaUtils}"; Filename: "{app}\peautils.url"
Name: "{group}\{cm:UninstallProgram,PeaUtils}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\PeaUtils"; Filename: "{app}\pea.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\PeaUtils"; Filename: "{app}\pea.exe"; Tasks: quicklaunchicon

[Run]

[InstallDelete]
Type: filesandordirs; Name: "{app}\lang"

[UninstallDelete]
Type: files; Name: "{app}\peautils.url"

[CustomMessages]   
contextutils_Caption=Context menu file utilities
contextutils_Description=Create application's entries in system's context menu
contextutils_cbanalyze_Caption0=Select function
contextutils_cbdelete_Caption0=Secure delete
contextutils_cbcompare_Caption0=Compare byte to byte
contextutils_cbhexp_Caption0=Hex preview
contextutils_cbstr_Caption0=Display environment variables
contextutils_cblist_Caption0=Analyze files and folders
contextutils_cbsplit_Caption0=Split and join file
contextutils_cbnone_Caption0=No context menu entry (override selection)
contextutils_cbcascaded_Caption0=Cascaded menu
 				
[Code]
var
  Bevel1contextutils: TBevel;
  cbcontextutilsanalyze: TCheckBox;
  cbcontextutilsnone: TCheckBox;
  cbcontextutilscascaded: TCheckBox;
  cbcontextutilscrc32: TCheckBox;
  cbcontextutilscrc64: TCheckBox;
  cbcontextutilsmd5: TCheckBox;
  cbcontextutilssha1: TCheckBox; 
  cbcontextutilssha256: TCheckBox;
  cbcontextutilssha3256: TCheckBox; 
  cbcontextutilsdelete: TCheckBox;
  cbcontextutilscompare: TCheckBox;
  cbcontextutilshexp: TCheckBox;
  cbcontextutilsstr: TCheckBox;
  cbcontextutilslist: TCheckBox;
  cbcontextutilsplit: TCheckBox; 
			
{ contextutils_Activate }

procedure contextutils_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ contextutils_ShouldSkipPage }

function contextutils_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
Result := False;
end;

{ contextutils_BackButtonClick }

function contextutils_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ contextutils_NextkButtonClick }

function contextutils_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ contextutils_CancelButtonClick }

procedure contextutils_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

{ context_CreatePage }

function contextutils_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:contextutils_Caption}'),
    ExpandConstant('{cm:contextutils_Description}')
  );

{ Bevel1contextutils }
  Bevel1contextutils := TBevel.Create(Page);
  with Bevel1contextutils do
  begin
    Parent := Page.Surface;
    Left := ScaleX(8);
    Top := ScaleY(2);
    Width := ScaleX(396);
    Height := ScaleY(202);
  end;
  
  { cbcontextutilsanalyze }
  cbcontextutilsanalyze := TCheckBox.Create(Page);
  with cbcontextutilsanalyze do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbanalyze_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(8);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    Enabled := False;
    State := cbChecked;
    TabOrder := 2;
  end;

  { cbcontextutilscrc32 }
  cbcontextutilscrc32 := TCheckBox.Create(Page);
  with cbcontextutilscrc32 do
  begin
    Parent := Page.Surface;
    Caption := 'CRC32';
    Left := ScaleX(16);
    Top := ScaleY(28);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 3;
  end;

  { cbcontextutilscrc64 }
  cbcontextutilscrc64 := TCheckBox.Create(Page);
  with cbcontextutilscrc64 do
  begin
    Parent := Page.Surface;
    Caption := 'CRC64';
    Left := ScaleX(16);
    Top := ScaleY(48);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 4;
  end;

  { cbcontextutilsmd5 }
  cbcontextutilsmd5 := TCheckBox.Create(Page);
  with cbcontextutilsmd5 do
  begin
    Parent := Page.Surface;
    Caption := 'MD5';
    Left := ScaleX(16);
    Top := ScaleY(68);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 5;
  end;

  { cbcontextutilssha1 }
  cbcontextutilssha1 := TCheckBox.Create(Page);
  with cbcontextutilssha1 do
  begin
    Parent := Page.Surface;
    Caption := 'SHA1';
    Left := ScaleX(16);
    Top := ScaleY(88);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 6;
  end;

  { cbcontextutilssha256 }
  cbcontextutilssha256 := TCheckBox.Create(Page);
  with cbcontextutilssha256 do
  begin
    Parent := Page.Surface;
    Caption := 'SHA256';
    Left := ScaleX(16);
    Top := ScaleY(108);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 7;
  end;

  { cbcontextutilssha3256 }
  cbcontextutilssha3256 := TCheckBox.Create(Page);
  with cbcontextutilssha3256 do
  begin
    Parent := Page.Surface;
    Caption := 'SHA3-256';
    Left := ScaleX(16);
    Top := ScaleY(128);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 8;
  end;

  { cbcontextutillist }
  cbcontextutilslist := TCheckBox.Create(Page);
  with cbcontextutilslist do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cblist_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(8);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 9;
  end;

  { cbcontextutilcompare }
  cbcontextutilscompare := TCheckBox.Create(Page);
  with cbcontextutilscompare do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbcompare_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(28);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 10;
  end;

  { cbcontextutilhexp }
  cbcontextutilshexp := TCheckBox.Create(Page);
  with cbcontextutilshexp do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbhexp_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(48);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 11;
  end;

  { cbcontextutilstr }
  cbcontextutilsstr := TCheckBox.Create(Page);
  with cbcontextutilsstr do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbstr_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(68);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := False;
    State := cbUnChecked;
    TabOrder := 12;
  end;

  { cbcontextutildelete }
  cbcontextutilsdelete := TCheckBox.Create(Page);
  with cbcontextutilsdelete do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbdelete_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(88);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 13;
  end;

  { cbcontextutilsplit }
  cbcontextutilsplit := TCheckBox.Create(Page);
  with cbcontextutilsplit do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbsplit_Caption0}');
    Left := ScaleX(212);
    Top := ScaleY(108);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 14;
  end;


  { cbcontextutilsnone }
  cbcontextutilsnone := TCheckBox.Create(Page);
  with cbcontextutilsnone do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbnone_Caption0}');
    Left := ScaleX(8);
    Top := ScaleY(210);
    Width := ScaleX(321);
    Height := ScaleY(25);
    TabOrder := 0;
  end;
  
  { cbcontextutilscascaded }
  cbcontextutilscascaded := TCheckBox.Create(Page);
  with cbcontextutilscascaded do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:contextutils_cbcascaded_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(180);
    Width := ScaleX(185);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 1;
  end;
  if (GetWindowsVersion shr 24 <6) or
     ((GetWindowsVersion shr 24 =6) and ((GetWindowsVersion shr 16) and $FF =0))
     then cbcontextutilscascaded.visible:=false;

  with Page do
  begin
    OnActivate := @contextutils_Activate;
    OnShouldSkipPage := @contextutils_ShouldSkipPage;
    OnBackButtonClick := @contextutils_BackButtonClick;
    OnNextButtonClick := @contextutils_NextButtonClick;
    OnCancelButtonClick := @contextutils_CancelButtonClick;
  end;

  Result := Page.ID;
end;
    
			
				{ InitializeWizard }
				
				procedure InitializeWizard();
				begin		
				  contextutils_CreatePage(wpSelectDir);
				end;

function shouldskippage(CurPageID: Integer): Boolean;
begin

end;

procedure clearcontextlegacy;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Select function');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > CRC32');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > CRC64');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > MD5');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > SHA1');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > SHA256');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > SHA3-256');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Analyze files and folders');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Compare byte to byte');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Hex preview');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Display environment variables');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Secure delete');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Split file');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils > Join file');

RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Select function');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > CRC32');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > CRC64');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > MD5');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > SHA1');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > SHA256');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > SHA3-256');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Analyze files and folders');
//RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Compare byte to byte');
//RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Hex preview');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Display environment variables');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Secure delete');
//RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Split file');
//RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils > Join file');
end;

procedure clearcontextseven;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaUtils');
RegDeleteKeyIncludingSubkeys(HKCR, 'Directory\shell\PeaUtils');
if IsWin64 then
   begin
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join');
   end
else
   begin
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join');
   end;
end;

procedure contextseven;
var
  sutils,sutilsf:ansistring;
begin

      sutils:='';

      sutils:=sutils+'PeaUtils.analyze; ';
      if cbcontextutilslist.state = cbChecked then sutils:=sutils+'PeaUtils.anlist; ';
      if cbcontextutilscrc32.state = cbChecked then sutils:=sutils+'PeaUtils.crc32; ';
      if cbcontextutilscrc64.state = cbChecked then sutils:=sutils+'PeaUtils.crc64; ';
      if cbcontextutilsmd5.state = cbChecked then sutils:=sutils+'PeaUtils.md5; ';
      if cbcontextutilssha1.state = cbChecked then sutils:=sutils+'PeaUtils.sha1; ';
      if cbcontextutilssha256.state = cbChecked then sutils:=sutils+'PeaUtils.sha256; ';
      if cbcontextutilssha3256.state = cbChecked then sutils:=sutils+'PeaUtils.sha3256; ';   
      if cbcontextutilscompare.state = cbChecked then sutils:=sutils+'PeaUtils.compare; ';
      if cbcontextutilshexp.state = cbChecked then sutils:=sutils+'PeaUtils.hexp; ';
      if cbcontextutilsstr.state = cbChecked then sutils:=sutils+'PeaUtils.envstr; ';
      if cbcontextutilsdelete.state = cbChecked then sutils:=sutils+'PeaUtils.sdelete; ';
      if cbcontextutilsplit.state = cbChecked then sutils:=sutils+'PeaUtils.split; '+'PeaUtils.join; ';           

      RegWriteStringValue(HKCR, '*\shell\PeaUtils', 'SubCommands', sutils);
      RegWriteStringValue(HKCR, '*\shell\PeaUtils', 'MultiSelectModel', 'single');
      RegWriteStringValue(HKCR, '*\shell\PeaUtils', 'Icon', ExpandConstant('"{app}\pea.exe",0'));
      RegWriteStringValue(HKCR, '*\shell\PeaUtils\command', '', '');
      RegDeleteValue(HKCR, '*\shell\PeaUtils\command', '');

      sutilsf:='';

      sutilsf:=sutilsf+'PeaUtils.analyze; ';
      if cbcontextutilslist.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.anlist; ';
      if cbcontextutilscrc32.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.crc32; ';
      if cbcontextutilscrc64.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.crc64; ';
      if cbcontextutilsmd5.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.md5; ';
      if cbcontextutilssha1.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.sha1; ';
      if cbcontextutilssha256.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.sha256; ';
      if cbcontextutilssha3256.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.sha3256; '; 
      //if cbcontextutilscompare.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.compare; ';
      //if cbcontextutilshexp.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.hexp; ';
      if cbcontextutilsstr.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.envstr; ';
      if cbcontextutilsdelete.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.sdelete; ';
      //if cbcontextutilsplit.state = cbChecked then sutilsf:=sutilsf+'PeaUtils.split; '+'PeaUtils.join; ';

      RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils', 'SubCommands', sutilsf);
      RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils', 'MultiSelectModel', 'single');
      RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils', 'Icon', ExpandConstant('"{app}\pea.exe",0'));
      RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils\command', '', '');
      RegDeleteValue(HKCR, 'Directory\shell\PeaUtils\command', '');

      if IsWin64 then   
        begin
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze', '', 'Select function');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "7" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist', '', 'Analyze files and folders');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "LIST" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32', '', 'CRC32');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC32" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64', '', 'CRC64');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC64" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5', '', 'MD5');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "MD5" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1', '', 'SHA1');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA1" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256', '', 'SHA256');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA256" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256', '', 'SHA3-256');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA3_256" "ON" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare', '', 'Compare byte to byte');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare\command', '', ExpandConstant('"{app}\PEA.EXE" "COMPARE" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp', '', 'Hex preview');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp\command', '', ExpandConstant('"{app}\PEA.EXE" "HEXPREVIEW" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr', '', 'Display environment variables');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr\command', '', ExpandConstant('"{app}\PEA.EXE" "ENVSTR"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete', '', 'Secure delete');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "14" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split', '', 'Split file');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split\command', '', ExpandConstant('"{app}\PEA.EXE" "RFS" "AUTONAME" "ASK" "NONE" "BATCH" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join', '', 'Join file');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join\command', '', ExpandConstant('"{app}\PEA.EXE" "RFJ" "%1" "BATCH" "AUTONAME"'));
        end
      else
        begin
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze', '', 'Select function');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.analyze\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "7" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist', '', 'Analyze files and folders');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.anlist\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "LIST" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32', '', 'CRC32');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc32\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC32" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64', '', 'CRC64');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.crc64\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC64" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5', '', 'MD5');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.md5\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "MD5" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1', '', 'SHA1');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha1\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA1" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256', '', 'SHA256');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA256" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256', '', 'SHA3-256');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sha3256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA3_256" "ON" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare', '', 'Compare byte to byte');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.compare\command', '', ExpandConstant('"{app}\PEA.EXE" "COMPARE" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp', '', 'Hex preview');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.hexp\command', '', ExpandConstant('"{app}\PEA.EXE" "HEXPREVIEW" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr', '', 'Display environment variables');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.envstr\command', '', ExpandConstant('"{app}\PEA.EXE" "ENVSTR"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete', '', 'Secure delete');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.sdelete\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "14" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split', '', 'Split file');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.split\command', '', ExpandConstant('"{app}\PEA.EXE" "RFS" "AUTONAME" "ASK" "NONE" "BATCH" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join', '', 'Join file');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaUtils.join\command', '', ExpandConstant('"{app}\PEA.EXE" "RFJ" "%1" "BATCH" "AUTONAME"'));
        end;
end;

procedure contextlegacy;
begin           

    RegWriteStringValue(HKCR, '*\shell\PeaUtils > Select function\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "7" "%1"'));
    RegWriteStringValue(HKCR, '*\shell\PeaUtils > Select function', 'MultiSelectModel', 'single');
    RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Select function\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "7" "%1"'));
    RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Select function', 'MultiSelectModel', 'single');
    if cbcontextutilslist.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Analyze files and folders\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "LIST" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Analyze files and folders', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Analyze files and folders\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "LIST" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Analyze files and folders', 'MultiSelectModel', 'single');
       end;    
    if cbcontextutilscrc32.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > CRC32\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC32" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > CRC32', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > CRC32\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC32" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > CRC32', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilscrc64.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > CRC64\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC64" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > CRC64', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > CRC64\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "CRC64" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > CRC64', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilsmd5.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > MD5\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "MD5" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > MD5', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > MD5\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "MD5" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > MD5', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilssha1.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA1\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA1" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA1', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA1\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA1" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA1', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilssha256.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA256" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA256', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA256" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA256', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilssha3256.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA3-256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA3_256" "ON" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > SHA3-256', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA3-256\command', '', ExpandConstant('"{app}\PEA.EXE" "CHECK" "HEX" "SHA3_256" "ON" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > SHA3-256', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilscompare.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Compare byte to byte\command', '', ExpandConstant('"{app}\PEA.EXE" "COMPARE" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Compare byte to byte', 'MultiSelectModel', 'single');
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Compare byte to byte\command', '', ExpandConstant('"{app}\PEA.EXE" "COMPARE" "%1"'));
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Compare byte to byte', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilshexp.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Hex preview\command', '', ExpandConstant('"{app}\PEA.EXE" "HEXPREVIEW" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Hex preview', 'MultiSelectModel', 'single');
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Hex preview\command', '', ExpandConstant('"{app}\PEA.EXE" "HEXPREVIEW" "%1"'));
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Hex preview', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilsstr.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Display environment variables\command', '', ExpandConstant('"{app}\PEA.EXE" "ENVSTR"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Display environment variables', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Display environment variables\command', '', ExpandConstant('"{app}\PEA.EXE" "ENVSTR"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Display environment variables', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilsdelete.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Secure delete\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "14" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Secure delete', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Secure delete\command', '', ExpandConstant('"{app}\PEA.EXE" "PEAUTILS" "14" "%1"'));
       RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Secure delete', 'MultiSelectModel', 'single');
       end;
    if cbcontextutilsplit.state = cbChecked then
       begin
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Split file\command', '', ExpandConstant('"{app}\PEA.EXE" "RFS" "AUTONAME" "ASK" "NONE" "BATCH" "%1"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Split file', 'MultiSelectModel', 'single');
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Split file\command', '', ExpandConstant('"{app}\PEA.EXE" "RFS" "AUTONAME" "ASK" "NONE" "BATCH" "%1"'));
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Split file', 'MultiSelectModel', 'single');
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Join file\command', '', ExpandConstant('"{app}\PEA.EXE" "RFJ" "%1" "BATCH" "AUTONAME"'));
       RegWriteStringValue(HKCR, '*\shell\PeaUtils > Join file', 'MultiSelectModel', 'single');
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Join file\command', '', ExpandConstant('"{app}\PEA.EXE" "RFJ" "%1" "BATCH" "AUTONAME"'));
       //RegWriteStringValue(HKCR, 'Directory\shell\PeaUtils > Join file', 'MultiSelectModel', 'single');
       end;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
var
  ResultCode: Integer;
  ErrorCode: Integer;
begin

if CurPageID = wpReady then
  begin

    clearcontextlegacy;
    clearcontextseven;
    BringToFrontAndRestore();

    //context menu
    if cbcontextutilsnone.state = cbUnchecked then
       if (GetWindowsVersion shr 24 >=6) and ((GetWindowsVersion shr 16) and $FF >=1) then 
          if cbcontextutilscascaded.state = cbChecked then contextseven
          else contextlegacy
       else contextlegacy;
    BringToFrontAndRestore();
end;
Result := True;
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
if CurUninstallStep = usDone then
  begin
  clearcontextlegacy;
  clearcontextseven; //delete context menu items
  BringToFrontAndRestore();
  end;
end;