[Setup]
AppId={{9C0DB3E9-FE86-4338-B636-3D551A980FB0}
AppName=PeaExtractor
AppVerName=PeaExtractor 1.2 (WIN64)
AppPublisher=Giorgio Tani
AppPublisherURL=http://peaextractor.sourceforge.net
AppSupportURL=http://peaextractor.sourceforge.net
AppUpdatesURL=http://peaextractor.sourceforge.net
DefaultDirName={pf}\PeaExtractor
DisableDirPage=yes
DefaultGroupName=PeaExtractor
DisableProgramGroupPage=yes
LicenseFile=C:\input-peaextractor\peaextractor-1.2.WIN64\copying.txt
InfoBeforeFile=C:\input-peaextractor\peaextractor-1.2.WIN64\readme_Win64.txt
OutputDir=C:\output\
OutputBaseFilename=peaextractor-1.2.WIN64
SetupIconFile=peazip-icon-green.ico
Compression=lzma2
SolidCompression=yes
ChangesAssociations=yes
ArchitecturesInstallIn64BitMode=x64
ArchitecturesAllowed=x64

[Languages]
Name: "default"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "C:\input-peaextractor\peaextractor-1.2.WIN64\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[INI]
Filename: "{app}\peaextractor.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://peaextractor.sourceforge.net"

[Icons]
Name: "{group}\PeaExtractor"; Filename: "{app}\peaextractor.exe"
Name: "{group}\{cm:ProgramOnTheWeb,PeaExtractor}"; Filename: "{app}\peaextractor.url"
Name: "{group}\{cm:UninstallProgram,PeaExtractor}"; Filename: "{uninstallexe}"
Name: "{userdesktop}\PeaExtractor"; Filename: "{app}\peaextractor.exe"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\PeaExtractor"; Filename: "{app}\peaextractor.exe"; Tasks: quicklaunchicon

[Run]

[InstallDelete]
Type: filesandordirs; Name: "{app}\lang"

[UninstallDelete]
Type: files; Name: "{app}\peaextractor.url"

[CustomMessages]   
Associations_Caption=Associations Caption
Associations_Description=Associations Description
Associations_cb7z_Caption0=7Z, XZ
Associations_cbappx_Caption0=APPX
Associations_cbbz2_Caption0=BZ2
Associations_cbgz_Caption0=GZ
Associations_cbpaq8_Caption0=*PAQ
Associations_cbtar_Caption0=TAR
Associations_cbzip_Caption0=ZIP, ZIPX
Associations_cbarj_Caption0=ARJ
Associations_cblinux_Caption0=GNU Linux, Android (APK, CRX, DEB, RPM, XPI)
Associations_cbiso_Caption0=ISO, UDF
Associations_cblha_Caption0=LHA
Associations_cblzh_Caption0=LZH
Associations_cbrar_Caption0=RAR
Associations_cbreadnone_Caption0=None of the above (override selection)
Associations_cbarc_Caption0=ARC/WRC
Associations_cbMac_Caption0=Mac OSX, iOS (DMG/HFS, IPA, IPSW)
Associations_cbpea_Caption0=PEA
Associations_cbsplit_Caption0=001 (split)
Associations_cbebooks_Caption0=EPUB
Associations_cbms_Caption0=Microsoft (CAB, VHD, WIM)
context_Caption=Context menu
context_Description=Create application's entries in system's context menu
context_cbcontextext2here_Caption0=Extract here
context_cbcontextnone_Caption0=No context menu entry (override selection)
context_cbcontextext2folder_Caption0=Extract here (in new folder)
context_cbcascaded_Caption0=Cascaded menu
 				
[Code]
var
  Bevel1: TBevel;
  cb7z: TCheckBox;
  cbbz2: TCheckBox;
  cbgz: TCheckBox;
  cbpaq8: TCheckBox;
  cbtar: TCheckBox;
  cbzip: TCheckBox;
  cbarj: TCheckBox;
  cblinux: TCheckBox;
  cbiso: TCheckBox;
  cblha: TCheckBox;
  cblzh: TCheckBox;
  cbrar: TCheckBox;
  cbreadnone: TCheckBox;
  cbarc: TCheckBox;
  cbMac: TCheckBox;
  cbpea: TCheckBox;
  cbsplit: TCheckBox;
  cbebooks: TCheckBox;
  cbms: TCheckBox;
  cbappx: TCheckBox;
  Bevel1context: TBevel;
  cbcontextext2here: TCheckBox;
  cbcontextnone: TCheckBox;
  cbcontextext2folder: TCheckBox;
  cbcascaded: TCheckBox;	

{ Associations_Activate }

procedure Associations_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ Associations_ShouldSkipPage }

function Associations_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
  Result := False;
end;

{ Associations_BackButtonClick }

function Associations_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ Associations_NextkButtonClick }

function Associations_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ Associations_CancelButtonClick }

procedure Associations_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

{ Associations_CreatePage }

function Associations_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:Associations_Caption}'),
    ExpandConstant('{cm:Associations_Description}')
  );

{ Bevel1 }
  Bevel1 := TBevel.Create(Page);
  with Bevel1 do
  begin
    Parent := Page.Surface;
    Left := ScaleX(8);
    Top := ScaleY(0);
    Width := ScaleX(396);
    Height := ScaleY(204);
  end;
  
  { cb7z }
  cb7z := TCheckBox.Create(Page);
  with cb7z do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cb7z_Caption0}');
    Left := ScaleX(116);
    Top := ScaleY(8);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 2;
  end;
  
  { cbbz2 }
  cbbz2 := TCheckBox.Create(Page);
  with cbbz2 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbbz2_Caption0}');
    Left := ScaleX(116);
    Top := ScaleY(32);
    Width := ScaleX(73);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 5;
  end;
  
  { cbgz }
  cbgz := TCheckBox.Create(Page);
  with cbgz do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbgz_Caption0}');
    Left := ScaleX(316);
    Top := ScaleY(32);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 6;
  end;
  
  { cbpaq8 }
  cbpaq8 := TCheckBox.Create(Page);
  with cbpaq8 do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbpaq8_Caption0}');
    Left := ScaleX(316);
    Top := ScaleY(56);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 10;
  end;
  
  { cbtar }
  cbtar := TCheckBox.Create(Page);
  with cbtar do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbtar_Caption0}');
    Left := ScaleX(216);
    Top := ScaleY(80);
    Width := ScaleX(73);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 13;
  end;
  
  { cbzip }
  cbzip := TCheckBox.Create(Page);
  with cbzip do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbzip_Caption0}');
    Left := ScaleX(316);
    Top := ScaleY(80);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 14;
  end;
  
  { cbarj }
  cbarj := TCheckBox.Create(Page);
  with cbarj do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbarj_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(32);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 4;
  end;
  
  { cblinux }
  cblinux := TCheckBox.Create(Page);
  with cblinux do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cblinux_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(128);
    Width := ScaleX(384);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 16;
  end;
  
  { cbiso }
  cbiso := TCheckBox.Create(Page);
  with cbiso do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbiso_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(56);
    Width := ScaleX(89);
    Height := ScaleY(17);
    TabOrder := 7;
  end;
  
  { cblha }
  cblha := TCheckBox.Create(Page);
  with cblha do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cblha_Caption0}');
    Left := ScaleX(116);
    Top := ScaleY(56);
    Width := ScaleX(73);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 8;
  end;
  
  { cblzh }
  cblzh := TCheckBox.Create(Page);
  with cblzh do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cblzh_Caption0}');
    Left := ScaleX(216);
    Top := ScaleY(56);
    Width := ScaleX(73);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 9;
  end;
  
  { cbrar }
  cbrar := TCheckBox.Create(Page);
  with cbrar do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbrar_Caption0}');
    Left := ScaleX(116);
    Top := ScaleY(80);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 12;
  end;
  
  { cbreadnone }
  cbreadnone := TCheckBox.Create(Page);
  with cbreadnone do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbreadnone_Caption0}');
    Left := ScaleX(8);
    Top := ScaleY(210);
    Width := ScaleX(329);
    Height := ScaleY(25);
    TabOrder := 0;
  end;
  
  { cbarc }
  cbarc := TCheckBox.Create(Page);
  with cbarc do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbarc_Caption0}');
    Left := ScaleX(316);
    Top := ScaleY(8);
    Width := ScaleX(81);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 3;
  end;
  
  { cbMac }
  cbMac := TCheckBox.Create(Page);
  with cbMac do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbMac_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(152);
    Width := ScaleX(384);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 17;
  end;
  
  { cbpea }
  cbpea := TCheckBox.Create(Page);
  with cbpea do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbpea_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(80);
    Width := ScaleX(73);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 11;
  end;
  
  { cbsplit }
  cbsplit := TCheckBox.Create(Page);
  with cbsplit do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbsplit_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(8);
    Width := ScaleX(89);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 1;
  end;
  
  { cbebooks }
  cbebooks := TCheckBox.Create(Page);
  with cbebooks do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbebooks_Caption0}');
    Left := ScaleX(216);
    Top := ScaleY(32);
    Width := ScaleX(80);
    Height := ScaleY(17);
    TabOrder := 15;
  end;
  
  { cbms }
  cbms := TCheckBox.Create(Page);
  with cbms do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbms_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(176);
    Width := ScaleX(384);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 18;
  end;
  
  { cbappx }
  cbappx := TCheckBox.Create(Page);
  with cbappx do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:Associations_cbappx_Caption0}');
    Left := ScaleX(216);
    Top := ScaleY(8);
    Width := ScaleX(81);
    Height := ScaleY(17);
    TabOrder := 19;
  end;
				
				  with Page do
				  begin
				    OnActivate := @Associations_Activate;
				    OnShouldSkipPage := @Associations_ShouldSkipPage;
				    OnBackButtonClick := @Associations_BackButtonClick;
				    OnNextButtonClick := @Associations_NextButtonClick;
				    OnCancelButtonClick := @Associations_CancelButtonClick;
				  end;
				
				  Result := Page.ID;
				end;
				
{ context_Activate }

procedure context_Activate(Page: TWizardPage);
begin
  // enter code here...
end;

{ context_ShouldSkipPage }

function context_ShouldSkipPage(Page: TWizardPage): Boolean;
begin
Result := False;
end;

{ context_BackButtonClick }

function context_BackButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ context_NextkButtonClick }

function context_NextButtonClick(Page: TWizardPage): Boolean;
begin
  Result := True;
end;

{ context_CancelButtonClick }

procedure context_CancelButtonClick(Page: TWizardPage; var Cancel, Confirm: Boolean);
begin
  // enter code here...
end;

{ context_CreatePage }

function context_CreatePage(PreviousPageId: Integer): Integer;
var
  Page: TWizardPage;
begin
  Page := CreateCustomPage(
    PreviousPageId,
    ExpandConstant('{cm:context_Caption}'),
    ExpandConstant('{cm:context_Description}')
  );

{ Bevel1context }
  Bevel1context := TBevel.Create(Page);
  with Bevel1context do
  begin
    Parent := Page.Surface;
    Left := ScaleX(8);
    Top := ScaleY(2);
    Width := ScaleX(396);
    Height := ScaleY(202);
  end;
  
  { cbcontextext2here }
  cbcontextext2here := TCheckBox.Create(Page);
  with cbcontextext2here do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextext2here_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(8);
    Width := ScaleX(193);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 7;
  end;

  { cbcontextext2folder }
  cbcontextext2folder := TCheckBox.Create(Page);
  with cbcontextext2folder do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextext2folder_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(28);
    Width := ScaleX(177);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 8;
  end;

  { cbcontextnone }
  cbcontextnone := TCheckBox.Create(Page);
  with cbcontextnone do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcontextnone_Caption0}');
    Left := ScaleX(8);
    Top := ScaleY(210);
    Width := ScaleX(321);
    Height := ScaleY(25);
    TabOrder := 0;
  end;
  
  { cbcascaded }
  cbcascaded := TCheckBox.Create(Page);
  with cbcascaded do
  begin
    Parent := Page.Surface;
    Caption := ExpandConstant('{cm:context_cbcascaded_Caption0}');
    Left := ScaleX(16);
    Top := ScaleY(88);
    Width := ScaleX(185);
    Height := ScaleY(17);
    Checked := True;
    State := cbChecked;
    TabOrder := 13;
  end;
  if (GetWindowsVersion shr 24 <6) or
     ((GetWindowsVersion shr 24 =6) and ((GetWindowsVersion shr 16) and $FF =0))
     then cbcascaded.visible:=false;

  with Page do
  begin
    OnActivate := @context_Activate;
    OnShouldSkipPage := @context_ShouldSkipPage;
    OnBackButtonClick := @context_BackButtonClick;
    OnNextButtonClick := @context_NextButtonClick;
    OnCancelButtonClick := @context_CancelButtonClick;
  end;

  Result := Page.ID;
end;
    
			
				{ InitializeWizard }
				
				procedure InitializeWizard();
				begin		
          Associations_CreatePage(wpSelectDir);//InfoBefore);
				  context_CreatePage(wpSelectDir);
				end;

function shouldskippage(CurPageID: Integer): Boolean;
begin

end;

procedure clearcontextlegacy;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaExtractor > Extract here');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaExtractor > Extract here (in new folder)');
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaExtractor > Extract...');
//RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaExtractor > Test archive');
end;

procedure clearcontextseven;
begin
RegDeleteKeyIncludingSubkeys(HKCR, '*\shell\PeaExtractor');
if IsWin64 then
   begin
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder');
   RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main');
   //RegDeleteKeyIncludingSubkeys(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test');
   end
else
   begin
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder');
   RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main');
   //RegDeleteKeyIncludingSubkeys(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test');
   end;
end;

procedure clearassociations;
begin

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\001') then
    begin
    //001
    RegDeleteValue(HKCR, '.001', '');
    RegDeleteKeyIncludingSubkeys(HKCR, '001');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\PEA') then
    begin
    //PEA
    RegDeleteValue(HKCR, '.pea', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'PEA');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\7Z') then
    begin
    //7Z
    RegDeleteValue(HKCR, '.7z', '');
    RegDeleteKeyIncludingSubkeys(HKCR, '7Z');
    //XZ
    RegDeleteValue(HKCR, '.xz', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'XZ');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ARC') then
    begin
    //ARC
    RegDeleteValue(HKCR, '.arc', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ARC');
    //WRC
    RegDeleteValue(HKCR, '.wrc', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'WRC');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\BZ2') then
    begin
    //BZip2
    RegDeleteValue(HKCR, '.bz', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'BZ');
    RegDeleteValue(HKCR, '.tbz', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'TBZ');
    RegDeleteValue(HKCR, '.bz2', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'BZ2');
    RegDeleteValue(HKCR, '.tbz2', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'TBZ2');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\GZ') then
    begin
    //GZip
    RegDeleteValue(HKCR, '.gz', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'GZ');
    //TGZ
    RegDeleteValue(HKCR, '.tgz', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'TGZ');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\PAQ') then
    begin
    //LPAQ8
    RegDeleteValue(HKCR, '.lpaq8', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'LPAQ8');
    //PAQ8O
    RegDeleteValue(HKCR, '.paq8o', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'PAQ8O');
    //ZPAQ
    RegDeleteValue(HKCR, '.zpaq', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ZPAQ');;
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\TAR') then
    begin
    //Tar
    RegDeleteValue(HKCR, '.tar', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'TAR');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ZIP') then
    begin
    //Zip
    RegDeleteValue(HKCR, '.zip', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ZIP');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ZIPX') then
    begin
    //Zipx
    RegDeleteValue(HKCR, '.zipx', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ZIPX');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ARJ') then
    begin
    //ARJ
    RegDeleteValue(HKCR, '.ARJ', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ARJ');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ISO') then
    begin
    //ISO
    RegDeleteValue(HKCR, '.ISO', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'ISO');
    //UDF
    RegDeleteValue(HKCR, '.UDF', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'UDF');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\LHA') then
    begin
    //LHA
    RegDeleteValue(HKCR, '.LHA', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'LHA');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\LZH') then
    begin
    //LZH
    RegDeleteValue(HKCR, '.LZH', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'LZH');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\RAR') then
    begin
    //RAR
    RegDeleteValue(HKCR, '.RAR', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'RAR');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\APPX') then
    begin
    //APPX
    RegDeleteValue(HKCR, '.APPX', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'APPX');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\EPUB') then
    begin
    //EPUB
    RegDeleteValue(HKCR, '.EPUB', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'EPUB');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\linux') then
    begin
    //DEB
    RegDeleteValue(HKCR, '.DEB', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'DEB');
    //RPM
    RegDeleteValue(HKCR, '.RPM', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'RPM');
    //SLP
    RegDeleteValue(HKCR, '.SLP', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'SLP');
    //PET
    RegDeleteValue(HKCR, '.PET', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'PET');
    //PUP
    RegDeleteValue(HKCR, '.PUP', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'PUP');
    //APK
    RegDeleteValue(HKCR, '.APK', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'APK');
    //CRX
    RegDeleteValue(HKCR, '.CRX', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'CRX');
    //XPI
    RegDeleteValue(HKCR, '.XPI', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'XPI');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\mac') then
    begin
    //DMG
    RegDeleteValue(HKCR, '.DMG', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'DMG');
    //HFS
    RegDeleteValue(HKCR, '.HFS', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'HFS');
    //IPA
    RegDeleteValue(HKCR, '.IPA', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'IPA');
    //IPSW
    RegDeleteValue(HKCR, '.IPSW', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'IPSW');
    end;

    if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor\ms') then
    begin
    //CAB
    RegDeleteValue(HKCR, '.CAB', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'CAB');
    //VHD
    RegDeleteValue(HKCR, '.VHD', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'VHD');
    //WIM
    RegDeleteValue(HKCR, '.WIM', '');
    RegDeleteKeyIncludingSubkeys(HKCR, 'WIM');
    end;

if RegKeyExists(HKLM, 'SOFTWARE\PeaExtractor') then RegDeleteKeyIncludingSubkeys(HKLM, 'SOFTWARE\PeaExtractor');
end;

procedure contextseven;
var
  sarc:ansistring;
begin

      sarc:='';

      sarc:=sarc+'PeaExtractor.ext2main; ';
      if cbcontextext2here.state = cbChecked then sarc:=sarc+'PeaExtractor.ext2here; ';
      if cbcontextext2folder.state = cbChecked then sarc:=sarc+'PeaExtractor.ext2folder; '; 
      //if cbcontexttest.state = cbChecked then sarc:=sarc+'PeaExtractor.ext2test; ';     

      RegWriteStringValue(HKCR, '*\shell\PeaExtractor', 'SubCommands', sarc);
      RegWriteStringValue(HKCR, '*\shell\PeaExtractor', 'MultiSelectModel', 'single');
      RegWriteStringValue(HKCR, '*\shell\PeaExtractor', 'Icon', ExpandConstant('"{app}\peaextractor.exe",0'));
      RegWriteStringValue(HKCR, '*\shell\PeaExtractor\command', '', '');
      RegDeleteValue(HKCR, '*\shell\PeaExtractor\command', '');

      if IsWin64 then   
        begin
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here', '', 'Extract here');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2here" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder', '', 'Extract here (in new folder)');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2folder" "%1"'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main', '', 'Extract...');
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2multi" "%1"'));
        //RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test', '', 'Test archive');
        //RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",1'));
        //RegWriteStringValue(HKLM64, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2test" "%1"'));
        end
      else
        begin
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here', '', 'Extract here');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2here\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2here" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder', '', 'Extract here (in new folder)');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2folder\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2folder" "%1"'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main', '', 'Extract...');
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",4'));
        RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2main\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2multi" "%1"'));
        //RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test', '', 'Test archive');
        //RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test', 'Icon', ExpandConstant('"{app}\icons\peazip_seven.icl",1'));
        //RegWriteStringValue(HKLM32, 'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\CommandStore\shell\PeaExtractor.ext2test\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2test" "%1"'));
        end;
end;

procedure contextlegacy;
begin           //***vedere comandi parametri

    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract...\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2main" "%1"'));
    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract...', 'MultiSelectModel', 'single');

    if cbcontextext2here.state = cbChecked then
    begin
    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract here\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2here" "%1"'));
    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract here', 'MultiSelectModel', 'single');
    end;

    if cbcontextext2folder.state = cbChecked then
    begin
    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract here (in new folder)\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2folder" "%1"'));
    RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Extract here (in new folder)', 'MultiSelectModel', 'single');
    end;

    //if cbcontexttest.state = cbChecked then
    //begin
    //RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Test archive\command', '', ExpandConstant('"{app}\PEAEXTRACTOR.EXE" "-ext2test" "%1"'));
    //RegWriteStringValue(HKCR, '*\shell\PeaExtractor > Test archive', 'MultiSelectModel', 'single');
    //end;

end;

procedure doassociations;
begin
  if cbreadnone.state = cbUnchecked then
    begin
    //declare that filetype associations were created
    RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor', '', 'Created filetype associations');

    //001
    if cbsplit.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\001', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.001', '', '001');
      RegWriteStringValue(HKCR, '001', '', 'Split file');
      RegWriteStringValue(HKCR, '001\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_BLOCK.ICO,0'));
      RegWriteStringValue(HKCR, '001\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    //PEA
    if cbsplit.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\PEA', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.PEA', '', 'PEA');
      RegWriteStringValue(HKCR, 'PEA', '', 'PEA archive');
      RegWriteStringValue(HKCR, 'PEA\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PEA\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    //7z/arc
    if cb7z.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\7Z', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.7z', '', '7Z');
      RegWriteStringValue(HKCR, '7Z', '', '7Z archive');
      RegWriteStringValue(HKCR, '7Z\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_7Z.ICO,0'));
      RegWriteStringValue(HKCR, '7Z\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      RegWriteStringValue(HKCR, '.xz', '', 'XZ');
      RegWriteStringValue(HKCR, 'XZ', '', 'XZ compressed file');
      RegWriteStringValue(HKCR, 'XZ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'XZ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //arc/wrc
    if cbarc.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ARC', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.arc', '', 'ARC');
      RegWriteStringValue(HKCR, 'ARC', '', 'FreeARC archive');
      RegWriteStringValue(HKCR, 'ARC\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'ARC\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      RegWriteStringValue(HKCR, '.wrc', '', 'WRC');
      RegWriteStringValue(HKCR, 'WRC', '', 'FreeARC archive');
      RegWriteStringValue(HKCR, 'WRC\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'WRC\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //BZip2
    if cbbz2.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\BZ2', '', 'Associated PeaExtractor with file type(s)');
      //BZ
      RegWriteStringValue(HKCR, '.bz', '', 'BZ');
      RegWriteStringValue(HKCR, 'BZ', '', 'BZip2 compressed file');
      RegWriteStringValue(HKCR, 'BZ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'BZ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //BZ2
      RegWriteStringValue(HKCR, '.bz2', '', 'BZ2');
      RegWriteStringValue(HKCR, 'BZ2', '', 'BZip2 compressed file');
      RegWriteStringValue(HKCR, 'BZ2\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'BZ2\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //TBZ
      RegWriteStringValue(HKCR, '.tbz', '', 'TBZ');
      RegWriteStringValue(HKCR, 'TBZ', '', 'BZip2 compressed TAR archive');
      RegWriteStringValue(HKCR, 'TBZ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'TBZ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //TBZ2
      RegWriteStringValue(HKCR, '.tbz2', '', 'TBZ2');
      RegWriteStringValue(HKCR, 'TBZ2', '', 'BZip2 compressed TAR archive');
      RegWriteStringValue(HKCR, 'TBZ2\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'TBZ2\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //GZip
    if cbgz.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\GZ', '', 'Associated PeaExtractor with file type(s)');
      //GZ
      RegWriteStringValue(HKCR, '.gz', '', 'GZ');
      RegWriteStringValue(HKCR, 'GZ', '', 'GZip compressed file');
      RegWriteStringValue(HKCR, 'GZ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'GZ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //TGZ
      RegWriteStringValue(HKCR, '.tgz', '', 'TGZ');
      RegWriteStringValue(HKCR, 'TGZ', '', 'GZip compressed TAR archive');
      RegWriteStringValue(HKCR, 'TGZ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'TGZ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //*PAQ group
    if cbpaq8.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\PAQ', '', 'Associated PeaExtractor with file type(s)');
      //LPAQ8
      RegWriteStringValue(HKCR, '.lpaq8', '', 'LPAQ8');
      RegWriteStringValue(HKCR, 'LPAQ8', '', 'LPAQ8 compressed file');
      RegWriteStringValue(HKCR, 'LPAQ8\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'LPAQ8\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //PAQ8O
      RegWriteStringValue(HKCR, '.paq8o', '', 'PAQ8O');
      RegWriteStringValue(HKCR, 'PAQ8O', '', 'PAQ8O archive');
      RegWriteStringValue(HKCR, 'PAQ8O\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'PAQ8O\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //ZPAQ
      RegWriteStringValue(HKCR, '.zpaq', '', 'ZPAQ');
      RegWriteStringValue(HKCR, 'ZPAQ', '', 'ZPAQ archive');
      RegWriteStringValue(HKCR, 'ZPAQ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'ZPAQ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //Tar
    if cbtar.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\TAR', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.tar', '', 'TAR');
      RegWriteStringValue(HKCR, 'TAR', '', 'TAR archive');
      RegWriteStringValue(HKCR, 'TAR\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'TAR\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //Zip
    if cbzip.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ZIP', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.zip', '', 'ZIP');
      RegWriteStringValue(HKCR, 'ZIP', '', 'ZIP archive');
      RegWriteStringValue(HKCR, 'ZIP\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_ZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'ZIP\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ZIPX', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.zipx', '', 'ZIPX');
      RegWriteStringValue(HKCR, 'ZIPX', '', 'ZIPX archive');
      RegWriteStringValue(HKCR, 'ZIPX\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_ZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'ZIPX\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //ARJ
    if cbarj.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ARJ', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.ARJ', '', 'ARJ');
      RegWriteStringValue(HKCR, 'ARJ', '', 'ARJ archive');
      RegWriteStringValue(HKCR, 'ARJ\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'ARJ\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //Disk images
    if cbiso.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ISO', '', 'Associated PeaExtractor with file type(s)');
      //ISO
      RegWriteStringValue(HKCR, '.ISO', '', 'ISO');
      RegWriteStringValue(HKCR, 'ISO', '', 'ISO disk image');
      RegWriteStringValue(HKCR, 'ISO\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'ISO\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //UDF
      RegWriteStringValue(HKCR, '.UDF', '', 'UDF');
      RegWriteStringValue(HKCR, 'UDF', '', 'UDF disk image');
      RegWriteStringValue(HKCR, 'UDF\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'UDF\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //LHA
    if cblha.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\LHA', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.LHA', '', 'LHA');
      RegWriteStringValue(HKCR, 'LHA', '', 'LHA archive');
      RegWriteStringValue(HKCR, 'LHA\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'LHA\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //LZH
    if cblzh.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\LZH', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.LZH', '', 'LZH');
      RegWriteStringValue(HKCR, 'LZH', '', 'LZH archive');
      RegWriteStringValue(HKCR, 'LZH\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'LZH\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    //RAR
    if cbrar.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\RAR', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.RAR', '', 'RAR');
      RegWriteStringValue(HKCR, 'RAR', '', 'RAR archive');
      RegWriteStringValue(HKCR, 'RAR\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_RAR.ICO,0'));
      RegWriteStringValue(HKCR, 'RAR\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
    
    //APPX
    if cbappx.state = cbChecked then
      begin
      RegWriteStringValue(HKCR, '.APPX', '', 'APPX');
      RegWriteStringValue(HKCR, 'APPX', '', 'APPX MS app package');
      RegWriteStringValue(HKCR, 'APPX\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'APPX\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    //EPUB
    if cbebooks.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\EPUB', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.EPUB', '', 'EPUB');
      RegWriteStringValue(HKCR, 'EPUB', '', 'EPUB archive');
      RegWriteStringValue(HKCR, 'EPUB\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'EPUB\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    //GNU Linux / Android / Chrome / Mozilla packages
    if cblinux.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\linux', '', 'Associated PeaExtractor with file type(s)');
      //DEB
      RegWriteStringValue(HKCR, '.DEB', '', 'DEB');
      RegWriteStringValue(HKCR, 'DEB', '', 'DEB package');
      RegWriteStringValue(HKCR, 'DEB\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'DEB\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //PET
      RegWriteStringValue(HKCR, '.PET', '', 'PET');
      RegWriteStringValue(HKCR, 'PET', '', 'PET package (Puppy Linux)');
      RegWriteStringValue(HKCR, 'PET\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PET\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //PUP
      RegWriteStringValue(HKCR, '.PUP', '', 'PUP');
      RegWriteStringValue(HKCR, 'PUP', '', 'PUP package (Puppy Linux)');
      RegWriteStringValue(HKCR, 'PUP\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'PUP\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //RPM
      RegWriteStringValue(HKCR, '.RPM', '', 'RPM');
      RegWriteStringValue(HKCR, 'RPM', '', 'RPM package');
      RegWriteStringValue(HKCR, 'RPM\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'RPM\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //SLP
      RegWriteStringValue(HKCR, '.SLP', '', 'SLP');
      RegWriteStringValue(HKCR, 'SLP', '', 'SLP package');
      RegWriteStringValue(HKCR, 'SLP\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'SLP\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;
      //APK
      RegWriteStringValue(HKCR, '.APK', '', 'APK');
      RegWriteStringValue(HKCR, 'APK', '', 'APK Android app package');
      RegWriteStringValue(HKCR, 'APK\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'APK\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //CRX
      RegWriteStringValue(HKCR, '.CRX', '', 'CRX');
      RegWriteStringValue(HKCR, 'CRX', '', 'CRX Chrome extension package');
      RegWriteStringValue(HKCR, 'CRX\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'CRX\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //XPI
      RegWriteStringValue(HKCR, '.XPI', '', 'XPI');
      RegWriteStringValue(HKCR, 'XPI', '', 'XPI Firefox extension package');
      RegWriteStringValue(HKCR, 'DEB\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'DEB\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));

    //Mac OSX iOS formats
    if cbMac.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\mac', '', 'Associated PeaExtractor with file type(s)');
      //DMG
      RegWriteStringValue(HKCR, '.DMG', '', 'DMG');
      RegWriteStringValue(HKCR, 'DMG', '', 'DMG package');
      RegWriteStringValue(HKCR, 'DMG\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'DMG\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //UDF
      RegWriteStringValue(HKCR, '.HFS', '', 'HFS');
      RegWriteStringValue(HKCR, 'HFS', '', 'HFS package');
      RegWriteStringValue(HKCR, 'HFS\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'HFS\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //IPA
      RegWriteStringValue(HKCR, '.IPA', '', 'IPA');
      RegWriteStringValue(HKCR, 'IPA', '', 'IPA iOS app package');
      RegWriteStringValue(HKCR, 'IPA\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'IPA\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //IPSW
      RegWriteStringValue(HKCR, '.IPSW', '', 'IPSW');
      RegWriteStringValue(HKCR, 'IPSW', '', 'IPSW iOS firmware package');
      RegWriteStringValue(HKCR, 'IPSW\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_PACKAGE.ICO,0'));
      RegWriteStringValue(HKCR, 'IPSW\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    //Microsoft formats
    if cbms.state = cbChecked then
      begin
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\ms', '', 'Associated PeaExtractor with file type(s)');
      //CAB
      RegWriteStringValue(HKLM, 'SOFTWARE\PeaExtractor\CAB', '', 'Associated PeaExtractor with file type(s)');
      RegWriteStringValue(HKCR, '.CAB', '', 'CAB');
      RegWriteStringValue(HKCR, 'CAB', '', 'CAB archive');
      RegWriteStringValue(HKCR, 'CAB\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP.ICO,0'));
      RegWriteStringValue(HKCR, 'CAB\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //VHD
      RegWriteStringValue(HKCR, '.VHD', '', 'VHD');
      RegWriteStringValue(HKCR, 'VHD', '', 'VHD virtual disk image');
      RegWriteStringValue(HKCR, 'VHD\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'VHD\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      //WIM
      RegWriteStringValue(HKCR, '.WIM', '', 'WIM');
      RegWriteStringValue(HKCR, 'WIM', '', 'WIM package');
      RegWriteStringValue(HKCR, 'WIM\DefaultIcon', '', ExpandConstant('{app}\ICONS\PEAZIP_CD.ICO,0'));
      RegWriteStringValue(HKCR, 'WIM\shell\open\command', '', ExpandConstant('"{app}\PeaExtractor.EXE" "%1"'));
      end;

    end;
end;

function NextButtonClick(CurPageID: Integer): Boolean;
var
  ResultCode: Integer;
  ErrorCode: Integer;
begin

if CurPageID = wpReady then
  begin

    clearcontextlegacy;
    clearcontextseven;
    clearassociations;
    BringToFrontAndRestore();

    //context menu
    if cbcontextnone.state = cbUnchecked then
       if (GetWindowsVersion shr 24 >=6) and ((GetWindowsVersion shr 16) and $FF >=1) then 
          if cbcascaded.state = cbChecked then contextseven
          else contextlegacy
       else contextlegacy;
    //associations
    doassociations;
    BringToFrontAndRestore();
end;
Result := True;
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
begin
if CurUninstallStep = usDone then
  begin
  clearcontextlegacy;
  clearcontextseven; //delete context menu items
  clearassociations; //delete filetype associations (by read/write and/or read only group), if created by previous setup
  BringToFrontAndRestore();
  end;
end;