/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;
import java.io.*;

/**
 * MIME Media Type。以下の物が取得可能です。
 * <table border='1'>
 * <tr><th>MIME Media Type</th><th>拡張子</th>
#0
 * </table>
 */
public class MimeType {
	private static HashMap<String, String>	map = new HashMap<String, String>();
	private static HashMap<String, HashMap<String, String[]>>	rev = new HashMap<String, HashMap<String, String[]>>();
	static {
#1
	}

	private MimeType(){}

	private static void set_rev( String cat, String type, String[] ext ) {
		HashMap<String, String[]>	sub = rev.get( cat );
		if ( sub == null ) {
			sub = new HashMap<String, String[]>();
			rev.put( cat, sub );
		}
		sub.put( type, ext );

		StringBuilder	buf = new StringBuilder( cat );
		buf = buf.append( "/" );
		buf = buf.append( type );
		type = buf.toString();
		for ( int i = 0; i < ext.length; i++ ) {
			map.put( ext[i], type );
		}
	}

	private static final String FIX_TYPE = "application/octet-stream";

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( String file ) {
		if ( file == null )	return FIX_TYPE;
		String[]	ext = file.split( "\\." );
		String	seek = ext[ext.length - 1].toLowerCase( Locale.ENGLISH );
		String	ret = map.get( seek );
		if ( ret == null )	return FIX_TYPE;
		return ret;
	}

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( File file ) {
		if ( file == null )	return FIX_TYPE;
		return getMimeType( file.getName() );
	}

	/**
	 * 拡張子の取得。<br>
	 * 例えば、image/gif を指定すると、GIF画像フォーマットの拡張子を返します。<br>
	 * image を指定すると、画像カテゴリの全ての拡張子を返します。
	 * @param mime MIME Media Type。
	 * @return 拡張子。未知の MIME Media Type であると null。
	 */
	public static String[] getExtension( String mime ) {
		if ( mime == null )	return null;
		String[]	type = mime.split( "/" );
		HashMap<String, String[]>	sub = rev.get( type[0] );
		if ( sub == null )	return null;
		if ( type.length > 1 ) {
			return sub.get( type[1] );
		}
		ArrayList<String>	list = new ArrayList<String>();
		for ( String key: sub.keySet() ) {
			String[]	ext = sub.get( key );
			for ( int i = 0; i < ext.length; i++ ) {
				list.add( ext[i] );
			}
		}
		return list.toArray( new String[0] );
	}
}

