/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import java.io.*;
import java.net.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.ui.*;
import paraselene.supervisor.*;


/**
 * １行テキストボックス。<br>
 * パスワード入力用ボックスであれば、ブラウザへvalueを返しません。
 */
public class SingleTextBox extends Input implements PageHooker {
	/**
	 * テキスト種別。
	 */
	public enum Type {
		/**
		 * 通常テキスト。
		 */
		TEXT( Input.Type.TEXT ),
		/**
		 * パスワード用テキスト。
		 */
		PASSWORD( Input.Type.PASSWORD ),
		/**
		 * 検索用テキスト。
		 */
		SEARCH( Input.Type.SEARCH ),
		/**
		 * 電話番号用テキスト。
		 */
		TELEPHONE( Input.Type.TELEPHONE ),
		/**
		 * URL用テキスト。
		 */
		URL( Input.Type.URL ),
		/**
		 * 電子メール用テキスト。
		 */
		EMAIL( Input.Type.EMAIL ),
		/**
		 * タイムゾーン無し日時用テキスト。
		 */
		DATE_AND_TIME( Input.Type.DATE_AND_TIME ),
		/**
		 * 日付用テキスト。
		 */
		DATE( Input.Type.DATE ),
		/**
		 * 月用テキスト。
		 */
		MONTH( Input.Type.MONTH ),
		/**
		 * 週用テキスト。
		 */
		WEEK( Input.Type.WEEK ),
		/**
		 * 時間用テキスト。
		 */
		TIME( Input.Type.TIME ),
		/**
		 * タイムゾーン付き日時用テキスト。
		 */
		LOCAL_DATE_AND_TIME( Input.Type.LOCAL_DATE_AND_TIME ),
		/**
		 * 数値用テキスト。
		 */
		NUMBER( Input.Type.NUMBER ),
		/**
		 * 範囲用テキスト。
		 */
		RANGE( Input.Type.RANGE ),
		/**
		 * 色用テキスト。
		 */
		COLOR( Input.Type.COLOR );

		Input.Type	text_type;
		private Type( Input.Type t ) {
			text_type = t;
		}
	}

	private static final long serialVersionUID = 2L;
	private boolean password_f = false;
	private boolean hidden_f = false;
	private Type	text_type;

	/**
	 * コンストラクタ。
	 * @param pw_f true:パスワード、false:平文。
	 */
	public SingleTextBox( boolean pw_f ) {
		this( pw_f?	Type.PASSWORD: Type.TEXT );
	}

	/**
	 * コンストラクタ。
	 * @param type テキスト種別。
	 */
	public SingleTextBox( Type type ) {
		super( type.text_type );
		text_type = type;
		password_f = type == Type.PASSWORD;
	}

	/**
	 * パスワード入力であるか？
	 * @return pw_f true:パスワード、false:平文。
	 */
	public boolean isPassword() {
		return password_f;
	}

	protected Tag newReplica() {
		return copy4Replica( new SingleTextBox( text_type ) );
	}

	/**
	 * 開始タグの文字列。
	 * @return 開始タグ。
	 */
	protected synchronized String getFirstTag() {
		if ( !hidden_f )	return super.getFirstTag();

		boolean	xml = false;
		xml = getAssignedTag().getAssignedPage().isXML();
		StringBuilder	buf = new StringBuilder( "<" );
		buf = buf.append( getName() );
		for ( String k : attr.keySet() ) {
			if ( "value".equals( k ) ) continue;
			buf = buf.append( " " );
			buf = buf.append( attr.get( k ).toHtmlString( xml ) );
		}
		if ( xml && isSimpleTag() ) {
			buf = buf.append( " /" );
		}
		buf = buf.append( ">" );
		return buf.toString();
	}

	/**
	 * 出力。パスワードであれば、value値は出力しません。
	 * @param w ライター。
	 * @param mode 文字列種別。
	 */
	public void write( PrintWriter w, StringMode mode ) {
		if ( password_f ) {
			hidden_f = true;
		}
		super.write( w, mode );
		hidden_f = false;

	}

	public HTMLPart getReplica() {
		SingleTextBox	stb = (SingleTextBox)super.getReplica();
		stb.password_f = this.password_f;
		return stb;
	}

	/**
	 * 入力文字数チェック。maxlength属性値と設定文字列を比較します。
	 * null値は文字列長0として検査します。
	 * @param mes ControlException用メッセージ。
	 * @exception ControlException 文字数がmaxlength属性値を上回った場合。
	 */
	public void checkMaxLength( String mes ) throws ControlException {
		Attribute	attr = getAttribute( "maxlength" );
		checkMaxLength( mes, Integer.parseInt( attr.getString() ) );
	}

	/**
	 * トリム。設定文字列の前後の空白を除去します。
	 */
	public void trim() {
		trim( this );
	}

	private boolean enter_kill_f = true;

	/**
	 * エンターキー無効指定。デフォルト状態は無効です。
	 * ただし、エンターキー無効機能は Ajax 有効時でしか機能しません。
	 * @param flag true:無効、false:有効(エンターキーでsubmitする)。
	 */
	public void setDisableEnter( boolean flag ) {
		enter_kill_f = flag;
		setModify();
	}
	/**
	 * エンターキー無効状態取得。
	 * ただし、エンターキー無効機能は Ajax 有効時でしか機能しません。
	 * @return true:無効、false:有効(エンターキーでsubmitする)。
	 */
	public boolean isDisableEnter() {
		return enter_kill_f;
	}

	public Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception {
		return fw;
	}
	public void afterOutput( Page from, Page to, RequestParameter req ) throws Exception {
		commitDaemon();
	}
	public void commitDaemon() {
		if ( isDisableEnter() ) {
			setEventHandler( "keypress", "paraselene.kill_enter" );
		}
	}
}


