/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.util.*;

/**
 * サーバー情報。
 */
public class PageServerInformation implements ServerInformation {
	private static HashMap<String, PageFactory>	fact = new HashMap<String, PageFactory>();

	private static final long serialVersionUID = 2L;
	private String	server;
	private String	context;
	private TransactionSequencer	seq;
	private boolean	search_flag;
	private HistorySet	hist;
	private String mms_id;

	PageServerInformation( DataHolder holder ) {
		server = holder.getServerName();
		context = holder.getContextPath();
		seq = getTransactionSequencer();
		search_flag = holder.isSearchEngine();
		hist = holder.getHistorySet();
		mms_id = holder.getMultiStageSessionID();
		synchronized( fact ) {
			if ( fact.get( context ) == null ) {
				fact.put( context, holder.getPageFactory() );
			}
		}
	}

	public String getServerName() { return server; }
	public String getContextPath() { return context; }
	public TransactionSequencer getTransactionSequencer() { return seq; }
	public boolean isSearchEngine() { return search_flag; }
	public HistorySet getHistorySet() { return hist; }
	public PageFactory getPageFactory() { return fact.get( context ); }
	public String getMultiStageSessionID() { return mms_id; }
}

