/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


/**
 * 一時問い合わせダイアログの動作指定。
 */
public enum EphemeralPosition implements DialogType {
	/**
	 * {@link Popup.Type#MODAL}と同様の動作。
	 */
	MODAL( Popup.Type.MODAL, false, DialogType.Position.CENTER ),
	/**
	 * {@link Popup.Type#LITE_MODAL}と同様の動作。
	 */
	LITE_MODAL( Popup.Type.LITE_MODAL, false, DialogType.Position.CENTER ),
	/**
	 * 指定コントロールの上に表示します。<br>
	 * 指定コントロールと左端位置を揃えます。
	 * <br>ダイアログの外をクリックすると、自動的に閉じます。
	 */
	//PULL_UP( Popup.Type.LITE_MODAL, true, DialogType.Position.UP ),
	/**
	 * 指定コントロールの下に表示します。<br>
	 * 指定コントロールと左端位置を揃えます。
	 * <br>ダイアログの外をクリックすると、自動的に閉じます。
	 */
	PULL_DOWN( Popup.Type.LITE_MODAL, true, DialogType.Position.DOWN ),
	/**
	 * 指定コントロールの左に表示します。<br>
	 * 指定コントロールと上端位置を揃えます。
	 * <br>ダイアログの外をクリックすると、自動的に閉じます。
	 */
	//PULL_LEFT( Popup.Type.LITE_MODAL, true, DialogType.Position.LEFT ),
	/**
	 * 指定コントロールの右に表示します。<br>
	 * 指定コントロールと上端位置を揃えます。
	 * <br>ダイアログの外をクリックすると、自動的に閉じます。
	 */
	PULL_RIGHT( Popup.Type.LITE_MODAL, true, DialogType.Position.RIGHT );

	private Popup.Type	type;
	private boolean	menu_f;
	private DialogType.Position	position;
	private EphemeralPosition( Popup.Type t, boolean mn_f, DialogType.Position pos ) {
		type = t;
		menu_f = mn_f;
		position = pos;
	}

	/**
	 * タイトルバーの有無。
	 * @return true:存在する、false:存在しない。
	 */
	public boolean isTitle() {
		return type.isTitle();
	}

	/**
	 * モーダルであるか？
	 * @return 常にtrue。モーダル。
	 */
	public boolean isMode() {
		return true;
	}

	/**
	 * 自動クローズであるか？<br>
	 * これがtrueであれば、ダイアログ範囲外をクリックすると、
	 * ダイアログが自動的に閉じます。<br>
	 * ブラウザに表示された時、背景が黒であれば自動クローズしません。
	 * @return true:自動クローズする、false:自動クローズしない。
	 */
	public boolean isAutoClose() {
		return menu_f;
	}

	/**
	 * 表示位置の取得。
	 * @return 表示位置。
	 */
	public DialogType.Position getPosition() {
		return position;
	}

	Popup.Type toType() {
		return type;
	}
}

