/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax.data;

import paraselene.*;


public class JavaScript extends PlainText {
	private static final long serialVersionUID = 2L;
	private boolean wait = false;
	private JavaScript(){
	}
	public JavaScript( boolean wait_flag, String ... script ) {
		super( "" );
		wait = wait_flag;
		appendWithCRLF( script );
	}
	public JavaScript( String ... script ) {
		this( false, script );
	}

	public String toString( StringMode mode ) {
		StringBuilder	buf = new StringBuilder( "<!--//--><![CDATA[//><!--\r\n" );
		if ( wait ) {
			buf = buf.append( "function init4paraselene(){" );
		}
		buf = buf.append( toString() );
		if ( wait ) {
			buf = buf.append( "}\r\n" );
			buf = buf.append( "function wait4paraselene(){" );
			buf = buf.append( "if(paraselene)init4paraselene();");
			buf = buf.append( "else setTimeout(wait4paraselene,100);" );
			buf = buf.append( "}\r\n" );
			buf = buf.append( "setTimeout(wait4paraselene,100);\r\n" );
			buf = buf.append( "//--><!]]>\r\n" );
		}
		return buf.toString();
	}

	public String toString() {
		return super.toString( StringMode.PLAIN );
	}
}


