/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.util;


/**
 * IPv4アドレス。
 */
public class IPv4 extends IP {
	/**
	 * コンストラクタ。
	 * @param ip IPアドレス文字列。ピリオド区切りの10進数。
	 */
	public IPv4( String ip ) throws IPFormatException {
		super( parse( ip.trim() ) );
	}

	private static int[] parse( String str ) throws IPFormatException {
		String[]	num = str.split( "\\." );
		if ( num.length != 4 )	throw new IPFormatException( str );
		int[]	ret = new int[4];
		try {
			for ( int i = 0; i < num.length; i++ ) {
				ret[i] = Integer.parseInt( num[i] );
				if ( ret[i] < 0 || ret[i] > 0xff )	throw new IPFormatException( str );
			}
		}
		catch( NumberFormatException e ) {
			throw new IPFormatException( str );
		}
		return ret;
	}

	/**
	 * 文字列化。
	 * @return IPアドレス文字列。
	 */
	public String toString() {
		StringBuilder	buf = new StringBuilder();
		buf = buf.append( addr[0] );
		for ( int i = 1; i < addr.length; i++ ) {
			buf = buf.append( "." ).append( addr[i] );
		}
		return buf.toString();
	}

	private IPv4( IP ip ) { super( ip ); }
	IP getReplica() {
		return new IPv4( this );
	}
}

