/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.ruby;


import paraselene.tag.*;

/**
 * ルビテキスト。
 */
public class RubyText extends Tag {
	private static final long serialVersionUID = 1L;
	/**
	 * ルビ項目のタイプ。
	 */
	public enum Type {
		/**
		 * RB または RBC タグ。ルビを振る対象です。
		 */
		BASE( "rb", "rbc" ),
		/**
		 * RT または RTC タグ。ルビです。
		 */
		TEXT( "rt", "rtc" ),
		/**
		 * RPタグ。ルビに対応していないブラウザ用です。<br>
		 * 複合型にはできません。
		 */
		PARENTHESES( "rp" );

		private String[]	str;
		private Type( String ... s ) {
			str = s;
		}
		String getString( boolean cmp_f ) {
			return str[cmp_f?  1:  0];
		}
	}

	private Type const_type;
	private boolean complex_f;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}
	/**
	 * 複合型であるか？
	 * @return true:複合型、false:単純型。
	 */
	public boolean isComplex() {
		return complex_f;
	}

	/**
	 * コンストラクタ。単純型を作ります。
	 * @param type タイプ。
	 */
	public RubyText( Type type ) {
		this( type, false );
	}

	/**
	 * コンストラクタ。単純型を作ります。
	 * @param type タイプ。
	 * @param span 連結数。
	 */
	public RubyText( Type type, int span ) {
		this( type );
		if ( type == Type.PARENTHESES )	span = 1;
		setAttribute( "rbspan", span );
	}

	/**
	 * コンストラクタ。単純型を作ります。
	 * @param type タイプ。
	 * @param str 設定値。
	 */
	public RubyText( Type type, String str ) {
		this( type );
		setValueString( str );
	}

	/**
	 * コンストラクタ。単純型を作ります。
	 * @param type タイプ。
	 * @param span 連結数。
	 * @param str 設定値。
	 */
	public RubyText( Type type, int span, String str ) {
		this( type, span );
		setValueString( str );
	}

	/**
	 * コンストラクタ。複合型を作成します。<br>
	 * PARENTHESES を使用すると例外が発生します。
	 * @param type タイプ。
	 * @param text 単純型のテキスト。
	 */
	public RubyText( Type type, RubyText[] text ) {
		this( type, true );
		if ( text.length > 0 ) {
			addHTMLPart( text );
		}
	}

	private RubyText( Type t, boolean c ) {
		super( t.getString( c ), false );
		const_type = t;
		complex_f = c;
	}

	protected Tag newReplica() {
		return new RubyText( const_type, complex_f );
	}
}

