/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import java.io.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.ui.*;
import paraselene.supervisor.*;

/**
 * ボタン。
 */
public class Button extends Input implements PageHooker, Clickable {
	private static final long serialVersionUID = 2L;
	private boolean pushed = false;

	/**
	 * ボタンの種類。
	 */
	public enum Type {
		SUBMIT( Input.Type.SUBMIT ),
		RESET( Input.Type.RESET ),
		IMAGE( Input.Type.IMAGE ),
		BUTTON( Input.Type.BUTTON );

		private static final long serialVersionUID = 1L;
		Input.Type	type;
		private Type( Input.Type t ) {
			type = t;
		}
	}

	private Type const_type;

	/**
	 * コンストラクタ。
	 * @param type ボタンの種類。
	 */
	public Button( Type type ) {
		super( type.type );
		const_type = type;
	}

	/**
	 * ボタンの種類の取得。
	 * @return ボタンの種類。
	 */
	public Type getType() {
		return const_type;
	}

	protected Tag newReplica() {
		return copy4Replica( new Button( const_type ) );
	}

	/**
	 * ボタン押下状態の解除。<br>
	 * setClicked( false ) と等価です。
	 */
	public void resetClicked() {
		setClicked( false );
	}

	static boolean isClicked( RequestParameter req, Control ctl ) {
		Form	form = ctl.getForm();
		if ( form == null )	return false;
		RequestItem	item = req.getItem( ctl.getNameAttribute() );
		if ( item == null )	return false;
		RequestItem	form_id = req.getItem( Form.FORM_ID );
		if ( form_id == null )	return false;
		return	form.getID().equals( form_id.getValue() );
	}

	public boolean isClicked( RequestParameter req ) {
		return isClicked( req, this );
	}

	/**
	 * ボタン押下がされたか？
	 * @return true:押下された、false:押下されていない。
	 */
	public boolean isClicked() {
		return pushed;
	}

	public void setClicked( boolean flag ) {
		pushed = flag;
	}

	public Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception {
		return fw;
	}

	public void afterOutput( Page from, Page to, RequestParameter req ) throws Exception {
		commitDaemon();
	}

	public void commitDaemon() {
		setHandler( this );
	}

	static void setHandler( Tag t ) {
		StringBuilder	buf = new StringBuilder( "function(ev){" );
		buf = buf.append( "paraselene.form_kill=" );
		buf = buf.append( t.isAjaxEnable()?	"false":	"true" );
		buf = buf.append( ";}" );
		t.setAnonymousEventHandler( "click", buf.toString() );
	}
}

