/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import java.net.*;
import java.io.*;
import paraselene.*;
import paraselene.tag.form.*;


/**
 * Nullページ(直接呼び出し検証用)。
 */
public abstract class NullPage extends Page {

	/**
	 * コンストラクタ。
	 */
	public NullPage() {
		setHistoryKey( HistorySet.ROOT );
	}

	public final String getContentType() {
		return null;
	}

	public final String getCharset() {
		return null;
	}

	public final PageID getID() {
		return null;
	}

	public final Page output( Page from, RequestParameter req ) throws PageException { return null; }

	public void write( PrintWriter w ) throws UnsupportedEncodingException, URISyntaxException {}

	public final boolean isHistoryClear() {
		return true;
	}

	public final boolean isAllowHistoryAdd() {
		return false;
	}

	public final void init(){ }

	public final String getAliasURI() { return null; }

	public final int getUploadMaxBytes() { return 0; }

	public final boolean isCheckRepeatSameRequest() { return false; }

	public AjaxSupport getAjaxSupport() { return AjaxSupport.NO; }

	public void firstOutput( RequestParameter req ) throws PageException{}
}

class NullPage4Alias extends NullPage {
	public Forward input( RequestParameter req, Forward fw ) throws PageException {
		return fw;
	}
}

class Service extends NullPage {
	Page	page = null;
	Page	last = null;

	public Forward input( RequestParameter req, Forward fw ) throws PageException {
		RequestItem	item = req.getItem( PageFactory.CLOSE_ID );
		if ( item == null )	return new Forward( 403 );
		String[]	id = item.getAllValue();
		if ( id.length != 1)	return new Forward( 403 );
		Closure	cls = null;
		History	hist = req.getHistory();
		page = hist.getBrowsingPage( id[0] );
		last = hist.getBrowsingPage( req.getItem( Form.FORM_AJAX ).getValue( 0 ) );
		cls = new Closure( page );
		return new Forward( cls );
	}
	public AjaxSupport getAjaxSupport() { return AjaxSupport.POPUP_DIALOG; }
	public boolean isAjax() { return true; }
}

