/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;

/**
 * 遷移先指定。JavaScript をクライアントで実行します。<br>
 * Ajax 機能が無効な場合、{@link Feedback}と同じ動作となります。
 */
public class JavaScript extends Feedback {
	private static final long serialVersionUID = 2L;
	String[]	cmd;

	private JavaScript(){}
	/**
	 * コンストラクタ。
	 * @param script 実行命令文。
	 * 例えば、&quot;alert('エラーです');&quot;のように指定します。
	 * JavaScript関数の戻り値をサーバー側で受け取る事はできません。
	 */
	public JavaScript( String ... script ) {
		super();
		cmd = script;
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( "JavaScript:" );
		for ( int i = 0; i < cmd.length; i++ ) {
			buf = buf.append( cmd[i] );
			buf = buf.append( " / " );
		}
		return buf.toString();
	}

	public boolean equals( Object o ) {
		return false;
	}

	OutputCall makeOutput( PageFactory pf, int nk, Page lp, RequestParameter r, SessionData sd ) {
		Option.trace( "new ScriptOutput <- %s", this );
		return new ScriptOutput( pf, nk, lp, this, r, sd );
	}

	CometCall makeCometCall( PageFactory pf, History h ) {
		Option.trace( "new ScriptCometCall <- %s", this );
		return new ScriptCometCall( pf, h, this );
	}
}

