/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import paraselene.tag.*;
import paraselene.supervisor.*;


/**
 * XenoPage の具象クラスです。単純な<br>
 * &lt;html&gt;<br>
 &lt;head&gt;&lt;/head&gt;<br>
 &lt;body&gt;&lt;/body&gt;<br>
 &lt;/html&gt;<br>
 * だけの内容を持ちます。<br>
 * 例えば{@link paraselene.ui.Tab}がネストする場合の、内側のタブペインを持つ
 * ページのように、モックアップ用 html を準備するまでもないようページとしての
 * 使用を想定しています。<br>
 * SuperPage との派生関係が無い事に注意して下さい。<br>
 * input時は何もしないページとなりますが、タブペインのような場合、処理を記述する
 * 必要はありません(Tabクラスがinputを処理するため)。<br>
 * 例えばボタンを置き、その入力を得たい場合等は{@link Rider}インターフェイスを
 * 準備し、{@link PhantomPage#overRide(Rider)}を使用して下さい。<br><br>
 * このクラスインスタンスは PageLoader に登録され、PageID で取得可能です。<br>
 * {@link PhantomPage#getPageID()}で PageID が得られます。
 * <pre>
 * PageFactory pf = PageLoader.getPageFactory();<br>
 * PhantomPage page = (PhantomPage)pf.getPage( PhantomPage.getPageID() );
 * </pre>
 */
public class PhantomPage extends XenoPage {
	/**
	 * PhantomPage入力ハンドラ。
	 */
	public interface Rider {
		/**
		 * 入力値の検証を行う。
		 * @param page 呼び出されたページ。
		 * @param req リクエスト内容。
		 * @param fw デフォルト遷移先。
		 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
		 */
		Forward inputMain( PhantomPage page, RequestParameter req, Forward fw ) throws PageException;
	}
	private Rider	rider = null;
	private static PageID	page_id = null;

	/**
	 * inputのハンドリング。このインスタンスへの入力を引数インスタンスへ通知します。
	 * @param  phantom_rider PhantomPage入力ハンドラ。
	 */
	public void overRide( Rider phantom_rider ) {
		rider = phantom_rider;
	}

	/**
	 * フレームワークが使用します。
	 */
	public static void migrate( PageFactory pf ) throws Exception {
		if ( page_id != null )	return;
		page_id = pf.addDefine( PhantomPage.class );
	}

	public void init() {
		setPage( null );
		setDoctype( false, null );
	}

	/**
	 * コンストラクタ。
	 */
	public PhantomPage() {
		super();
		init();
	}

	/**
	 * ページ内容の設定。指定タイトルとタグで内容を書き換えます。
	 * @param page_title ページタイトル。
	 * @param page_body &lt;body&gt;へ設定するタグ。
	 */
	public void setPage( String page_title, Tag ... page_body ) {
		Tag	main = new Tag( "html", false );
		Tag head = new Tag( "head", false );
		if ( page_title != null ) {
			Tag	title = new Tag( "title", false );
			title.setValueString( page_title );
			head.addHTMLPart( title );
		}
		Tag body = new Tag( "body", false );
		if ( page_body.length > 0 ) {
			body.addHTMLPart( page_body );
		}
		main.addHTMLPart( head, body );
		setMainTag( main );
	}

	/**
	 * PageID を取得します。
	 * @return PageID。
	 */
	public static PageID getPageID() {
		return page_id;
	}

	public PageID getID() {
		return page_id;
	}

	public String getAliasURI() { return null; }
	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException{
		return ( rider == null )?	fw: rider.inputMain( this, req, fw );
	}
	public void firstOutputMain( RequestParameter req ) throws PageException {}
	public Page outputMain( Page from, RequestParameter req ) throws PageException {
		return null;
	}
}

