package #1.#z#2;


import #1.*;
import #1.#x.*;
import paraselene.*;
import paraselene.supervisor.*;
import paraselene.tag.*;
import paraselene.tag.form.*;
import paraselene.tag.list.*;
import paraselene.tag.table.*;
import paraselene.tag.ruby.*;
import paraselene.css.*;
import paraselene.ui.*;

/**
 * 同一階層ページ基底クラス。
 * このパッケージ(ディレクトリ)階層ページの共通メソッドを持たせたい場合には
 * このクラスに記述できます。
 */
public abstract class SuperPage extends #1#w.SuperPage {
	private static final long serialVersionUID = 1L;
	/**
	 * コンストラクタ。
	 */
	public SuperPage() {
		super();
	}

	/**
	 * 初期化。
	 */
	public void init() {
		super.init();
		// この階層の共通の初期化処理があれば記述して下さい。
	}

	/**
	 * 入力値の検証を行う。
	 * このメソッドが呼ばれる際には必ずセッションが発生しています。
	 * 入力値のエラーチェックや入力値に即した動作を記述します。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward input( RequestParameter req, Forward fw ) throws PageException {
		// この階層の共通処理等あれば記述して下さい。
		return super.input( req, fw );
	}

	/**
	 * 初回outputの呼び出し直前にコールされます。初期化処理を記述します。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutput( RequestParameter req ) throws PageException {
		// この階層の共通処理等あれば記述して下さい。
		super.firstOutput( req );
	}

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * nullを返すとthisをリターンしたのと同じ扱いにされます。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page output( Page from, RequestParameter req ) throws PageException {
		// この階層の共通処理等あれば記述して下さい。
		return super.output( from, req );
	}
}

