/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.net.URL;
import java.util.HashMap;
import paraselene.dyna.CreateParam;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.FileLoader;
import paraselene.dyna.StringLoader;
import paraselene.dyna.URLLoader;

public class DynamicPageReloader {
    static volatile int limit = 5;
    static volatile int inc = 10;
    static volatile int file_interval = 60000;
    static volatile int url_interval = 3600000;
    private static StringLoader str_loader = new StringLoader();
    private static FileLoader file_loader = new FileLoader();
    private static HashMap<String, URLLoader> url_loader = new HashMap();

    private DynamicPageReloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLLoader getLoader(URL url) {
        URLLoader loader = null;
        HashMap<String, URLLoader> hashMap = url_loader;
        synchronized (hashMap) {
            String host = url.getHost();
            loader = url_loader.get(host);
            if (loader == null) {
                loader = new URLLoader();
                url_loader.put(host, loader);
            }
        }
        return loader;
    }

    static DynamicPage getPage(CreateParam cp) {
        if (cp.file != null) {
            return file_loader.getPage(cp);
        }
        if (cp.url != null) {
            return DynamicPageReloader.getLoader(cp.url).getPage(cp);
        }
        return str_loader.getPage(cp);
    }

    public static Magazine issue(DynamicPage page) {
        CreateParam cp = page.param;
        if (cp == null) {
            return null;
        }
        if (cp.file != null) {
            file_loader.add(cp);
        } else if (cp.url != null) {
            DynamicPageReloader.getLoader(cp.url).add(cp);
        } else {
            str_loader.add(cp);
        }
        return cp;
    }

    public static interface Magazine {
        public DynamicPage getPage();

        public DynamicPageException getLastError();
    }
}

