/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import paraselene.Color;

public class HSL {
    public double hue;
    public double saturation;
    public double lightness;

    public HSL(double h, double s, double l) {
        this.hue = HSL.round(h);
        this.saturation = HSL.per(s);
        this.lightness = HSL.per(l);
    }

    private static double round(double r) {
        do {
            if (r < 0.0) {
                r += 360.0;
            }
            if (!(r >= 360.0)) continue;
            r -= 360.0;
        } while (!(r >= 0.0) || !(r < 360.0));
        return r;
    }

    private static double per(double p) {
        if (p < 0.0) {
            return 0.0;
        }
        if (p > 100.0) {
            return 100.0;
        }
        return p;
    }

    private static double rgb_to_per(double v) {
        if (v > 0.0) {
            v += 1.0;
        }
        return HSL.per(v * 100.0 / 256.0);
    }

    private static int per_to_rgb(double v) {
        if ((v = v * 256.0 / 100.0) > 255.0) {
            v = 255.0;
        }
        if (v < 255.0) {
            v -= 1.0;
        }
        if (v < 0.0) {
            v = 0.0;
        }
        return (int)v;
    }

    private static double max(double ... v) {
        double m = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(m < v[i])) continue;
            m = v[i];
        }
        return m;
    }

    private static double min(double ... v) {
        double m = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(m > v[i])) continue;
            m = v[i];
        }
        return m;
    }

    private static double toC(double v, double max, double min) {
        return (max - v) / (max - min);
    }

    static HSL getHSL(Color c) {
        double r = HSL.rgb_to_per(c.getRed());
        double g = HSL.rgb_to_per(c.getGreen());
        double b = HSL.rgb_to_per(c.getBlue());
        double max = HSL.max(r, g, b);
        double min = HSL.min(r, g, b);
        double l = HSL.per((max + min) / 2.0);
        double h = 0.0;
        double s = 0.0;
        if (max != min) {
            s = l > 50.0 ? (max - min) / (200.0 - max - min) : (max - min) / (max + min);
            s *= 100.0;
            double cr = HSL.toC(r, max, min);
            double cg = HSL.toC(g, max, min);
            double cb = HSL.toC(b, max, min);
            h = r == max ? cb - cg : (g == max ? 2.0 + cr - cb : 4.0 + cg - cr);
            h *= 60.0;
        }
        return new HSL(h, s, l);
    }

    private static double getH(double h, double max, double min) {
        if ((h = HSL.round(h)) < 60.0) {
            return min + (max - min) * h / 60.0;
        }
        if (h < 180.0) {
            return max;
        }
        if (h < 240.0) {
            return min + (max - min) * (240.0 - h) / 60.0;
        }
        return min;
    }

    void toColor(Color c) {
        double h = HSL.round(this.hue);
        double s = HSL.per(this.saturation);
        double l = HSL.per(this.lightness);
        if (s == 0.0) {
            int v = HSL.per_to_rgb(l);
            c.setColor(v, v, v);
            return;
        }
        double max = l > 50.0 ? l * (100.0 - s) + s : l * (100.0 + s);
        double min = 2.0 * l - max;
        int r = HSL.per_to_rgb(HSL.getH(h + 120.0, max, min));
        int g = HSL.per_to_rgb(HSL.getH(h, max, min));
        int b = HSL.per_to_rgb(HSL.getH(h - 120.0, max, min));
        c.setColor(r, g, b);
    }

    public String toString() {
        return String.format("hsl(%f, %f%%, %f%%)", this.hue, this.saturation, this.lightness);
    }
}

