/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.util.*;

/**
 * 検索エンジン判定。
 */
public class SearchEngineAgent {
	private static final String[][]	sea = new String[][]{
		new String[] { "googlebot" },
		new String[] { "mediapartners-google" },
		new String[] { "yahoo!", "slurp" },
		new String[] { "msnbot" }
	};

	private static boolean isSearchEngineAgent( String agent, String[] str ) {
		for ( int i = 0; i < str.length; i++ ) {
			if ( agent.toLowerCase( Locale.ENGLISH ).indexOf( str[i] ) == -1 )	return false;
		}
		return true;
	}

	/**
	 * 検索エンジン判定。
	 * 指定されたユーザーエージェントが検索エンジンであるか判定します。<br>
	 * 以下の３つを判定対象とします。
	 * <ul>
	 * <li>Google
	 * <li>Yahoo!
	 * <li>MSN
	 * </ul>
	 * @param agent ユーザーエージェント。
	 * @return true:何らかの検索エンジンである、false:検索エンジンではない。
	 */
	public static boolean isSearchEngineAgent( String agent ) {
		for ( int i = 0; i < sea.length; i++ ) {
			if ( isSearchEngineAgent( agent, sea[i] ) )	return true;
		}
		return false;
	}
}

