/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.util.ArrayList;
import java.util.Stack;
import paraselene.HTMLPart;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;

class SaxContainer {
    private DynamicPage pp;
    private Stack<Tag> stack = new Stack();
    private boolean dmy_stack = false;
    private Tag tag = null;
    private Tag first_tag = null;
    private HTMLPart last_part = null;
    private int escape = 0;

    SaxContainer(DynamicPage p) {
        this.pp = p;
    }

    void addTag(String name, ArrayList<Attribute> attr) throws Exception {
        HTMLPart.StringMode mode = Tag.selectMode(name);
        if (mode == HTMLPart.StringMode.TEXTAREA || mode == HTMLPart.StringMode.PLAIN) {
            ++this.escape;
        }
        this.add(this.pp.makeTag(name, attr));
    }

    private void add(HTMLPart p) {
        this.last_part = p;
        Tag nt = null;
        if (p instanceof Tag) {
            nt = (Tag)p;
            if ("meta".equals(nt.getName())) {
                Attribute attr = nt.getAttribute("http-equiv");
                if (attr != null && "Content-Type".equalsIgnoreCase(attr.getString())) {
                    nt.setVisible(false);
                }
            } else if ("tbody".equals(nt.getName())) {
                nt.setVisible(false);
            } else if ("tfoot".equals(nt.getName())) {
                nt.setVisible(false);
            } else if ("thead".equals(nt.getName())) {
                nt.setVisible(false);
            }
        }
        if (this.tag != null) {
            this.tag.addHTMLPart(p);
        }
        if (nt != null) {
            this.tag = nt;
            this.stack.push(this.tag);
            if (this.first_tag == null) {
                this.first_tag = this.tag;
                this.pp.setMainTag(this.tag);
            }
        }
    }

    private void delete(Tag t) {
        Tag[] tag = t.getTagArray();
        for (int i = tag.length - 1; i >= 0; --i) {
            if (tag[i].isVisible()) continue;
            t.exclude(tag[i]);
        }
    }

    void endTag() {
        HTMLPart.StringMode mode = Tag.selectMode(this.tag.getName());
        if (mode == HTMLPart.StringMode.TEXTAREA || mode == HTMLPart.StringMode.PLAIN) {
            --this.escape;
        }
        this.tag.replaceBR();
        this.delete(this.tag);
        this.stack.pop();
        this.tag = this.stack.empty() ? null : this.stack.peek();
    }

    void addText(char[] data, boolean xml_f) {
        this.addText(data, 0, data.length, xml_f);
    }

    void addText(char[] data, int start, int length, boolean xml_f) {
        String name = this.tag.getName();
        StringBuffer buf = new StringBuffer();
        boolean crlf_f = false;
        length += start;
        for (int i = start; i < length; ++i) {
            Tag t;
            if (data[i] == '\u00a0') {
                data[i] = 32;
            } else if (this.escape == 0 && (data[i] == '\n' || data[i] == '\r' || data[i] == '\t')) {
                data[i] = 32;
                if (data[i] != '\t') {
                    crlf_f = true;
                }
            }
            if (this.escape == 0 && data[i] == ' ' && i > 0 && xml_f && data[i - 1] == ' ') continue;
            if (data[i] == ' ' && this.last_part instanceof Tag && !(t = (Tag)this.last_part).isSimpleTag()) {
                this.last_part = null;
                continue;
            }
            buf = buf.append(data[i]);
            this.last_part = null;
        }
        if ("noframes".equals(name)) {
            StringBuffer sub = new StringBuffer("<body name='body'>");
            sub = sub.append(buf);
            sub = sub.append("</body>");
            DynamicPage sub_page = this.pp.makePage();
            try {
                sub_page.create(sub.toString());
                Tag body = sub_page.getTag("body");
                int cnt = body.getHTMLPartCount();
                for (int i = 0; i < cnt; ++i) {
                    HTMLPart p = body.getHTMLPart(0);
                    body.removeHTMLPart(0);
                    this.tag.addHTMLPart(p);
                }
            }
            catch (DynamicPageException e) {
                e.printStackTrace();
            }
        } else {
            String str = buf.toString();
            if (crlf_f) {
                str = str.trim();
            }
            if (str.isEmpty()) {
                return;
            }
            this.add(this.pp.makeText(str));
        }
    }

    void addComment(char[] data) {
        this.add(this.pp.makeComment(new String(data)));
    }
}

