/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import paraselene.HTMLPart;
import paraselene.WebChar;

public class Text
extends HTMLPart {
    private static final long serialVersionUID = 1L;
    private String text;

    protected Text() {
    }

    public Text(String txt) {
        this(txt, HTMLPart.StringMode.PLAIN);
    }

    public Text(long num, String format) {
        this(new Long(num), format);
    }

    public Text(double num, String format) {
        this(new Double(num), format);
    }

    public Text(Number num, String format) {
        this(new DecimalFormat(format).format(num));
    }

    public Text(Date date, String format) {
        this(new SimpleDateFormat(format).format(date));
    }

    public Text(String txt, HTMLPart.StringMode mode) {
        this.setText(txt, mode);
    }

    public void setText(String txt) {
        this.setText(txt, HTMLPart.StringMode.PLAIN);
    }

    public void setText(String txt, HTMLPart.StringMode mode) {
        if (txt == null || mode == HTMLPart.StringMode.PLAIN) {
            this.text = txt;
            return;
        }
        char[] line = txt.toCharArray();
        StringBuffer buf = new StringBuffer();
        StringBuffer esc = null;
        int spc_cnt = 0;
        boolean nbsp_f = false;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == '\n' || line[i] == '\r') {
                if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                buf = buf.append("\n");
                continue;
            }
            if (line[i] == ' ' || line[i] == '\t') {
                if (mode == HTMLPart.StringMode.TEXTAREA) {
                    buf = buf.append(line[i]);
                    continue;
                }
                ++spc_cnt;
                continue;
            }
            if (spc_cnt > 0) {
                if (mode == HTMLPart.StringMode.TABLE) {
                    if (nbsp_f) {
                        buf = buf.append(' ');
                        nbsp_f = false;
                    }
                } else {
                    buf = buf.append(' ');
                }
                spc_cnt = 0;
            }
            if (esc != null) {
                esc = esc.append(line[i]);
                if (line[i] != ';') continue;
                String amp = esc.toString();
                if ("&lt;".equalsIgnoreCase(amp)) {
                    buf = buf.append('<');
                } else if ("&gt;".equalsIgnoreCase(amp)) {
                    buf = buf.append('>');
                } else if ("&amp;".equalsIgnoreCase(amp)) {
                    buf = buf.append('&');
                } else if ("&quot;".equalsIgnoreCase(amp)) {
                    buf = buf.append('\"');
                } else if ("&nbsp;".equalsIgnoreCase(amp)) {
                    buf = buf.append(' ');
                    nbsp_f = true;
                } else {
                    buf = buf.append(esc);
                }
                esc = null;
                continue;
            }
            nbsp_f = false;
            if (line[i] == '&') {
                esc = new StringBuffer("&");
                continue;
            }
            spc_cnt = 0;
            buf = buf.append(line[i]);
            nbsp_f = false;
        }
        if (esc != null) {
            buf = buf.append(esc);
        }
        this.text = buf.toString();
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        return this.toString(this.text, mode);
    }

    private String toString(String str, HTMLPart.StringMode mode) {
        if (str == null) {
            return null;
        }
        if (mode == HTMLPart.StringMode.PLAIN) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        char[] line = str.toCharArray();
        int spc_cnt = 0;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == ' ') {
                String add = " ";
                switch (mode) {
                    case TABLE: 
                    case BODY: {
                        add = spc_cnt % 2 == 0 ? "&nbsp;" : " ";
                    }
                }
                ++spc_cnt;
                buf = buf.append(add);
                continue;
            }
            spc_cnt = 0;
            WebChar wc = WebChar.getWebChar(line[i]);
            if (wc != null) {
                buf = buf.append(wc.getRef());
                continue;
            }
            if (mode != HTMLPart.StringMode.ATTRIBUTE) {
                if (mode != HTMLPart.StringMode.TEXTAREA) {
                    if (line[i] == '\n' || line[i] == '\r') {
                        if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                        String br = "<br>";
                        if (this.embed != null && this.embed.isXML()) {
                            br = "<br />";
                        }
                        buf = buf.append(br);
                        continue;
                    }
                } else if (line[i] == '\n' || line[i] == '\r') {
                    if (i > 0 && (line[i - 1] == '\n' || line[i - 1] == '\r') && line[i] != line[i - 1]) continue;
                    buf = buf.append("\r\n");
                    continue;
                }
            }
            buf = buf.append(line[i]);
        }
        return buf.toString();
    }

    @Override
    public HTMLPart getReplica() {
        return new Text(this.text);
    }

    public void append(String add) {
        if (add == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(this.text);
        buf = buf.append(add);
        this.text = buf.toString();
    }

    public void append(Text add) {
        if (add == null) {
            return;
        }
        this.append(add.text);
    }
}

