/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import java.util.*;
import java.net.*;
import java.io.*;
import java.nio.charset.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.dyna.*;
import paraselene.dyna.mockup.*;


public enum LineSeparator {
	CR( "cr", "\r" ),
	LF( "lf", "\n" ),
	CRLF( "crlf", "\r\n" ),
	LFCR( "lfcr", "\n\r" );

	private static LineSeparator	use;
	private String name;
	private String code;
	private LineSeparator( String n, String c ) {
		name = n;
		code = c;
	}
	static String getOSName() {
		LineSeparator[]	ls = values();
		for ( int i = 0; i < ls.length; i++ ) {
			if ( ls[i].code.equals( System.getProperty("line.separator") ) ) {
				return ls[i].name;
			}
		}
		return CRLF.name;
	}

	static boolean setUse( String name ) {
		LineSeparator[]	ls = values();
		for ( int i = 0; i < ls.length; i++ ) {
			if ( ls[i].name.equals( name ) ) {
				use = ls[i];
				return true;
			}
		}
		return false;
	}

	public static String getUse() {
		if ( use == null )	return System.getProperty("line.separator");
		return use.code;
	}
}

