/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class MimeType {
    private static HashMap<String, String> map = new HashMap();
    private static HashMap<String, HashMap<String, String[]>> rev = new HashMap();

    private MimeType() {
    }

    private static void set_rev(String cat, String type, String[] ext) {
        HashMap<String, Object> sub = rev.get(cat);
        if (sub == null) {
            sub = new HashMap();
            rev.put(cat, sub);
        }
        sub.put(type, ext);
        StringBuilder buf = new StringBuilder(cat);
        buf = buf.append("/");
        buf = buf.append(type);
        type = buf.toString();
        for (int i = 0; i < ext.length; ++i) {
            map.put(ext[i], type);
        }
    }

    public static String getMimeType(String file) {
        String[] ext = file.split("\\.");
        String seek = ext[ext.length - 1].toLowerCase(Locale.ENGLISH);
        String ret = map.get(seek);
        if (ret == null) {
            return "application/octet-stream";
        }
        return ret;
    }

    public static String getMimeType(File file) {
        return MimeType.getMimeType(file.getName());
    }

    public static String[] getExtension(String mime) {
        String[] type = mime.split("/");
        HashMap<String, String[]> sub = rev.get(type[0]);
        if (sub == null) {
            return null;
        }
        if (type.length > 1) {
            return sub.get(type[1]);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : sub.keySet()) {
            String[] ext = sub.get(key);
            for (int i = 0; i < ext.length; ++i) {
                list.add(ext[i]);
            }
        }
        return list.toArray(new String[0]);
    }

    static {
        MimeType.set_rev("application", "andrew-inset", new String[]{"ez"});
        MimeType.set_rev("application", "atom", new String[]{"atom"});
        MimeType.set_rev("application", "atomcat+xml", new String[]{"atomcat"});
        MimeType.set_rev("application", "atomserv+xml", new String[]{"atomsrv"});
        MimeType.set_rev("application", "cap", new String[]{"pcap", "cap"});
        MimeType.set_rev("application", "cu-seeme", new String[]{"cu"});
        MimeType.set_rev("application", "dsptype", new String[]{"tsp"});
        MimeType.set_rev("application", "futuresplash", new String[]{"spl"});
        MimeType.set_rev("application", "hta", new String[]{"hta"});
        MimeType.set_rev("application", "java-archive", new String[]{"jar"});
        MimeType.set_rev("application", "java-serialized-object", new String[]{"ser"});
        MimeType.set_rev("application", "java-vm", new String[]{"class"});
        MimeType.set_rev("application", "mac-binhex40", new String[]{"hqx"});
        MimeType.set_rev("application", "mac-compactpro", new String[]{"cpt"});
        MimeType.set_rev("application", "mathematica", new String[]{"nb"});
        MimeType.set_rev("application", "msaccess", new String[]{"mdb"});
        MimeType.set_rev("application", "msword", new String[]{"doc", "dot"});
        MimeType.set_rev("application", "octet-stream", new String[]{"lzh", "iso", "so", "img", "dms", "class", "dll", "bin", "lha", "exe"});
        MimeType.set_rev("application", "oda", new String[]{"oda"});
        MimeType.set_rev("application", "ogg", new String[]{"ogg", "ogx"});
        MimeType.set_rev("application", "pdf", new String[]{"pdf"});
        MimeType.set_rev("application", "pgp-keys", new String[]{"key"});
        MimeType.set_rev("application", "pgp-signature", new String[]{"pgp"});
        MimeType.set_rev("application", "pics-rules", new String[]{"prf"});
        MimeType.set_rev("application", "postscript", new String[]{"eps", "ai", "ps"});
        MimeType.set_rev("application", "rar", new String[]{"rar"});
        MimeType.set_rev("application", "rdf+xml", new String[]{"rdf"});
        MimeType.set_rev("application", "rss+xml", new String[]{"rss"});
        MimeType.set_rev("application", "rtf", new String[]{"rtf"});
        MimeType.set_rev("application", "smil", new String[]{"smil", "smi"});
        MimeType.set_rev("application", "vnd.cinderella", new String[]{"cdy"});
        MimeType.set_rev("application", "vnd.google-earth.kml+xml", new String[]{"kml"});
        MimeType.set_rev("application", "vnd.google-earth.kmz", new String[]{"kmz"});
        MimeType.set_rev("application", "vnd.mif", new String[]{"mif"});
        MimeType.set_rev("application", "vnd.mozilla.xul+xml", new String[]{"xul"});
        MimeType.set_rev("application", "vnd.ms-excel", new String[]{"xlb", "xls", "xlt"});
        MimeType.set_rev("application", "vnd.ms-pki.seccat", new String[]{"cat"});
        MimeType.set_rev("application", "vnd.ms-pki.stl", new String[]{"stl"});
        MimeType.set_rev("application", "vnd.ms-powerpoint", new String[]{"pps", "ppt"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.chart", new String[]{"odc"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.database", new String[]{"odb"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.formula", new String[]{"odf"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.graphics", new String[]{"odg"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.graphics-template", new String[]{"otg"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.image", new String[]{"odi"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.presentation", new String[]{"odp"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.presentation-template", new String[]{"otp"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.spreadsheet", new String[]{"ods"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.spreadsheet-template", new String[]{"ots"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text", new String[]{"odt"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-master", new String[]{"odm"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-template", new String[]{"ott"});
        MimeType.set_rev("application", "vnd.oasis.opendocument.text-web", new String[]{"oth"});
        MimeType.set_rev("application", "vnd.rim.cod", new String[]{"cod"});
        MimeType.set_rev("application", "vnd.smaf", new String[]{"mmf"});
        MimeType.set_rev("application", "vnd.stardivision.calc", new String[]{"sdc"});
        MimeType.set_rev("application", "vnd.stardivision.chart", new String[]{"sds"});
        MimeType.set_rev("application", "vnd.stardivision.draw", new String[]{"sda"});
        MimeType.set_rev("application", "vnd.stardivision.impress", new String[]{"sdd"});
        MimeType.set_rev("application", "vnd.stardivision.math", new String[]{"sdf"});
        MimeType.set_rev("application", "vnd.stardivision.writer", new String[]{"sdw"});
        MimeType.set_rev("application", "vnd.stardivision.writer-global", new String[]{"sgl"});
        MimeType.set_rev("application", "vnd.sun.xml.calc", new String[]{"sxc"});
        MimeType.set_rev("application", "vnd.sun.xml.calc.template", new String[]{"stc"});
        MimeType.set_rev("application", "vnd.sun.xml.draw", new String[]{"sxd"});
        MimeType.set_rev("application", "vnd.sun.xml.draw.template", new String[]{"std"});
        MimeType.set_rev("application", "vnd.sun.xml.impress", new String[]{"sxi"});
        MimeType.set_rev("application", "vnd.sun.xml.impress.template", new String[]{"sti"});
        MimeType.set_rev("application", "vnd.sun.xml.math", new String[]{"sxm"});
        MimeType.set_rev("application", "vnd.sun.xml.writer", new String[]{"sxw"});
        MimeType.set_rev("application", "vnd.sun.xml.writer.global", new String[]{"sxg"});
        MimeType.set_rev("application", "vnd.sun.xml.writer.template", new String[]{"stw"});
        MimeType.set_rev("application", "vnd.symbian.install", new String[]{"sis"});
        MimeType.set_rev("application", "vnd.visio", new String[]{"vsd"});
        MimeType.set_rev("application", "vnd.wap.wbxml", new String[]{"wbxml"});
        MimeType.set_rev("application", "vnd.wap.wmlc", new String[]{"wmlc"});
        MimeType.set_rev("application", "vnd.wap.wmlscriptc", new String[]{"wmlsc"});
        MimeType.set_rev("application", "wordperfect", new String[]{"wpd"});
        MimeType.set_rev("application", "wordperfect5.1", new String[]{"wp5"});
        MimeType.set_rev("application", "x-123", new String[]{"wk"});
        MimeType.set_rev("application", "x-7z-compressed", new String[]{"7z"});
        MimeType.set_rev("application", "x-abiword", new String[]{"abw"});
        MimeType.set_rev("application", "x-apple-diskimage", new String[]{"dmg"});
        MimeType.set_rev("application", "x-bcpio", new String[]{"bcpio"});
        MimeType.set_rev("application", "x-bittorrent", new String[]{"torrent"});
        MimeType.set_rev("application", "x-bzip2", new String[]{"bz2"});
        MimeType.set_rev("application", "x-cab", new String[]{"cab"});
        MimeType.set_rev("application", "x-cbr", new String[]{"cbr"});
        MimeType.set_rev("application", "x-cbz", new String[]{"cbz"});
        MimeType.set_rev("application", "x-cdf", new String[]{"cdf"});
        MimeType.set_rev("application", "x-cdlink", new String[]{"vcd"});
        MimeType.set_rev("application", "x-chess-pgn", new String[]{"pgn"});
        MimeType.set_rev("application", "x-cpio", new String[]{"cpio"});
        MimeType.set_rev("application", "x-csh", new String[]{"csh"});
        MimeType.set_rev("application", "x-debian-package", new String[]{"deb", "udeb"});
        MimeType.set_rev("application", "x-director", new String[]{"dcr", "dir", "dxr"});
        MimeType.set_rev("application", "x-dms", new String[]{"dms"});
        MimeType.set_rev("application", "x-doom", new String[]{"wad"});
        MimeType.set_rev("application", "x-dvi", new String[]{"dvi"});
        MimeType.set_rev("application", "x-flac", new String[]{"flac"});
        MimeType.set_rev("application", "x-font", new String[]{"pfa", "pcf", "pfb", "pcf.Z", "gsf"});
        MimeType.set_rev("application", "x-freemind", new String[]{"mm"});
        MimeType.set_rev("application", "x-futuresplash", new String[]{"spl"});
        MimeType.set_rev("application", "x-gnumeric", new String[]{"gnumeric"});
        MimeType.set_rev("application", "x-go-sgf", new String[]{"sgf"});
        MimeType.set_rev("application", "x-graphing-calculator", new String[]{"gcf"});
        MimeType.set_rev("application", "x-gtar", new String[]{"taz", "tgz", "gtar"});
        MimeType.set_rev("application", "x-gzip", new String[]{"gz", "tgz"});
        MimeType.set_rev("application", "x-hdf", new String[]{"hdf"});
        MimeType.set_rev("application", "x-httpd-eruby", new String[]{"rhtml"});
        MimeType.set_rev("application", "x-httpd-php", new String[]{"pht", "php", "phtml"});
        MimeType.set_rev("application", "x-httpd-php-source", new String[]{"phps"});
        MimeType.set_rev("application", "x-httpd-php3", new String[]{"php3"});
        MimeType.set_rev("application", "x-httpd-php3-preprocessed", new String[]{"php3p"});
        MimeType.set_rev("application", "x-httpd-php4", new String[]{"php4"});
        MimeType.set_rev("application", "x-ica", new String[]{"ica"});
        MimeType.set_rev("application", "x-internet-signup", new String[]{"isp", "ins"});
        MimeType.set_rev("application", "x-iphone", new String[]{"iii"});
        MimeType.set_rev("application", "x-iso9660-image", new String[]{"iso"});
        MimeType.set_rev("application", "x-java-archive", new String[]{"jar"});
        MimeType.set_rev("application", "x-java-jnlp-file", new String[]{"jnlp"});
        MimeType.set_rev("application", "x-javascript", new String[]{"js"});
        MimeType.set_rev("application", "x-jmol", new String[]{"jmz"});
        MimeType.set_rev("application", "x-kchart", new String[]{"chrt"});
        MimeType.set_rev("application", "x-killustrator", new String[]{"kil"});
        MimeType.set_rev("application", "x-koan", new String[]{"skm", "skp", "skd", "skt"});
        MimeType.set_rev("application", "x-kpresenter", new String[]{"kpr", "kpt"});
        MimeType.set_rev("application", "x-kspread", new String[]{"ksp"});
        MimeType.set_rev("application", "x-kword", new String[]{"kwd", "kwt"});
        MimeType.set_rev("application", "x-latex", new String[]{"latex"});
        MimeType.set_rev("application", "x-lha", new String[]{"lha"});
        MimeType.set_rev("application", "x-lyx", new String[]{"lyx"});
        MimeType.set_rev("application", "x-lzh", new String[]{"lzh"});
        MimeType.set_rev("application", "x-lzx", new String[]{"lzx"});
        MimeType.set_rev("application", "x-maker", new String[]{"frm", "fm", "fbdoc", "frame", "maker", "book", "fb"});
        MimeType.set_rev("application", "x-mif", new String[]{"mif"});
        MimeType.set_rev("application", "x-ms-wmd", new String[]{"wmd"});
        MimeType.set_rev("application", "x-ms-wmz", new String[]{"wmz"});
        MimeType.set_rev("application", "x-msdos-program", new String[]{"com", "dll", "bat", "exe"});
        MimeType.set_rev("application", "x-msi", new String[]{"msi"});
        MimeType.set_rev("application", "x-netcdf", new String[]{"nc", "cdf"});
        MimeType.set_rev("application", "x-ns-proxy-autoconfig", new String[]{"pac"});
        MimeType.set_rev("application", "x-nwc", new String[]{"nwc"});
        MimeType.set_rev("application", "x-object", new String[]{"o"});
        MimeType.set_rev("application", "x-oz-application", new String[]{"oza"});
        MimeType.set_rev("application", "x-pkcs7-certreqresp", new String[]{"p7r"});
        MimeType.set_rev("application", "x-pkcs7-crl", new String[]{"crl"});
        MimeType.set_rev("application", "x-python-code", new String[]{"pyc", "pyo"});
        MimeType.set_rev("application", "x-quicktimeplayer", new String[]{"qtl"});
        MimeType.set_rev("application", "x-redhat-package-manager", new String[]{"rpm"});
        MimeType.set_rev("application", "x-rpm", new String[]{"rpm"});
        MimeType.set_rev("application", "x-sh", new String[]{"sh"});
        MimeType.set_rev("application", "x-shar", new String[]{"shar"});
        MimeType.set_rev("application", "x-shockwave-flash", new String[]{"swf", "swfl"});
        MimeType.set_rev("application", "x-stuffit", new String[]{"sit", "sitx"});
        MimeType.set_rev("application", "x-sv4cpio", new String[]{"sv4cpio"});
        MimeType.set_rev("application", "x-sv4crc", new String[]{"sv4crc"});
        MimeType.set_rev("application", "x-tar", new String[]{"tar"});
        MimeType.set_rev("application", "x-tcl", new String[]{"tcl"});
        MimeType.set_rev("application", "x-tex", new String[]{"tex"});
        MimeType.set_rev("application", "x-tex-gf", new String[]{"gf"});
        MimeType.set_rev("application", "x-tex-pk", new String[]{"pk"});
        MimeType.set_rev("application", "x-texinfo", new String[]{"texinfo", "texi"});
        MimeType.set_rev("application", "x-trash", new String[]{"old", "bak", "%", "~", "sik"});
        MimeType.set_rev("application", "x-troff", new String[]{"t", "tr", "roff"});
        MimeType.set_rev("application", "x-troff-man", new String[]{"man"});
        MimeType.set_rev("application", "x-troff-me", new String[]{"me"});
        MimeType.set_rev("application", "x-troff-ms", new String[]{"ms"});
        MimeType.set_rev("application", "x-ustar", new String[]{"ustar"});
        MimeType.set_rev("application", "x-wais-source", new String[]{"src"});
        MimeType.set_rev("application", "x-wingz", new String[]{"wz"});
        MimeType.set_rev("application", "x-x509-ca-cert", new String[]{"crt"});
        MimeType.set_rev("application", "x-xcf", new String[]{"xcf"});
        MimeType.set_rev("application", "x-xfig", new String[]{"fig"});
        MimeType.set_rev("application", "x-xpinstall", new String[]{"xpi"});
        MimeType.set_rev("application", "xhtml+xml", new String[]{"xhtml", "xht"});
        MimeType.set_rev("application", "xml", new String[]{"xsl", "xml"});
        MimeType.set_rev("application", "zip", new String[]{"zip"});
        MimeType.set_rev("audio", "basic", new String[]{"au", "snd"});
        MimeType.set_rev("audio", "midi", new String[]{"midi", "kar", "mid"});
        MimeType.set_rev("audio", "mpeg", new String[]{"m4a", "mp2", "mpga", "mp3", "mpega"});
        MimeType.set_rev("audio", "mpegurl", new String[]{"m3u"});
        MimeType.set_rev("audio", "ogg", new String[]{"spx", "oga"});
        MimeType.set_rev("audio", "prs.sid", new String[]{"sid"});
        MimeType.set_rev("audio", "x-aiff", new String[]{"aifc", "aif", "aiff"});
        MimeType.set_rev("audio", "x-gsm", new String[]{"gsm"});
        MimeType.set_rev("audio", "x-mpegurl", new String[]{"m3u"});
        MimeType.set_rev("audio", "x-ms-wax", new String[]{"wax"});
        MimeType.set_rev("audio", "x-ms-wma", new String[]{"wma"});
        MimeType.set_rev("audio", "x-pn-realaudio", new String[]{"ra", "rm", "ram"});
        MimeType.set_rev("audio", "x-realaudio", new String[]{"ra"});
        MimeType.set_rev("audio", "x-scpls", new String[]{"pls"});
        MimeType.set_rev("audio", "x-sd2", new String[]{"sd2"});
        MimeType.set_rev("audio", "x-wav", new String[]{"wav"});
        MimeType.set_rev("chemical", "x-alchemy", new String[]{"alc"});
        MimeType.set_rev("chemical", "x-cache", new String[]{"cac", "cache"});
        MimeType.set_rev("chemical", "x-cache-csf", new String[]{"csf"});
        MimeType.set_rev("chemical", "x-cactvs-binary", new String[]{"ctab", "cascii", "cbin"});
        MimeType.set_rev("chemical", "x-cdx", new String[]{"cdx"});
        MimeType.set_rev("chemical", "x-cerius", new String[]{"cer"});
        MimeType.set_rev("chemical", "x-chem3d", new String[]{"c3d"});
        MimeType.set_rev("chemical", "x-chemdraw", new String[]{"chm"});
        MimeType.set_rev("chemical", "x-cif", new String[]{"cif"});
        MimeType.set_rev("chemical", "x-cmdf", new String[]{"cmdf"});
        MimeType.set_rev("chemical", "x-cml", new String[]{"cml"});
        MimeType.set_rev("chemical", "x-compass", new String[]{"cpa"});
        MimeType.set_rev("chemical", "x-crossfire", new String[]{"bsd"});
        MimeType.set_rev("chemical", "x-csml", new String[]{"csml", "csm"});
        MimeType.set_rev("chemical", "x-ctx", new String[]{"ctx"});
        MimeType.set_rev("chemical", "x-cxf", new String[]{"cxf", "cef"});
        MimeType.set_rev("chemical", "x-embl-dl-nucleotide", new String[]{"embl", "emb"});
        MimeType.set_rev("chemical", "x-galactic-spc", new String[]{"spc"});
        MimeType.set_rev("chemical", "x-gamess-input", new String[]{"inp", "gamin", "gam"});
        MimeType.set_rev("chemical", "x-gaussian-checkpoint", new String[]{"fchk", "fch"});
        MimeType.set_rev("chemical", "x-gaussian-cube", new String[]{"cub"});
        MimeType.set_rev("chemical", "x-gaussian-input", new String[]{"gau", "gjc", "gjf"});
        MimeType.set_rev("chemical", "x-gaussian-log", new String[]{"gal"});
        MimeType.set_rev("chemical", "x-gcg8-sequence", new String[]{"gcg"});
        MimeType.set_rev("chemical", "x-genbank", new String[]{"gen"});
        MimeType.set_rev("chemical", "x-hin", new String[]{"hin"});
        MimeType.set_rev("chemical", "x-isostar", new String[]{"ist", "istr"});
        MimeType.set_rev("chemical", "x-jcamp-dx", new String[]{"dx", "jdx"});
        MimeType.set_rev("chemical", "x-kinemage", new String[]{"kin"});
        MimeType.set_rev("chemical", "x-macmolecule", new String[]{"mcm"});
        MimeType.set_rev("chemical", "x-macromodel-input", new String[]{"mmod", "mmd"});
        MimeType.set_rev("chemical", "x-mdl-molfile", new String[]{"mol"});
        MimeType.set_rev("chemical", "x-mdl-rdfile", new String[]{"rd"});
        MimeType.set_rev("chemical", "x-mdl-rxnfile", new String[]{"rxn"});
        MimeType.set_rev("chemical", "x-mdl-sdfile", new String[]{"sdf", "sd"});
        MimeType.set_rev("chemical", "x-mdl-tgf", new String[]{"tgf"});
        MimeType.set_rev("chemical", "x-mmcif", new String[]{"mcif"});
        MimeType.set_rev("chemical", "x-mol2", new String[]{"mol2"});
        MimeType.set_rev("chemical", "x-molconn-Z", new String[]{"b"});
        MimeType.set_rev("chemical", "x-mopac-graph", new String[]{"gpt"});
        MimeType.set_rev("chemical", "x-mopac-input", new String[]{"dat", "mpc", "zmt", "mop", "mopcrt"});
        MimeType.set_rev("chemical", "x-mopac-out", new String[]{"moo"});
        MimeType.set_rev("chemical", "x-mopac-vib", new String[]{"mvb"});
        MimeType.set_rev("chemical", "x-ncbi-asn1", new String[]{"asn"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-ascii", new String[]{"prt", "ent"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-binary", new String[]{"val", "aso"});
        MimeType.set_rev("chemical", "x-ncbi-asn1-spec", new String[]{"asn"});
        MimeType.set_rev("chemical", "x-pdb", new String[]{"pdb", "ent"});
        MimeType.set_rev("chemical", "x-rosdal", new String[]{"ros"});
        MimeType.set_rev("chemical", "x-swissprot", new String[]{"sw"});
        MimeType.set_rev("chemical", "x-vamas-iso14976", new String[]{"vms"});
        MimeType.set_rev("chemical", "x-vmd", new String[]{"vmd"});
        MimeType.set_rev("chemical", "x-xtel", new String[]{"xtel"});
        MimeType.set_rev("chemical", "x-xyz", new String[]{"xyz"});
        MimeType.set_rev("image", "bmp", new String[]{"bmp"});
        MimeType.set_rev("image", "gif", new String[]{"gif"});
        MimeType.set_rev("image", "ief", new String[]{"ief"});
        MimeType.set_rev("image", "jpeg", new String[]{"jpg", "jpeg", "jpe"});
        MimeType.set_rev("image", "pcx", new String[]{"pcx"});
        MimeType.set_rev("image", "png", new String[]{"png"});
        MimeType.set_rev("image", "svg+xml", new String[]{"svgz", "svg"});
        MimeType.set_rev("image", "tiff", new String[]{"tif", "tiff"});
        MimeType.set_rev("image", "vnd.djvu", new String[]{"djvu", "djv"});
        MimeType.set_rev("image", "vnd.wap.wbmp", new String[]{"wbmp"});
        MimeType.set_rev("image", "x-cmu-raster", new String[]{"ras"});
        MimeType.set_rev("image", "x-coreldraw", new String[]{"cdr"});
        MimeType.set_rev("image", "x-coreldrawpattern", new String[]{"pat"});
        MimeType.set_rev("image", "x-coreldrawtemplate", new String[]{"cdt"});
        MimeType.set_rev("image", "x-corelphotopaint", new String[]{"cpt"});
        MimeType.set_rev("image", "x-icon", new String[]{"ico"});
        MimeType.set_rev("image", "x-jg", new String[]{"art"});
        MimeType.set_rev("image", "x-jng", new String[]{"jng"});
        MimeType.set_rev("image", "x-ms-bmp", new String[]{"bmp"});
        MimeType.set_rev("image", "x-photoshop", new String[]{"psd"});
        MimeType.set_rev("image", "x-portable-anymap", new String[]{"pnm"});
        MimeType.set_rev("image", "x-portable-bitmap", new String[]{"pbm"});
        MimeType.set_rev("image", "x-portable-graymap", new String[]{"pgm"});
        MimeType.set_rev("image", "x-portable-pixmap", new String[]{"ppm"});
        MimeType.set_rev("image", "x-rgb", new String[]{"rgb"});
        MimeType.set_rev("image", "x-xbitmap", new String[]{"xbm"});
        MimeType.set_rev("image", "x-xpixmap", new String[]{"xpm"});
        MimeType.set_rev("image", "x-xwindowdump", new String[]{"xwd"});
        MimeType.set_rev("message", "rfc822", new String[]{"eml"});
        MimeType.set_rev("model", "iges", new String[]{"igs", "iges"});
        MimeType.set_rev("model", "mesh", new String[]{"silo", "msh", "mesh"});
        MimeType.set_rev("model", "vrml", new String[]{"vrml", "wrl"});
        MimeType.set_rev("text", "calendar", new String[]{"ics", "icz"});
        MimeType.set_rev("text", "css", new String[]{"css"});
        MimeType.set_rev("text", "csv", new String[]{"csv"});
        MimeType.set_rev("text", "h323", new String[]{"323"});
        MimeType.set_rev("text", "html", new String[]{"shtml", "html", "htm"});
        MimeType.set_rev("text", "iuls", new String[]{"uls"});
        MimeType.set_rev("text", "mathml", new String[]{"mml"});
        MimeType.set_rev("text", "plain", new String[]{"text", "asc", "pot", "txt"});
        MimeType.set_rev("text", "richtext", new String[]{"rtx"});
        MimeType.set_rev("text", "rtf", new String[]{"rtf"});
        MimeType.set_rev("text", "scriptlet", new String[]{"wsc", "sct"});
        MimeType.set_rev("text", "sgml", new String[]{"sgm", "sgml"});
        MimeType.set_rev("text", "tab-separated-values", new String[]{"tsv"});
        MimeType.set_rev("text", "texmacs", new String[]{"tm", "ts"});
        MimeType.set_rev("text", "vnd.sun.j2me.app-descriptor", new String[]{"jad"});
        MimeType.set_rev("text", "vnd.wap.wml", new String[]{"wml"});
        MimeType.set_rev("text", "vnd.wap.wmlscript", new String[]{"wmls"});
        MimeType.set_rev("text", "x-bibtex", new String[]{"bib"});
        MimeType.set_rev("text", "x-boo", new String[]{"boo"});
        MimeType.set_rev("text", "x-c++hdr", new String[]{"hh", "h++", "hxx", "hpp"});
        MimeType.set_rev("text", "x-c++src", new String[]{"cpp", "cxx", "c++", "cc"});
        MimeType.set_rev("text", "x-chdr", new String[]{"h"});
        MimeType.set_rev("text", "x-component", new String[]{"htc"});
        MimeType.set_rev("text", "x-csh", new String[]{"csh"});
        MimeType.set_rev("text", "x-csrc", new String[]{"c"});
        MimeType.set_rev("text", "x-diff", new String[]{"diff", "patch"});
        MimeType.set_rev("text", "x-dsrc", new String[]{"d"});
        MimeType.set_rev("text", "x-haskell", new String[]{"hs"});
        MimeType.set_rev("text", "x-java", new String[]{"java"});
        MimeType.set_rev("text", "x-literate-haskell", new String[]{"lhs"});
        MimeType.set_rev("text", "x-moc", new String[]{"moc"});
        MimeType.set_rev("text", "x-pascal", new String[]{"pas", "p"});
        MimeType.set_rev("text", "x-pcs-gcd", new String[]{"gcd"});
        MimeType.set_rev("text", "x-perl", new String[]{"pl", "pm"});
        MimeType.set_rev("text", "x-python", new String[]{"py"});
        MimeType.set_rev("text", "x-setext", new String[]{"etx"});
        MimeType.set_rev("text", "x-sh", new String[]{"sh"});
        MimeType.set_rev("text", "x-tcl", new String[]{"tcl", "tk"});
        MimeType.set_rev("text", "x-tex", new String[]{"cls", "ltx", "tex", "sty"});
        MimeType.set_rev("text", "x-vcalendar", new String[]{"vcs"});
        MimeType.set_rev("text", "x-vcard", new String[]{"vcf"});
        MimeType.set_rev("text", "xml", new String[]{"xsl", "xml"});
        MimeType.set_rev("video", "3gpp", new String[]{"3gp"});
        MimeType.set_rev("video", "dl", new String[]{"dl"});
        MimeType.set_rev("video", "dv", new String[]{"dv", "dif"});
        MimeType.set_rev("video", "fli", new String[]{"fli"});
        MimeType.set_rev("video", "gl", new String[]{"gl"});
        MimeType.set_rev("video", "mp4", new String[]{"mp4"});
        MimeType.set_rev("video", "mpeg", new String[]{"mpeg", "mpg", "mpe"});
        MimeType.set_rev("video", "ogg", new String[]{"ogv"});
        MimeType.set_rev("video", "quicktime", new String[]{"mov", "qt"});
        MimeType.set_rev("video", "vnd.mpegurl", new String[]{"mxu"});
        MimeType.set_rev("video", "x-flv", new String[]{"flv"});
        MimeType.set_rev("video", "x-la-asf", new String[]{"lsx", "lsf"});
        MimeType.set_rev("video", "x-mng", new String[]{"mng"});
        MimeType.set_rev("video", "x-ms-asf", new String[]{"asf", "asx"});
        MimeType.set_rev("video", "x-ms-wm", new String[]{"wm"});
        MimeType.set_rev("video", "x-ms-wmv", new String[]{"wmv"});
        MimeType.set_rev("video", "x-ms-wmx", new String[]{"wmx"});
        MimeType.set_rev("video", "x-ms-wvx", new String[]{"wvx"});
        MimeType.set_rev("video", "x-msvideo", new String[]{"avi"});
        MimeType.set_rev("video", "x-sgi-movie", new String[]{"movie"});
        MimeType.set_rev("x-conference", "x-cooltalk", new String[]{"ice"});
        MimeType.set_rev("x-epoc", "x-sisx-app", new String[]{"sisx"});
        MimeType.set_rev("x-world", "x-vrml", new String[]{"vrml", "wrl", "vrm"});
    }
}

