/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tool;

import java.io.*;
import java.net.*;
import java.util.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.mockup.*;
import paraselene.dyna.*;
import paraselene.supervisor.*;


class MobileData {
	private String	name;
	private URL		url;
	private File	output;
	private ArrayList<String>	ip = new ArrayList<String>();

	private String trim( String str ) {
		str = str.trim();
		if ( str.isEmpty() )	return null;
		return str;
	}

	MobileData( String line, String dir ) throws MalformedURLException {
		String[]	str = line.split( "\\p{Space}" );
		if ( str.length < 2 ) {
			System.out.println( "入力ファイルのフォーマットが間違っています。" );
			System.exit( 1 );
		}
		int	no = 0;
		for ( ; no < str.length; no++ ) {
			name = trim( str[no] );
			if ( name == null )	continue;
			no++;
			break;
		}
		for ( ; no < str.length; no++ ) {
			String	dmy = trim( str[no] );
			if ( dmy == null )	continue;
			url = new URL( dmy );
			break;
		}
		if ( name == null || url == null ) {
			System.out.println( "入力ファイルのフォーマットが間違っています。" );
			System.exit( 1 );
		}
		Output.mkdir( dir );
		StringBuilder	buf = new StringBuilder( dir );
		buf = buf.append( File.separator );
		buf = buf.append( name );
		buf = buf.append( "." );
		buf = buf.append( MobileIP.EXT );
		output = new File( buf.toString() );
	}

	private String	last_ip;

	private void parse_ip( String str ) {
		str.trim();
		if ( str.isEmpty() )	return;
		String[]	data = str.split( "\\." );
		if ( data.length != 4 )	return;
		StringBuilder	buf = new StringBuilder( data[0] );
		for ( int i = 1; i < data.length; i++ ) {
			buf = buf.append( "." );
			buf = buf.append( data[i] );
		}
		last_ip = buf.toString();
	}

	private void parse( String str ) {
		str.trim();
		if ( str.isEmpty() )	return;
		if ( str.charAt( 0 ) == '/' && last_ip != null ) {
			ip.add( last_ip + str );
			last_ip = null;
			return;
		}
		String[]	ip_mask = str.split( "/" );
		if ( ip_mask.length == 2 ) {
			parse_ip( ip_mask[0] );
			if ( last_ip == null )	return;
			ip.add( last_ip + "/" + ip_mask[1] );
			last_ip = null;
		}
		else if ( ip_mask.length == 1 ) {
			parse_ip( ip_mask[0] );
		}
	}

	private void parse( PlainText text ) {
		String	str = text.toString();
		if ( str == null )	return;
		String[]	data = str.split( "\\p{Space}" );
		for ( int i = 0; i < data.length; i++ ) {
			parse( data[i] );
		}
	}

	private void seek( Tag tag ) {
		if ( tag == null )	return;
		Tag[]	next = tag.getTagArray();
		for ( int i = 0; i < next.length; i++ )	seek( next[i] );
		int	cnt = tag.getHTMLPartCount();
		for ( int i = 0; i < cnt; i++ ) {
			HTMLPart	hp = tag.getHTMLPart( i );
			if ( hp instanceof PlainText )	parse( (PlainText)hp );
		}
	}

	void get() throws DynamicPageException, IOException {
		DynamicPage	page = new DynamicPage( new URIResolver(){
			public String resolve(String src){return "";}
			public boolean isParamURIName(String name){return false;}
		},null );
		System.out.println( url.toString() + " >> " + output.toString() );
		page.create( url, RequestParameter.Method.GET, null );
		seek( page.getFirstTagByType( "body" ) );
		int	cnt = ip.size();
		BufferedWriter	w = new BufferedWriter( new FileWriter( output ) );
		for ( int i = 0; i < cnt; i++ ) {
			w.write( ip.get( i ) );
			w.write( LineSeparator.getUse() );
		}
		w.close();
	}
}

public class MobileIP {
	public static final String EXT = "mip";

	private static final String[]	KEY = new String[] {
		"-i", "-o"
	};
	private static String[]	data = new String[KEY.length];

	private static void help() {
		System.out.println( "usage:" );
		System.out.println( "  -i 設定ファイル" );
		System.out.println( "  -o 出力先ディレクトリ" );
		System.exit( 1 );
	}

	private static int getArgs( String[] argv, int no ) {
		for ( int i = 0; i < KEY.length; i++ ) {
			if ( KEY[i].equals( argv[no] ) ) {
				if ( argv.length <= (no + 1) )	help();
				data[i] = argv[no + 1];
				return no + 2;
			}
		}
		help();
		return 0;
	}

	public static void main( String[] argv ) throws Exception {
		for ( int i = 0; i < argv.length; ) {
			i = getArgs( argv, i );
		}
		for ( int i = 0; i < data.length; i++ ) {
			if ( data[i] == null )	help();
		}
		BufferedReader	r = new BufferedReader( new FileReader( data[0] ) );
		while( true ) {
			String	line = r.readLine();
			if ( line == null )	break;
			line = line.trim();
			if ( line.isEmpty() )	continue;
			new MobileData( line, data[1] ).get();
		}
		r.close();
	}
}



