/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.table;

import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.tag.Tag;
import paraselene.tag.table.Column;
import paraselene.tag.table.Table;

public class Line
extends Tag {
    private static final long serialVersionUID = 2L;

    public Line() {
        super("tr", false);
    }

    @Override
    protected Tag newReplica() {
        return new Line();
    }

    void setDirty() {
        Tag tag = this.getOuterTag();
        if (!(tag instanceof Table)) {
            return;
        }
        Table table = (Table)tag;
        if (table != null) {
            table.setDirty();
        }
    }

    void removeMe() {
        Table table = (Table)this.getOuterTag();
        if (table != null) {
            table.removeLine(this);
        }
    }

    public Column[] getColumnArray() {
        Tag[] tag = this.getTagArray();
        ArrayList<Column> clm = new ArrayList<Column>();
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof Column)) continue;
            clm.add((Column)tag[i]);
        }
        return clm.toArray(new Column[0]);
    }

    public Column getColumn(int no) {
        if (no < 0) {
            return null;
        }
        Column[] tag = this.getColumnArray();
        if (no >= tag.length) {
            return null;
        }
        return tag[no];
    }

    public void addColumn(Column column) {
        this.setDirty();
        this.addHTMLPart((HTMLPart)column);
    }

    public void addColumn(int idx, Column column) {
        this.setDirty();
        Column[] clm = this.getColumnArray();
        if (clm.length <= idx) {
            this.addHTMLPart((HTMLPart)column);
            return;
        }
        this.addHTMLPart(this.indexOf(clm[idx]), (HTMLPart)column);
    }

    public void setValueString(int start, String ... str) {
        if (str == null) {
            return;
        }
        Column[] clm = this.getColumnArray();
        for (int i = 0; i + start < clm.length && i < str.length; ++i) {
            clm[i + start].setValueString(str[i]);
        }
    }

    public int indexOfColumn(Column column) {
        Column[] clm = this.getColumnArray();
        for (int i = 0; i < clm.length; ++i) {
            if (clm[i] != column) continue;
            return i;
        }
        return -1;
    }

    public void removeColumn(int idx) {
        this.setDirty();
        Column[] clm = this.getColumnArray();
        if (clm.length <= idx) {
            return;
        }
        this.removeHTMLPart(clm[idx]);
        if (this.getColumnArray().length == 0) {
            this.removeMe();
        }
    }

    public void removeColumn(Column column) {
        this.setDirty();
        this.removeHTMLPart(column);
        if (this.getColumnArray().length == 0) {
            this.removeMe();
        }
    }

    public void clearColumnInner() {
        this.clearColumnInner(0, Integer.MAX_VALUE);
    }

    public void clearColumnInner(int start, int count) {
        Column[] clm = this.getColumnArray();
        if ((count += start) > clm.length) {
            count = clm.length;
        }
        if (start < 0) {
            start = 0;
        }
        while (start < count) {
            clm[start].removeHTMLPart();
            ++start;
        }
    }

    int getColumnRowCount() {
        int cnt = 0;
        Column[] clm = this.getColumnArray();
        for (int i = 0; i < clm.length; ++i) {
            cnt += clm[i].getColspan();
        }
        return cnt;
    }
}

