/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.util.HashMap;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.ServerInformation;
import paraselene.supervisor.TransactionSequencer;

public class PageServerInformation
implements ServerInformation {
    private static HashMap<String, PageFactory> fact = new HashMap();
    private static final long serialVersionUID = 2L;
    private String server;
    private String context;
    private TransactionSequencer seq;
    private boolean search_flag;
    private HistorySet hist;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PageServerInformation(DataHolder holder) {
        this.server = holder.getServerName();
        this.context = holder.getContextPath();
        this.seq = this.getTransactionSequencer();
        this.search_flag = holder.isSearchEngine();
        this.hist = holder.getHistorySet();
        HashMap<String, PageFactory> hashMap = fact;
        synchronized (hashMap) {
            if (fact.get(this.context) == null) {
                fact.put(this.context, holder.getPageFactory());
            }
        }
    }

    @Override
    public String getServerName() {
        return this.server;
    }

    @Override
    public String getContextPath() {
        return this.context;
    }

    @Override
    public TransactionSequencer getTransactionSequencer() {
        return this.seq;
    }

    @Override
    public boolean isSearchEngine() {
        return this.search_flag;
    }

    @Override
    public HistorySet getHistorySet() {
        return this.hist;
    }

    @Override
    public PageFactory getPageFactory() {
        return fact.get(this.context);
    }
}

