/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna.mockup;

import java.net.*;

/**
 * スケルトン生成ツールのURI解決時事前検証。
 * スケルトン生成中にURIを見つけるとコールされ、以降の処理を制御できます。
 */
public interface URIPreProcess {
	/**
	 * URI検証。
	 * 発見したURIの扱いを決定できます。
	 * @param class_name 処理中HTMLページのクラス名。
	 * パッケージ名を含む文字列です。
	 * @param src 発見したURI文字列。
	 * @return 解決後のURI処理方法。
	 * nullをリターンするとスケルトン生成ツールはデフォルト処理となります。
	 * @exception Exception スケルトン生成を中断させます。
	 */
	URIHandle getHandle( String class_name, URI src ) throws Exception;
}

