/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.net.*;
import java.io.*;

/**
 * テキスト。出力時に一切テキストの加工を行いません。<br>
 * 入力値をタグとして認識させたい場合などの特殊な用途で使用できます。
 */
public class PlainText extends Text {
	private static final long serialVersionUID = 1L;
	protected PlainText() {}

	/**
	 * コンストラクタ。StringMode.PLAIN扱い。
	 * @param txt テキスト。
	 */
	public PlainText( String txt ) {
		super( txt, StringMode.PLAIN );
	}

	/**
	 * コンストラクタ。
	 * @param txt テキスト。
	 * @param mode 入力文字列種別。
	 */
	public PlainText( String txt, StringMode mode ) {
		super( txt, mode );
	}

	/**
	 * テキスト化。
	 * @param mode 出力モード。無視されます。
	 * @return 文字列。
	 */
	public String toString( StringMode mode ) {
		return super.toString( StringMode.PLAIN );
	}

	public HTMLPart getReplica() {
		return new PlainText( super.toString( StringMode.PLAIN ) );
	}
}


