// Paraselene2 2.2.2.17 (http://paraselene.sourceforge.jp/) generated this source file.
/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup.output.source.base;
public class FormJson extends paraselene.mockup.Output {
protected String getFileByte() { return
"package #1.#x;\n\nimport javax.servlet.http.*;\nimport paraselene.*;\nimport paraselene.supervisor.*;\nimport paraselene.ajax.*;\nimport paraselene.tag.*;\nimport paraselene.tag.form.*;\nimport paraselene.dyna.*;\n\n/**\n * AJAX の Form通信。\n */\npublic class FormJson extends #1.SuperPage {\n	private static final long serialVersionUID = 1L;\n	private boolean opera_f = false;\n	private Tag	script = new Tag( \"script\", false );\n\n	/**\n	 * コンストラクタ。\n	 */\n	public FormJson() {\n		super();\n		init();\n		script.setAttribute( new Attribute( \"type\", \"text/javascript\" ) );\n	}\n\n	/**\n	 * 初期化。\n	 */\n	public void init(){\n		clear();\n		try {\n			Tag	html = new Tag( \"html\", false );\n			Tag	head = new Tag( \"head\", false );\n			head.addHTMLPart( script );\n			Tag	body = new Tag( \"body\", false );\n			body.addHTMLPart( new Tag( \"iframe\", false ) );\n			html.addHTMLPart( head, body );\n			setMainTag( html );\n			setDoctype( false, null );\n			super.init();\n			setInitialized( true );\n		}\n		catch( Exception e ) {\n			Option.debug( e );\n		}\n	}\n\n	/**\n	 * ページIDの取得。\n	 * @return ページID。\n	 */\n	public PageID getID() {\n		return PageType.PARASELENE_FORM_JSON;\n	}\n\n	/**\n	 * 別名URI設定。nullを返すと別名は設定しません。\n	 * @return URI。\n	 */\n	public String getAliasURI() {\n		return null;\n	}\n\n	/**\n	 * ブラウザに403を返す。\n	 * @param req リクエスト内容。\n	 * @param fw デフォルト遷移先。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {\n		return new Forward( 403 );\n	}\n\n	public boolean isHistoryClear() { return false; }\n	public boolean isAllowHistoryAdd() { return false; }\n	public String getCharset() { return \"UTF-8\"; }\n\n	/**\n	 * キャッシュ禁止指定。\n	 * @return true:ブラウザキャッシュを禁止します。\n	 */\n	public boolean isNoCache() { return true; }\n\n	/**\n	 * 初回outputの呼び出しメイン処理。\n	 * @param req リクエスト内容。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public void firstOutputMain( RequestParameter req ) throws PageException {\n	}\n\n	/**\n	 * 出力情報の設定を行う。\n	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。\n	 * @param req リクエスト内容。\n	 * @return 出力ページ。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public Page outputMain( Page from, RequestParameter req ) throws PageException {\n		String[]	ua = req.getHeader( \"User-Agent\" );\n		boolean	opera_f = false;\n		if ( ua != null ) {\n			opera_f = ua[0].indexOf( \"Opera\" ) != -1;\n		}\n\n		StringBuilder	buf = new StringBuilder();\n		if ( opera_f ) {\n			buf = buf.append( \"parent.paraselene.form_ok('\" );\n			buf = buf.append( from.getUniqueKey() );\n			buf = buf.append( \"');\" );\n		}\n		else {\n			HttpSession	session = req.getSession();\n			JSON	data = Ajax.get( session, from.getUniqueKey() );\n			buf = buf.append( \"if(parent.paraselene.called_form){\" );\n			buf = buf.append( \"parent.paraselene.form_reset();\" );\n			buf = buf.append( \"parent.paraselene.called_form=undefined;\" );\n			buf = buf.append( \"parent.paraselene.action(\" );\n			buf = buf.append( data.toString() );\n			buf = buf.append( \");}else{history.forward();}\" );\n		}\n		script.removeHTMLPart();\n		script.addHTMLPart( new paraselene.ajax.data.JavaScript( buf.toString() ) );\n		return this;\n	}\n	public NameDefine[] inspectName( Page page, String ... exclude ){ return null;}\n}\n\n";}
}
