/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import paraselene.supervisor.History;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.Supervisor;

public class RequestParameter {
    private HashMap<String, RequestItem> item_map = new HashMap();
    private Method method;
    private URI uri = null;
    private HttpSession session = null;
    private Cookie[] in_cookie;
    private String remote_addr;
    private HashMap<String, String[]> header = new HashMap();
    private Supervisor supervisor = null;
    static final String UA_HEAD = "User-Agent";

    public static Mobile judgMobile(String ua) {
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.indexOf("DoCoMo") != -1) {
            return Mobile.DOCOMO;
        }
        if (ua.indexOf("KDDI") != -1) {
            return Mobile.AU;
        }
        if (ua.indexOf("SoftBank") != -1 || ua.indexOf("Vodafone") != -1 || ua.indexOf("J-PHONE") != -1) {
            return Mobile.J_PHONE;
        }
        if (ua.indexOf("UP.Browser") != -1) {
            return Mobile.TU_KA;
        }
        return Mobile.NO_MOBILE;
    }

    public Mobile judgMobile() {
        String[] ua = this.getHeader(UA_HEAD);
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.length < 1) {
            return Mobile.NO_MOBILE;
        }
        return RequestParameter.judgMobile(ua[0]);
    }

    protected void setMethod(Method m) {
        this.method = m;
    }

    protected void setSession(HttpSession s) {
        this.session = s;
    }

    protected void setCookie(Cookie[] c) {
        this.in_cookie = c;
    }

    protected void setRemoteAddr(String ip) {
        this.remote_addr = ip;
    }

    protected void setURI(URI u) {
        this.uri = u;
    }

    protected void setSupervisor(Supervisor sv) {
        this.supervisor = sv;
    }

    public void setHeader(String name, String[] val) {
        this.header.put(name.toLowerCase(Locale.ENGLISH), val);
    }

    void setParam(Method m, HttpServletRequest request, Supervisor sv) {
        this.setSupervisor(sv);
        this.setMethod(m);
        this.setSession(request.getSession(false));
        this.setCookie(request.getCookies());
        this.setRemoteAddr(request.getRemoteAddr());
        try {
            StringBuffer buf = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                buf = buf.append("?");
                buf = buf.append(query);
            }
            this.setURI(new URI(buf.toString()));
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration em = request.getHeaderNames();
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            ArrayList<String> data = new ArrayList<String>();
            Enumeration e2 = request.getHeaders(key);
            while (e2.hasMoreElements()) {
                data.add((String)e2.nextElement());
            }
            this.setHeader(key, data.toArray(new String[0]));
        }
    }

    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    public String[] getHeader(String name) {
        return this.header.get(name.toLowerCase(Locale.ENGLISH));
    }

    public HeaderQuality[] getHeaderWithQuality(String name) {
        String[] org = this.getHeader(name);
        if (org == null) {
            return null;
        }
        ArrayList<HeaderQuality> head = new ArrayList<HeaderQuality>();
        for (int i = 0; i < org.length; ++i) {
            String[] data = org[i].split(",");
            for (int j = 0; j < data.length; ++j) {
                try {
                    head.add(new HeaderQuality(data[j]));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return head.toArray(new HeaderQuality[0]);
    }

    public String getRemoteAddr() {
        return this.remote_addr;
    }

    public URI getURI() {
        return this.uri;
    }

    public Cookie[] getCookie() {
        return this.in_cookie;
    }

    private void setRequestItem(String k, String v, File fb, String mime, boolean f) {
        RequestItem item = this.item_map.get(k);
        if (item == null) {
            item = new RequestItem(k);
            this.item_map.put(k, item);
        }
        item.value.add(v);
        item.file.add(fb);
        item.mime.add(mime);
        item.file_flg.add(f);
    }

    public void addItem(String k, String v, File f, String type) {
        this.setRequestItem(k, v, f, type, true);
    }

    public void addItem(String k, String v) {
        this.setRequestItem(k, v, null, null, false);
    }

    public void remove(String k) {
        this.item_map.remove(k);
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession makeNewSession() {
        if (this.supervisor != null) {
            this.session = this.supervisor.makeNewSession(this.session);
        }
        return this.session;
    }

    public History getHistory() {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        SessionData data = (SessionData)session.getAttribute("paraselene$data");
        return data.hist;
    }

    public RequestItem getItem(String key) {
        return this.item_map.get(key);
    }

    public String[] getAllKey() {
        int cnt = this.item_map.size();
        String[] ret = new String[cnt];
        int i = 0;
        Iterator<String> i$ = this.item_map.keySet().iterator();
        while (i$.hasNext()) {
            String k;
            ret[i] = k = i$.next();
            ++i;
        }
        return ret;
    }

    public boolean isExistRequestItem() {
        return this.item_map.size() > 0;
    }

    public class HeaderQuality {
        String val;
        Float q = null;

        HeaderQuality(String org) throws NumberFormatException {
            String[] k;
            String[] data = org.split(";");
            this.val = data[0].trim();
            if (data.length > 1 && (k = data[1].split("="))[0].trim().equals("q") && k.length > 1) {
                this.q = new Float(data[1]);
            }
        }

        public String getValue() {
            return this.val;
        }

        public Float getQuality() {
            return this.q;
        }
    }

    public static enum Mobile {
        DOCOMO,
        AU,
        TU_KA,
        J_PHONE,
        NO_MOBILE;

        private static final long serialVersionUID = 1L;
    }

    public static enum Method {
        GET,
        POST;

        private static final long serialVersionUID = 1L;
    }
}

