/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax;

import java.io.*;
import java.util.*;
import javax.servlet.http.*;

import paraselene.supervisor.*;


class AjaxHolder {
	private long	time = new Date().getTime();
	Serializable	obj;
	AjaxHolder( Serializable o ) {
		obj = o;
	}
	boolean isLife() {
		long	tm = new Date().getTime() - 1000 * 60 * 5;
		return	time > tm;
	}
}

class AjaxMonitor extends Thread {
	private HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> map;
	AjaxMonitor( HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> m ) {
		map = m;
		setDaemon( true );
		setPriority( MIN_PRIORITY );
		start();
	}
	public void run() {
		while( true ) {
			try {
				Thread.sleep( 1000 * 60 );
				synchronized( map ) {
					for ( String k : map.keySet() ) {
						HashMap<String, LinkedList<AjaxHolder>>	map2 = map.get( k );
						for ( String k2 : map2.keySet() ) {
							LinkedList<AjaxHolder>	list = map2.get( k2 );
							if ( list == null )	continue;
							while( true ) {
								AjaxHolder	h = list.peek();
								if ( h == null )	break;
								if ( h.isLife() )	break;
								list.poll();
							}
						}
					}
				}
			}
			catch( Exception e ) {
				e.printStackTrace();
			}
		}
	}
}

/**
 * 非同期通信用データのキューイング。
 * 任意のpublicクラス(Serializableを実装したもの)をクライアントサイドのjavascriptに
 * JSONとして送る事ができます。詳しくは{@link JSON}を参照して下さい。<br>
 * クライアントから非同期通信が発生すると、蓄積されたキューの内容全てが
 * 送信されます。<br>
 * キューに登録後、5分間のうちに取得されなかったものは削除されます。
 */
public class Ajax implements Serializable, HttpSessionBindingListener {
	private static final long serialVersionUID = 1L;
	private static final String KEY = "paraselene$ajax";
	private static HashMap<String, HashMap<String, LinkedList<AjaxHolder>>>	map =
		new HashMap<String, HashMap<String,LinkedList<AjaxHolder>>>();
	private static AjaxMonitor	monitor = new AjaxMonitor( map );
	private static HashMap<String, Object>	comet_wait = new HashMap<String, Object>();

	/**
	 * COMET登録。
	 * @param key 取得キー。
	 */
	public static void entryComet( String key ) {
		if ( !COMET.equals( key ) )	return;
		RequestParameter	req = SandBox.getCurrentRequestParameter();
		if ( req == null )	return;
		HttpSession	session = req.getSession();
		if ( session == null )	return;
		get_comet_waiter( session.getId() );
	}

	/**
	 * フレームワークが使用します。
	 */
	public static void removeComet( String id ) {
		synchronized( comet_wait ) {
			comet_wait.remove( id );
		}
	}

	private static Object get_comet_waiter( String id ) {
		synchronized( comet_wait ) {
			Object	obj = comet_wait.get( id );
			if ( obj == null ) {
				obj = new Ajax();
				comet_wait.put( id, obj );
			}
			return obj;
		}
	}

	/**
	 * 非同期通信用。
	 */
	public Serializable[]	data;
	private Ajax() {}
	private Ajax( LinkedList<AjaxHolder> obj ) {
		ArrayList<Serializable>	list = new ArrayList<Serializable>();
		while ( true ) {
			AjaxHolder	h = obj.poll();
			if ( h == null )	break;
			list.add( h.obj );
		}
		data = list.toArray( new Serializable[0] );
	}
	public void valueBound( HttpSessionBindingEvent ev ) {}
	public void valueUnbound( HttpSessionBindingEvent ev ) {
		String	id = ev.getSession().getId();
		synchronized( map ) {
			map.remove( id );
		}
	}

	/**
	 * 非同期通信蓄積情報の取得。
	 * @return 非同期通信蓄積情報。
	 */
	public static AjaxInformation[] getInformation() {
		synchronized( map ) {
			return AjaxInformation.getInformation( map );
		}
	}

	private static LinkedList<AjaxHolder> getQueue( HttpSession session, String key ) {
		String	id = session.getId();
		HashMap<String, LinkedList<AjaxHolder>>	obj = map.get( id );
		LinkedList<AjaxHolder>	que = null;
		if ( obj == null ) {
			session.removeAttribute( KEY );
			obj = new HashMap<String, LinkedList<AjaxHolder>>();
			map.put( id, obj );
			session.setAttribute( KEY, new Ajax() );
		}
		else {
			que = obj.get( key );
		}
		if ( que == null ) {
			que = new LinkedList<AjaxHolder>();
			obj.put( key, que );
		}
		return que;
	}

	private static LinkedList<AjaxHolder> getQueue( String id, String key ) {
		HashMap<String, LinkedList<AjaxHolder>>	obj = map.get( id );
		if ( obj == null )	return null;
		LinkedList<AjaxHolder>	que = obj.get( key );
		if ( que == null ) {
			que = new LinkedList<AjaxHolder>();
			obj.put( key, que );
		}
		return que;
	}

	/**
	 * 非同期通信応答キュー追加。
	 * このセッションに指定キーのキューを追加します。
	 * @param session セッション。
	 * @param key 登録キー。
	 * @param o キューに追加するオブジェクト。nullならキューの準備だけ行います。
	 */
	public static void add( HttpSession session, String key, Serializable ... o ) {
		if ( session == null )	return;
		synchronized( map ) {
			LinkedList<AjaxHolder>	que = getQueue( session, key );
			for ( int  i = 0; i < o.length; i++ ){
				que.offer( new AjaxHolder( o[i] ) );
			}
		}
	}

	/**
	 * 非同期通信応答キュー追加。
	 * このセッションに指定キーのキューを追加します。
	 * 事前に第一引数が HttpSession の add を呼び出しておく必要があります。
	 * @param session セッションID。
	 * @param key 登録キー。
	 * @param o キューに追加するオブジェクト。
	 */
	public static void add( String session, String key, Serializable ... o ) {
		if ( session == null )	return;
		synchronized( map ) {
			LinkedList<AjaxHolder>	que = getQueue( session, key );
			for ( int  i = 0; i < o.length; i++ ){
				que.offer( new AjaxHolder( o[i] ) );
			}
		}
	}

	public static final String	COMET = "paraselene_comet";

	/**
	 * 非同期通信応答キュー追加。
	 * このセッションに指定キーのキューを追加します。
	 * 事前に第一引数が HttpSession の add を呼び出しておく必要があります。
	 * @param session セッションID。
	 * @param o キューに追加するオブジェクト。
	 */
	public static void addComet( String session, Serializable ... o ) {
		Object	obj = get_comet_waiter( session );
		synchronized( obj ) {
			add( session, COMET, o );
			try {
				obj.notifyAll();
			}
			catch( Exception e ){}
		}
	}

	/**
	 * 非同期通信応答キュー取得。
	 * このセッションから指定キーのキューを取得します。
	 * 取得されるとキューは削除されます。
	 * @param session セッション。
	 * @param key 登録キー。
	 * @return 応答キュー。
	 */
	public static JSON get( HttpSession session, String key ) {
		if ( session == null )	return null;
		boolean	comet_f = COMET.equals( key );
		LinkedList<AjaxHolder>	que = null;
		synchronized( map ) {
			que = getQueue( session, key );
			if ( comet_f ) {
				if ( que.size() > 0 )	comet_f = false;
			}
			if ( !comet_f ) {
				return new JSON( new Ajax( que ) );
			}
		}
		JSON	ret = null;
		if ( comet_f ) {
			Object	obj = get_comet_waiter( session.getId() );
			synchronized( obj ) {
				try {
					obj.notifyAll();
					obj.wait( 1000 * 60 * 3 );
				}
				catch( Exception e ) {
					return new JSON( new Ajax( new LinkedList<AjaxHolder>() ) );
				}
			}
		}
		synchronized( map ) {
			ret = new JSON( new Ajax( que ) );
		}
		return ret;
	}

	/**
	 * 非同期通信応答キューの削除。
	 * 指定キーのキューを削除します。
	 * @param session セッション。
	 * @param key 登録キー。
	 */
	public static void remove( HttpSession session, String key ) {
		if ( session == null )	return;
		synchronized( map ) {
			getQueue( session, key ).clear();
		}
	}
}

