/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import paraselene.Page;
import paraselene.Text;
import paraselene.Version;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.DynamicPageException;
import paraselene.dyna.NameDefine;
import paraselene.mockup.Download;
import paraselene.mockup.FunctionInfo;
import paraselene.mockup.JavaDefine;
import paraselene.mockup.Linker;
import paraselene.mockup.Make;
import paraselene.mockup.Output;
import paraselene.mockup.OutputNo;
import paraselene.mockup.Param;
import paraselene.mockup.SourceHead;
import paraselene.mockup.TableSource;
import paraselene.mockup.TagException;
import paraselene.mockup.TagMap;
import paraselene.mockup.TagSource;
import paraselene.mockup.TextSource;
import paraselene.mockup.output.source.logic.logic;
import paraselene.mockup.output.source.view.readme;
import paraselene.mockup.output.source.view.view;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.tag.Attribute;
import paraselene.tag.Tag;

public class PrePage
extends DynamicPage
implements OutputNo {
    private ArrayList<TableSource> table = new ArrayList();
    static String[] out_dir = new String[]{"view", "logic"};
    private HashMap<String, Integer> method = new HashMap();
    private HashMap<String, NameDefine> define = new HashMap();
    private static final String TAG_ARRAY = "Tag[]";
    private static HashMap<Integer, PrePage> hash_map = new HashMap();
    private int id = 0;
    private String path = "";
    private String package_name;
    private String java_path;
    private String class_name;
    private String enum_name;
    private long html_last_time = 0L;
    private HashMap<String, String> name_class = new HashMap();
    private HashMap<String, ArrayList<String>> group_name = new HashMap();
    private ArrayList<String> note = new ArrayList();
    private ArrayList<String> imple = new ArrayList();
    private static final String NULL_TITLE = "(\u30bf\u30a4\u30c8\u30eb\u306a\u3057)";
    private static final String SKIP_TITLE = "(\u89e3\u6790skip) ";
    private static HashMap<String, String> name_check = new HashMap();

    static void setDir(String v, String l) {
        PrePage.out_dir[0] = v;
        PrePage.out_dir[1] = l;
    }

    private String toName(String name) {
        char[] ch = name.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        for (int i = 1; i < ch.length; ++i) {
            ch[i] = Character.toLowerCase(ch[i]);
        }
        return new String(ch);
    }

    private FunctionInfo makeFunctionInfo(String cls, String tag, String name) {
        StringBuilder buf = new StringBuilder("get");
        String[] part = name.split("[\\p{Punct}\\p{Space}]+");
        for (int i = 0; i < part.length; ++i) {
            buf = part[i].length() == 0 ? buf.append("_") : buf.append(this.toName(part[i]));
        }
        name = (buf = buf.append(this.toName(tag))).toString();
        Integer cnt = this.method.get(name);
        if (cnt == null) {
            this.method.put(name, 1);
        } else {
            Integer n = cnt;
            Integer n2 = cnt = Integer.valueOf(cnt + 1);
            buf = buf.append(cnt);
            this.addNote("\u8b66\u544a: " + name + " \u306b\u985e\u4f3c\u3059\u308b\u30e1\u30bd\u30c3\u30c9\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002");
        }
        return new FunctionInfo(cls, buf.toString());
    }

    private StringBuilder toName(FunctionInfo info) {
        StringBuilder buf = new StringBuilder(" ");
        buf = buf.append(info.func_name);
        return buf.append("() {\n");
    }

    static StringBuilder getCom(String name, String note, TagSource t) {
        StringBuilder buf = new StringBuilder("/**\n");
        buf = buf.append(" * ");
        buf = buf.append(name);
        if (note != null) {
            buf = buf.append(note);
        }
        buf = buf.append(".");
        if (t != null) {
            buf = buf.append("\n");
            buf = buf.append(" * <br>");
            buf = buf.append(t.getTagString());
        }
        return buf.append("\n **/\npublic ");
    }

    private StringBuilder getMethod(String name, Tag t) throws TagException {
        StringBuilder buf = PrePage.getCom(name, null, (TagSource)t);
        String cls = TagMap.getClassString(t);
        try {
            this.define.put(name, new NameDefine(name, TagMap.getClass(t)));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        buf = buf.append(cls);
        FunctionInfo info = this.makeFunctionInfo(cls, t.getName(), name);
        buf = buf.append((CharSequence)this.toName(info));
        buf = buf.append("return (");
        buf = buf.append(cls);
        buf = buf.append(")getTag( \"");
        buf = buf.append(name);
        buf = buf.append("\" );\n}\n");
        int cnt = this.table.size();
        for (int i = 0; i < cnt; ++i) {
            TableSource tb = this.table.get(i);
            boolean f = this.getAllTag(tb.getAttributeToString("name")).length == 1;
            buf = buf.append(tb.getOneAccesser(info, name, f));
        }
        return buf;
    }

    private StringBuilder getMethod(String name) throws TagException {
        if (this.define.get(name) == null) {
            this.define.put(name, new NameDefine(name));
        }
        Tag[] t = this.getAllTag(name);
        ArrayList<Tag> left_tag = new ArrayList<Tag>();
        for (int i = 0; i < t.length; ++i) {
            if (Param.isIgnoreTagAccesser(t[i])) continue;
            left_tag.add(t[i]);
        }
        StringBuilder buf = new StringBuilder();
        if (left_tag.size() == 0) {
            return buf;
        }
        t = left_tag.toArray(new Tag[0]);
        if (t.length == 1) {
            buf = buf.append((CharSequence)this.getMethod(name, t[0]));
        } else {
            this.addNote("name=" + name + "\u306e\u30bf\u30b0\u306f\u914d\u5217\u5316\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        buf = buf.append((CharSequence)PrePage.getCom(name, null, null));
        buf = buf.append(TAG_ARRAY);
        FunctionInfo info = this.makeFunctionInfo(TAG_ARRAY, "Tags", name);
        buf = buf.append((CharSequence)this.toName(info));
        buf = buf.append("return getAllTag( \"");
        buf = buf.append(name);
        return buf.append("\" );\n}\n");
    }

    @Override
    public String getString(int no) {
        switch (no) {
            case 1: {
                return Param.PACKAGE.get();
            }
            case 2: {
                return this.package_name;
            }
            case 3: {
                return this.path;
            }
            case 4: {
                return this.class_name;
            }
            case 5: {
                TagSource tag = (TagSource)this.getMainTag();
                StringBuilder buf = new StringBuilder(tag.toSource());
                buf = buf.append("setMainTag(");
                buf = buf.append(tag.getValName());
                buf = buf.append(");\n");
                buf = buf.append("setDoctype(");
                buf = buf.append(Boolean.toString(this.isXML()));
                buf = buf.append(",");
                buf = buf.append(Make.escape(this.getDoctype()));
                buf = buf.append(");\n");
                buf = buf.append("addVersionMeta(");
                buf = buf.append(Make.escape(Version.getTitle()));
                buf = buf.append(",");
                buf = buf.append(Make.escape(new Date().toString()));
                buf = buf.append(");\n");
                return buf.toString();
            }
            case 6: {
                return this.getEnumName(true);
            }
            case 7: {
                StringBuilder buf = new StringBuilder();
                int cnt = this.table.size();
                for (int i = 0; i < cnt; ++i) {
                    TableSource tb = this.table.get(i);
                    boolean f = this.getAllTag(tb.getAttributeToString("name")).length == 1;
                    buf = buf.append(tb.getEnum(f));
                }
                String[] name = this.getDefineNameIndex();
                for (int i = 0; i < name.length; ++i) {
                    try {
                        buf = buf.append((CharSequence)this.getMethod(name[i]));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                buf = buf.append("/**\n * name \u5c5e\u6027\u306e\u691c\u8a3c\u3002\n * @param page \u691c\u8a3c\u3059\u308b\u30da\u30fc\u30b8\n * @param exclude \u691c\u8a3c\u304b\u3089\u9664\u5916\u3059\u308b name\u3002\n * @return \u30a8\u30e9\u30fc\u3068\u306a\u3063\u305f name\u3002\n */\n");
                buf = buf.append("public NameDefine[] inspectName(Page page,String ... exclude){\nreturn DynamicPage.inspectName(page,new NameDefine[]{\n");
                String sep = "";
                for (String key : this.define.keySet()) {
                    buf = buf.append(sep);
                    NameDefine def = this.define.get(key);
                    buf = buf.append("new NameDefine(");
                    buf = buf.append(Make.escape(def.getName()));
                    Class<?> cls = def.getDefineClass();
                    if (cls != null) {
                        buf = buf.append(",");
                        buf = buf.append(cls.getName());
                        buf = buf.append(".class");
                    }
                    buf = buf.append(")");
                    sep = ",\n";
                }
                buf = buf.append("},exclude);\n}\n");
                return buf.toString();
            }
            case 10: {
                int cnt = this.imple.size();
                if (cnt == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder("implements ");
                buf = buf.append(this.imple.get(0));
                for (int i = 1; i < cnt; ++i) {
                    buf = buf.append(",");
                    buf = buf.append(this.imple.get(i));
                }
                return buf.toString();
            }
            case 33: {
                return Param.PACKAGE_BASE.get();
            }
            case 34: {
                return Param.PACKAGE_VIEW.get();
            }
            case 35: {
                return Param.PACKAGE_LOGIC.get();
            }
        }
        return null;
    }

    String getClassName() {
        StringBuilder buf = new StringBuilder(Param.PACKAGE.get());
        buf = buf.append(".");
        buf = buf.append(out_dir[1]);
        if (this.package_name.length() > 0) {
            buf = buf.append(this.package_name);
        }
        buf = buf.append(".");
        buf = buf.append(this.class_name);
        return buf.toString();
    }

    String getEnumName(boolean only_f) {
        if (only_f) {
            return this.enum_name;
        }
        StringBuilder buf = new StringBuilder(Param.PACKAGE.get());
        buf = buf.append(".base.PageType.");
        buf = buf.append(this.enum_name);
        return buf.toString();
    }

    void makeSourceMain(int dir, Output output) throws Exception {
        Linker.readme.setCurrentPage(this);
        StringBuilder out_path = new StringBuilder(Make.SRC_PATH);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(out_dir[dir]);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(this.java_path);
        String name = out_path.toString();
        File file = new File(name);
        Linker.readme.echoln(name + " output starts.");
        if (dir == 1 && file.exists()) {
            Linker.readme.echoln(name + " was not output, because it already existed.");
            return;
        }
        Output.Status stat = output.write(file, this, this.html_last_time);
        switch (stat) {
            case OK: {
                Linker.readme.echoln(name + " output ended.");
                break;
            }
            case SKIP: {
                Linker.readme.echoln(name + " is not modified.");
            }
        }
    }

    void makeSource() throws Exception {
        Output[] output = new Output[]{new view(), new logic()};
        for (int i = 0; i < 2; ++i) {
            this.makeSourceMain(i, output[i]);
        }
    }

    void addNote(String n) {
        this.note.add(n);
    }

    String getNote() {
        StringBuilder buf = new StringBuilder();
        int cnt = this.note.size();
        for (int i = 0; i < cnt; ++i) {
            buf = buf.append(this.note.get(i));
            if (i == cnt - 1) continue;
            buf = buf.append("\n");
        }
        return buf.toString();
    }

    String getTitle() {
        Tag[] tag = this.getAllTagByType("title");
        if (tag == null) {
            return SKIP_TITLE;
        }
        if (tag.length == 0) {
            return NULL_TITLE;
        }
        String str = tag[0].getValueString();
        if (str == null) {
            return NULL_TITLE;
        }
        if (str.length() == 0) {
            return NULL_TITLE;
        }
        return str;
    }

    @Override
    public void init() {
        PrePage page;
        int i;
        this.path = this.path.substring(Param.HTML_ROOT.get().length());
        if (this.path.charAt(0) == File.separatorChar) {
            this.path = this.path.substring(1);
        }
        String[] check = this.path.split("[/\\\\]");
        for (int i2 = 0; i2 < check.length; ++i2) {
            boolean ret = i2 == check.length - 1 ? JavaDefine.isDefine(check[i2], false) : JavaDefine.isDefine(check[i2], true);
            if (!ret) continue;
            System.err.println("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u307e\u305f\u306f\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u4f7f\u7528\u3067\u304d\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
            System.err.println(this.path);
            System.exit(1);
        }
        File tmp = new File(this.path);
        this.java_path = tmp.getParent();
        if (this.java_path == null) {
            this.package_name = "";
            this.java_path = "";
        } else {
            char[] ch = this.java_path.toCharArray();
            for (i = 0; i < ch.length; ++i) {
                if (ch[i] == '.') {
                    ch[i] = 95;
                }
                if (ch[i] != File.separatorChar) continue;
                ch[i] = 46;
            }
            this.package_name = "." + new String(ch);
        }
        char[] ch = this.java_path.toCharArray();
        for (i = 0; i < ch.length; ++i) {
            ch[i] = ch[i] == File.separatorChar ? 95 : Character.toUpperCase(ch[i]);
        }
        this.enum_name = ch.length > 0 ? new String(ch) + "_" : "";
        this.class_name = PrePage.name2CamelCase(tmp.getName());
        StringBuilder buf = new StringBuilder(this.enum_name);
        this.enum_name = tmp.getName().toUpperCase();
        String[] part = this.enum_name.split("[\\p{Punct}\\p{Space}]+");
        for (int i3 = 0; i3 < part.length; ++i3) {
            if (i3 > 0) {
                buf = buf.append("_");
            }
            buf = buf.append(part[i3]);
        }
        this.enum_name = buf.toString();
        this.java_path = this.java_path + File.separatorChar + this.class_name + ".java";
        String cf = name_check.get(this.java_path);
        if (cf != null) {
            System.err.println("\u4f3c\u305f\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u751f\u6210\u3059\u308b\u30af\u30e9\u30b9\u540d\u304c\u885d\u7a81\u3057\u307e\u3059");
            System.err.println(cf);
            System.err.println(this.path);
            System.exit(1);
        }
        name_check.put(this.java_path, this.path);
        this.id = (Param.PACKAGE.get() + this.path).hashCode();
        if (this.id < 0) {
            this.id *= -1;
        }
        while ((page = hash_map.get(this.id)) != null) {
            ++this.id;
            if (this.id >= 10) continue;
            this.id = 10;
        }
        hash_map.put(this.id, this);
    }

    static String name2CamelCase(String str) {
        String name = str.trim().toLowerCase(Locale.ENGLISH);
        String[] part = name.split("[\\p{Punct}\\p{Space}]+");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < part.length; ++i) {
            char[] ch = part[i].toCharArray();
            ch[0] = Character.toUpperCase(ch[0]);
            buf = buf.append(new String(ch));
        }
        return buf.toString();
    }

    @Override
    protected DynamicPage makePage() {
        return new PrePage(this);
    }

    private PrePage(Page p) {
        super(null, p, Param.provider);
    }

    PrePage(File p) throws FileNotFoundException, UnsupportedEncodingException, IOException, DynamicPageException {
        this(p, false);
    }

    PrePage(File p, boolean dev_f) throws FileNotFoundException, UnsupportedEncodingException, IOException, DynamicPageException {
        super(null, Param.provider);
        Tag frameset;
        this.path = p.getPath();
        this.html_last_time = p.lastModified();
        if (!dev_f) {
            this.init();
        }
        if (this instanceof Download) {
            return;
        }
        StringBuilder out_path = new StringBuilder(Make.SRC_PATH);
        out_path = out_path.append(File.separator);
        out_path = out_path.append(out_dir[0]);
        out_path = out_path.append(File.separator);
        if (new File((out_path = out_path.append(this.java_path)).toString()).lastModified() > this.html_last_time) {
            return;
        }
        Linker.readme.setCurrentPage(this);
        this.create(p, Param.IN_ENCODE.get());
        if (!this.isXML() && this.getParsingCharset() == null) {
            this.addNote("\u8b66\u544a: \u89e3\u6790\u6642\u306bHTML\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6c7a\u5b9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
        if ((frameset = this.getFirstTagByType("frameset")) != null) {
            this.imple.add("FramesetPage");
            this.addNote("FramesetPage \u3092\u5b9f\u88c5\u3057\u307e\u3057\u305f\u3002");
        }
    }

    @Override
    public PageID getID() {
        return new PrePageID(this.id);
    }

    protected URI getMyselfURI() {
        try {
            return new URI(Output.toHtmlPath(this.path));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getContentType() {
        return "text/html; charset=" + this.getCharset();
    }

    @Override
    public String getCharset() {
        return Param.OUT_ENCODE.get();
    }

    public static void main(String[] argc) throws Exception {
        File inp = new File(argc[0]);
        SourceHead.init(new File(argc[2]));
        PrePage pp = new PrePage(inp, true);
        readme readme2 = new readme();
        readme2.write(new File(argc[1]), pp, Long.MAX_VALUE);
    }

    @Override
    protected Tag makeTag(String name, ArrayList<Attribute> attr) throws Exception {
        TagSource nt = null;
        if (name.equalsIgnoreCase("table")) {
            nt = new TableSource();
            this.table.add((TableSource)nt);
        } else {
            nt = new TagSource(name, PrePage.isSimpleTag(name));
        }
        int cnt = attr.size();
        for (int i = 0; i < cnt; ++i) {
            nt.setAttribute(attr.get(i));
        }
        return nt;
    }

    @Override
    public void clear() {
        super.clear();
        this.table.clear();
    }

    @Override
    protected Text makeText(String str) {
        return new TextSource(str);
    }

    @Override
    public boolean isRuntime() {
        return false;
    }

    class PrePageID
    implements PageID {
        private int id = 0;

        PrePageID(int p) {
            this.id = p;
        }

        @Override
        public boolean isSame(Page p) {
            return p.getID().getID() == this.id;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public PageFactory getPageFactory() {
            return null;
        }

        @Override
        public PageID getPageID(int hash) {
            return null;
        }
    }
}

