/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;

/**
 * コントロール値検証エラー。
 */
public class ControlException extends Exception {
	private static final long serialVersionUID = 2L;
	private Control[] err = null;

	/**
	 * コンストラクタ。
	 * @param mes メッセージ。
	 * @param cont 複数のエラーコントロール。
	 */
	public ControlException( String mes, Control ... cont ) {
		super( mes );
		err = cont;
	}

	/**
	 * コンストラクタ。
	 * @param mes メッセージ。
	 */
	public ControlException( String mes ) {
		super( mes );
	}

	/**
	 * エラーコントロールの取得。最初にエラー検出したコントロールを返します。
	 * 他にもエラー検出したコントロールが存在する可能性があります。
	 * @return エラーが発生したコントロール。
	 */
	public Control getControl() {
		if ( err == null )	return null;
		if ( err.length == 0 )	return null;
		return err[0];
	}

	/**
	 * エラーコントロールの取得。エラー検出した、全てのコントロールを返します。
	 * @return 全てのエラーが発生したコントロール。
	 */
	public Control[] getControls() {
		return err;
	}
}

