/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ajax.data;

import java.io.Serializable;
import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.ajax.data.JsonWriter;
import paraselene.supervisor.SandBox;
import paraselene.tag.Tag;
import paraselene.ui.PageHooker;

public class TagData
implements Serializable {
    private static final long serialVersionUID = 2L;
    public String id = "";
    public String body = "";
    public String[] cmd = null;
    public boolean over_f = false;

    TagData() {
    }

    TagData(Tag tag) {
        this(tag, true);
    }

    TagData(Tag tag, boolean flag) {
        this.id = tag.getAttributeToString("id");
        Page page = tag.getAssignedPage();
        if (flag) {
            if (SandBox.isCurrentDaemon()) {
                PageHooker[] hook = tag.getInnerHTMLPart(page.getPageHooker());
                for (int i = 0; i < hook.length; ++i) {
                    hook[i].commitDaemon();
                }
            }
            int cnt = tag.getHTMLPartCount();
            JsonWriter w = new JsonWriter();
            for (int i = 0; i < cnt; ++i) {
                tag.getHTMLPart(i).write(w, HTMLPart.StringMode.BODY);
            }
            this.body = w.toString();
            this.cmd = new String[]{page.getOnLoadScript()};
            page.resetOnLoadScript();
            tag.resetModify();
        }
    }

    public static TagData[] getTag(Page org, Page out) {
        ArrayList<TagData> list = new ArrayList<TagData>();
        if (org == out) {
            Tag[] tag = out.getModifiedTag();
            for (int i = 0; i < tag.length; ++i) {
                list.add(new TagData(tag[i]));
            }
            int cnt = list.size();
            if (cnt > 1) {
                ((TagData)list.get((int)(cnt - 1))).cmd = ((TagData)list.get((int)0)).cmd;
                ((TagData)list.get((int)0)).cmd = null;
            }
        } else {
            TagData td = new TagData(out.getFirstTagByType("body"));
            td.id = org.getRootID();
            list.add(td);
        }
        return list.toArray(new TagData[0]);
    }
}

