/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import paraselene.supervisor.History;
import paraselene.supervisor.Option;

public class HistorySet
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final int ROOT = 0;
    static final int RAND = Integer.MAX_VALUE;
    private HashMap<String, Integer> set_no = new HashMap();
    private HashMap<Integer, History> hist = new HashMap();
    private String session_id;

    HistorySet(String sid) {
        this.session_id = sid;
        this.newNo(0);
    }

    synchronized int getKey(String name) {
        Integer key = this.set_no.get(name);
        if (key == null) {
            return -1;
        }
        return key;
    }

    public synchronized History get(int key) {
        return this.hist.get(key);
    }

    public synchronized int[] getAllKey() {
        int[] ret = new int[this.hist.size()];
        int i = 0;
        Iterator<Integer> i$ = this.hist.keySet().iterator();
        while (i$.hasNext()) {
            int k;
            ret[i] = k = i$.next().intValue();
            ++i;
        }
        return ret;
    }

    public synchronized void dropHistory(int key) {
        if (key == 0) {
            return;
        }
        for (String k : this.set_no.keySet()) {
            if (this.set_no.get(k) != key) continue;
            this.set_no.remove(k);
            break;
        }
        this.remove(key);
    }

    public synchronized void dropHistory() {
        int[] key = this.getAllKey();
        for (int i = 0; i < key.length; ++i) {
            this.dropHistory(key[i]);
        }
    }

    private synchronized void remove(int key) {
        if (this.set_no.containsValue(new Integer(key))) {
            return;
        }
        History h = this.hist.remove(key);
        if (h != null) {
            h.drop_f = true;
            h.removePage();
        }
    }

    synchronized void drop() {
        this.set_no.clear();
        boolean flag = true;
        while (flag) {
            flag = false;
            Iterator<Integer> i$ = this.hist.keySet().iterator();
            if (!i$.hasNext()) continue;
            int key = i$.next();
            this.remove(key);
            flag = true;
        }
        Option.trace("history all drop", new Object[0]);
    }

    private synchronized int newNo(int no) {
        if (no < 0) {
            no *= -1;
        }
        while (no == Integer.MAX_VALUE || this.hist.get(no) != null) {
            if (++no >= 0) continue;
            no = 1;
        }
        this.hist.put(no, new History(no, this.session_id));
        Option.trace("issue history key %d", no);
        return no;
    }

    int toInt() {
        return this.newNo((int)new Date().getTime() & Integer.MAX_VALUE);
    }

    synchronized void forceNewNo(int no) {
        if (this.hist.get(no) != null) {
            return;
        }
        this.newNo(no);
    }

    synchronized int toInt(String name, int org) {
        if (name == null) {
            return org;
        }
        if (name.isEmpty()) {
            return org;
        }
        if ("_self".equals(name)) {
            return org;
        }
        if ("_top".equals(name)) {
            return 0;
        }
        if ("_blank".equals(name) || "_parent".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if (name.indexOf("paraselene") >= 0) {
            return org;
        }
        Integer ret = this.set_no.get(name);
        if (ret != null) {
            return ret;
        }
        int n = this.newNo(name.hashCode());
        this.set_no.put(name, n);
        return n;
    }
}

