/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import paraselene.Page;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.Closure;
import paraselene.supervisor.CometCall;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.History;
import paraselene.supervisor.LocationCometCall;
import paraselene.supervisor.LocationOutput;
import paraselene.supervisor.NOP;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Popup;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.Supervisor;

public class Forward
implements Serializable {
    private static final long serialVersionUID = 212L;
    private int error = 0;
    private transient URI redirect_uri = null;
    PageID out_page = null;
    private AjaxForward[] ajax = null;
    private AjaxForward not_ajax = null;
    boolean history_f = true;
    boolean session_clear_f = false;
    transient ArrayList<Cookie> out_cookie = new ArrayList();
    boolean done_f = false;

    boolean isLeave() {
        return this.error > 0 || this.redirect_uri != null;
    }

    public void addCookie(Cookie c) {
        this.out_cookie.add(c);
    }

    Forward() {
    }

    public Forward(int stat) {
        this.error = stat;
        this.session_clear_f = true;
    }

    public Forward(URI uri, boolean session_off) {
        this.redirect_uri = uri;
        this.session_clear_f = session_off;
    }

    public Forward(PageID id, boolean history_use, boolean session_off) {
        if (!(this instanceof Closure) && !(this instanceof Feedback)) {
            id = id.getPageFactory().getAjaxSurrogatePage(id);
        }
        this.out_page = id;
        this.history_f = history_use;
        this.session_clear_f = session_off;
    }

    public Forward(PageID id) {
        this(id, true, false);
    }

    public Forward(AjaxForward ... af) {
        if (af.length == 0) {
            af = new AjaxForward[]{new NOP()};
        }
        this.ajax = af;
        if (SandBox.isCurrentDaemon()) {
            return;
        }
        this.initTrim(SandBox.getCurrentRequestParameter().getHistory());
    }

    void initTrim(History hist) {
        if (this.ajax == null) {
            return;
        }
        this.ajax = this.trim(this.ajax, hist, true);
        this.not_ajax = this.getNotAjax();
    }

    Forward(History hist, AjaxForward ... af) {
        this.ajax = this.trim(af, hist, false);
        this.not_ajax = this.getNotAjax();
    }

    AjaxForward[] getAjaxForward(boolean ajax_f) {
        if (ajax_f) {
            return this.ajax;
        }
        if (this.not_ajax == null) {
            return null;
        }
        return new AjaxForward[]{this.not_ajax};
    }

    private AjaxForward[] trim(AjaxForward[] af, History hist, boolean fb_ok) {
        int i;
        if (af.length < 1) {
            return af;
        }
        if (hist == null) {
            return null;
        }
        Page[] page = hist.getBrowsingPage();
        Popup.Type ptype = Popup.Type.MODELESS;
        if (Popup.isModelessAlert(ptype, hist, false)) {
            ptype = Popup.Type.MODAL;
        }
        ArrayList<AjaxForward> list = new ArrayList<AjaxForward>();
        block0: for (i = 0; i < af.length - 1; ++i) {
            if (af[i] == null) continue;
            for (int j = i + 1; j < af.length; ++j) {
                if (!((Object)af[i]).equals(af[j])) continue;
                af[j] = null;
            }
            if (af[i] instanceof Popup) {
                Popup pup = (Popup)af[i];
                pup.overwriteType(ptype);
                ptype = pup.getType();
            }
            if (!(af[i] instanceof Feedback)) continue;
            if (!fb_ok) {
                af[i] = null;
                continue;
            }
            Feedback fb = (Feedback)af[i];
            for (int j = 0; j < af.length; ++j) {
                if (!(af[j] instanceof Closure) || !fb.isSamePage((Closure)af[j])) continue;
                af[i] = null;
                continue block0;
            }
        }
        for (i = 0; i < af.length; ++i) {
            if (af[i] == null) continue;
            list.add(af[i]);
        }
        af = list.toArray(new AjaxForward[0]);
        return af;
    }

    private AjaxForward getNotAjax() {
        Feedback fb;
        if (this.ajax == null) {
            return null;
        }
        AjaxForward ret = fb = new Feedback();
        for (int i = 0; i < this.ajax.length; ++i) {
            if (this.ajax[i] instanceof Popup) {
                return this.ajax[i];
            }
            if (!(this.ajax[i] instanceof Closure) || !fb.isSamePage((Closure)this.ajax[i])) continue;
            ret = this.ajax[i];
        }
        return ret;
    }

    Page getPage(Page from) {
        if (this.out_page == null) {
            Option.trace("Forward#getPage -> null", new Object[0]);
            return null;
        }
        if (from != null && this.out_page == from.getID()) {
            Option.trace("Forward#getPage -> %s", from.getUniqueKey());
            return from;
        }
        Page p = this.out_page.getPageFactory().getPage(this.out_page.getID());
        Option.trace("Forward#getPage -> %s", p.getUniqueKey());
        return p;
    }

    public PageID getPageID() {
        return this.out_page;
    }

    public URI getRedirectURI() {
        return this.redirect_uri;
    }

    public int getStatus() {
        return this.error;
    }

    void Action(Supervisor sp, HttpServletResponse res) throws Exception {
        if (this.done_f) {
            return;
        }
        this.done_f = true;
        if (this.error != 0) {
            if (this.error == 403) {
                Option.traceWithStack("403 Forward", new Object[0]);
            }
            res.sendError(this.error);
            return;
        }
        if (this.redirect_uri != null) {
            res.sendRedirect(Supervisor.makeWithSessionURI(this.redirect_uri.toString(), null, null));
            return;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Forward ");
        if (this.error != 0) {
            buf = buf.append("status: ").append(Integer.toString(this.error));
        } else if (this.redirect_uri != null) {
            buf = buf.append("redirect: ").append(this.redirect_uri.toString());
        } else if (this.ajax != null) {
            buf = buf.append(" << |");
            for (int i = 0; i < this.ajax.length; ++i) {
                buf = buf.append(this.ajax[i].toString());
                buf = buf.append("|");
            }
        } else {
            buf = buf.append("page: ").append(this.getPageID().toString());
        }
        return buf.toString();
    }

    OutputCall makeOutput(int nk, Page lp, RequestParameter r, SessionData sd) {
        Option.trace("new LocationOutput <- %s", this);
        return new LocationOutput(nk, lp, this, r, sd);
    }

    CometCall makeCometCall(History h) {
        Option.trace("new LocationCometCall <- %s", this);
        return new LocationCometCall(h, this);
    }
}

