/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.Cookie;
import paraselene.HTMLPart;
import paraselene.NumberValue;
import paraselene.Page;
import paraselene.Text;
import paraselene.URIValue;
import paraselene.Valuable;
import paraselene.ajax.data.JavaScript;
import paraselene.supervisor.Forward;
import paraselene.supervisor.NullPage;
import paraselene.supervisor.Option;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Anchor;
import paraselene.tag.Attribute;
import paraselene.tag.AttributeValuable;
import paraselene.tag.VirtualTag;
import paraselene.tag.form.Control;
import paraselene.tag.form.Form;

public class Tag
extends HTMLPart {
    static final Page null_page = new NullPage(){

        @Override
        public Forward input(RequestParameter req, Forward fw) throws Page.PageException {
            return null;
        }
    };
    private static HashMap<String, String> name_ok_map = new HashMap();
    private String name;
    protected HashMap<String, Attribute> attr = new HashMap();
    private ArrayList<HTMLPart> doc = new ArrayList();
    private ArrayList<Tag> tag_only = new ArrayList();
    private boolean nest_f = false;
    private boolean visible_f = true;
    private volatile boolean dirty_f = true;
    private short[] location_no = new short[]{0};
    private static String VALUE;
    private Page embed_page = null_page;
    private boolean ajax_f = true;
    private boolean modify_enable = true;
    private static final String[] plain_tag;
    private static HashMap<String, String> plain_map;
    private static volatile short tag_id;
    private static final String PARASELENE_ID = "paraselene$id$";
    private static final BigInteger BI13;

    public void setAjaxEnable(boolean flag) {
        this.ajax_f = flag;
    }

    public boolean isAjaxEnable() {
        return this.ajax_f;
    }

    public Page getAssignedPage() {
        if (this.embed_page == null) {
            return null_page;
        }
        return this.embed_page;
    }

    private void set_modify() {
        Tag out;
        if (this.getAttribute("id") == null && (out = this.getOuterTag()) != null) {
            out.set_modify();
            return;
        }
        this.dirty_f = true;
    }

    public void setModify() {
        if (!this.modify_enable) {
            return;
        }
        Tag out = this.getOuterTag();
        if (out != null) {
            out.set_modify();
            return;
        }
        this.set_modify();
    }

    public void resetModify() {
        this.dirty_f = false;
    }

    public void setModifyEnable(boolean flag) {
        this.modify_enable = flag;
    }

    void getModifiedTag(ArrayList<Tag> list) {
        if (this.dirty_f) {
            list.add(this);
            return;
        }
        Tag[] tag = this.getTagArray();
        for (int i = 0; i < tag.length; ++i) {
            tag[i].getModifiedTag(list);
        }
    }

    public Tag[] getModifiedTag() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        this.getModifiedTag(list);
        return list.toArray(new Tag[0]);
    }

    public Tag getOuterTag() {
        return this.getAssignedTag();
    }

    private Tag[] getOverUnder() {
        Tag[] ret = new Tag[]{null, null};
        int cnt = this.getAssignedTag().tag_only.size();
        for (int i = 0; i < cnt; ++i) {
            if (this.getAssignedTag().tag_only.get(i) != this) continue;
            if (i > 0) {
                ret[0] = this.getAssignedTag().tag_only.get(i - 1);
            }
            if (i >= cnt - 1) break;
            ret[1] = this.getAssignedTag().tag_only.get(i + 1);
            break;
        }
        return ret;
    }

    public Tag getOverTag() {
        return this.getOverUnder()[0];
    }

    public Tag getUnderTag() {
        return this.getOverUnder()[1];
    }

    protected Tag() {
    }

    public static boolean isPlainTag(String name) {
        return plain_map.get(name.toLowerCase(Locale.ENGLISH)) != null;
    }

    public boolean isSimpleTag() {
        return !this.nest_f;
    }

    public boolean isVisible() {
        return this.visible_f;
    }

    public void setVisible(boolean flag) {
        this.setModify();
        this.visible_f = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeID() {
        Attribute id = this.getAttribute("id");
        if (id != null) {
            return id.getString();
        }
        if ("head".equals(this.getName())) {
            return null;
        }
        long now = 0L;
        String string = PARASELENE_ID;
        synchronized (PARASELENE_ID) {
            now = tag_id;
            tag_id = (short)(tag_id + 1);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            long time = now << 56 ^ new Date().getTime() & 0xFFFFFFFFFFFFFFL;
            StringBuilder buf = new StringBuilder(PARASELENE_ID);
            buf = buf.append(Long.toString(time &= Long.MAX_VALUE, 36));
            String nid = buf.toString();
            this.setAttribute(new Attribute("id", nid));
            return nid;
        }
    }

    public String getIDAttribute() {
        Attribute attr = this.getAttribute("id");
        if (attr == null) {
            return null;
        }
        return attr.getString();
    }

    public Tag(String n, boolean simple_f) {
        this();
        this.name = n.toLowerCase(Locale.ENGLISH);
        if ("body".equals(this.name)) {
            this.makeID();
        }
        this.nest_f = !simple_f;
    }

    public String getNameAttribute() {
        try {
            Attribute n = this.getAttribute("name");
            if (n == null) {
                return null;
            }
            AttributeValuable t = n.get();
            if (t == null) {
                return null;
            }
            return t.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Attribute[] getAllAttribute() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (String k : this.attr.keySet()) {
            list.add(this.attr.get(k));
        }
        return list.toArray(new Attribute[0]);
    }

    @Override
    public HTMLPart getReplica() {
        Tag tag = this.newReplica();
        tag.visible_f = this.visible_f;
        for (String k : this.attr.keySet()) {
            if ("id".equals(k)) continue;
            tag.setAttribute(this.attr.get(k).getReplica());
        }
        int size = this.doc.size();
        for (int i = 0; i < size; ++i) {
            tag.addHTMLPart(this.doc.get(i).getReplica());
        }
        return tag;
    }

    protected Tag newReplica() {
        return new Tag(this.name, !this.nest_f);
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(Attribute at) {
        Tag out;
        String val;
        this.setModify();
        String at_name = at.getName();
        if ("id".equals(at_name) && this.getAttribute("id") != null && (val = at.getString()) != null && val.indexOf(PARASELENE_ID) == 0) {
            return;
        }
        this.attr.put(at.getName(), at);
        at.setAssignedTag(this);
        if ("name".equals(at_name) && (out = this.getOuterTag()) != null) {
            out.makeID();
        }
    }

    public void setAttribute(Attribute ... at) {
        for (int i = 0; i < at.length; ++i) {
            this.setAttribute(at[i]);
        }
    }

    public void setAttribute(String n) {
        this.setAttribute(new Attribute(n));
    }

    public void setAttribute(String n, BigDecimal v) {
        this.setAttribute(new Attribute(n, v));
    }

    public void setAttribute(String n, double v) {
        this.setAttribute(new Attribute(n, v));
    }

    public void setAttribute(String n, int v) {
        this.setAttribute(new Attribute(n, v));
    }

    public void setAttribute(String n, String v) {
        this.setAttribute(new Attribute(n, v));
    }

    public void setAttribute(String n, Valuable ... v) {
        this.setAttribute(new Attribute(n, v));
    }

    public void removeAttribute(String at_name) {
        this.setModify();
        this.attr.remove(at_name.toLowerCase(Locale.ENGLISH));
    }

    public Attribute getAttribute(String at_name) {
        return this.attr.get(at_name.toLowerCase(Locale.ENGLISH));
    }

    public String getAttributeToString(String at_name) {
        Attribute attr = this.getAttribute(at_name);
        if (attr == null) {
            return null;
        }
        return attr.getString();
    }

    public Integer getAttributeToInteger(String at_name) {
        NumberValue num = this.getAttributeToNumberValue(at_name);
        if (num == null) {
            return null;
        }
        return num.toInteger();
    }

    public Double getAttributeToDouble(String at_name) {
        NumberValue num = this.getAttributeToNumberValue(at_name);
        if (num == null) {
            return null;
        }
        return num.toDouble();
    }

    public BigDecimal getAttributeToBigDecimal(String at_name) {
        NumberValue num = this.getAttributeToNumberValue(at_name);
        if (num == null) {
            return null;
        }
        return num.toBigDecimal();
    }

    private NumberValue getAttributeToNumberValue(String at_name) {
        Attribute attr = this.getAttribute(at_name);
        if (attr == null) {
            return null;
        }
        AttributeValuable av = attr.get();
        if (!(av instanceof NumberValue)) {
            return null;
        }
        return (NumberValue)av;
    }

    public URI getAttributeToURI(String at_name) {
        Attribute attr = this.getAttribute(at_name);
        if (attr == null) {
            return null;
        }
        AttributeValuable av = attr.get();
        if (!(av instanceof URIValue)) {
            return null;
        }
        URIValue u = (URIValue)av;
        return u.getURI();
    }

    public void addHTMLPart(HTMLPart d) {
        this.addHTMLPart(this.doc.size(), d);
    }

    public static Tag[] sort(Tag[] array) {
        if (array == null) {
            return null;
        }
        if (array.length <= 1) {
            return array;
        }
        int h = Tag.sortDiv(array.length);
        while (true) {
            if (h == 9 || h == 10) {
                h = 11;
            }
            boolean done = false;
            int i = 0;
            while (i + h < array.length) {
                boolean swap_f = false;
                if (array[i + h].location_no.length < array[i].location_no.length) {
                    swap_f = true;
                } else if (array[i + h].location_no.length == array[i].location_no.length) {
                    for (int j = 0; j < array[i].location_no.length; ++j) {
                        if (array[i + h].location_no[j] < array[i].location_no[j]) {
                            swap_f = true;
                            break;
                        }
                        if (array[i + h].location_no[j] > array[i].location_no[j]) break;
                    }
                }
                if (swap_f) {
                    Tag tmp = array[i + h];
                    array[i + h] = array[i];
                    array[i] = tmp;
                    done = true;
                }
                ++i;
            }
            if (h <= 1 && !done) {
                return array;
            }
            h = Tag.sortDiv(h);
        }
    }

    private static int sortDiv(int org) {
        BigInteger bd = new BigInteger(Integer.toString(org));
        bd = bd.multiply(BigInteger.TEN);
        int ret = (bd = bd.divide(BI13)).intValue();
        if (ret < 1) {
            ret = 1;
        }
        return ret;
    }

    private void setLocation() {
        Tag[] list = this.getTagArray();
        short last_no = -1;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].location_no.length == this.location_no.length + 1) {
                boolean flag = true;
                for (int j = 0; j < this.location_no.length; ++j) {
                    if (list[i].location_no[j] == this.location_no[j]) continue;
                    flag = false;
                    break;
                }
                if (flag && list[i].location_no[this.location_no.length] > last_no) {
                    last_no = list[i].location_no[this.location_no.length];
                    continue;
                }
            }
            list[i].location_no = new short[this.location_no.length + 1];
            for (int j = 0; j < this.location_no.length; ++j) {
                list[i].location_no[j] = this.location_no[j];
            }
            if ((last_no = (short)(last_no + 1)) < 0) {
                Option.debug("tag overflow!", new Object[0]);
                last_no = 0;
            }
            list[i].location_no[this.location_no.length] = last_no;
            list[i].setLocation();
        }
    }

    public void addHTMLPart(int idx, HTMLPart d) {
        if (this instanceof VirtualTag || d instanceof VirtualTag) {
            return;
        }
        this.setModify();
        this.doc.add(idx, d);
        if (d instanceof Tag) {
            HTMLPart p;
            Tag tag = (Tag)d;
            int cnt = this.doc.size();
            idx = 0;
            for (int i = 0; i < cnt && (p = this.doc.get(i)) != d; ++i) {
                if (!(p instanceof Tag)) continue;
                ++idx;
            }
            this.tag_only.add(idx, tag);
            this.getAssignedPage().nameTag(tag);
            if (tag.getAttribute("name") != null) {
                this.makeID();
            }
            this.setLocation();
        }
        d.setAssignedTag(this);
    }

    public void addHTMLPart(HTMLPart ... d) {
        for (int i = 0; i < d.length; ++i) {
            this.addHTMLPart(d[i]);
        }
    }

    public void addHTMLPart(int idx, HTMLPart ... d) {
        for (int i = 0; i < d.length; ++i) {
            this.addHTMLPart(idx + i, d[i]);
        }
    }

    public void include(Tag tag) {
        if (tag == null) {
            return;
        }
        int cnt = tag.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            this.addHTMLPart(tag.getHTMLPart(i).getReplica());
        }
    }

    public void include(Tag tag, boolean move_f) {
        int i;
        if (!move_f) {
            this.include(tag);
            return;
        }
        if (tag == null) {
            return;
        }
        int cnt = tag.getHTMLPartCount();
        HTMLPart[] data = new HTMLPart[cnt];
        for (i = 0; i < cnt; ++i) {
            data[i] = tag.getHTMLPart(i);
        }
        tag.removeHTMLPart();
        for (i = 0; i < cnt; ++i) {
            this.addHTMLPart(data[i]);
        }
    }

    public void include(Page page) {
        this.include(page, false);
    }

    public void include(Page page, boolean move_f) {
        if (page == null) {
            return;
        }
        this.include(page.getFirstTagByType("body"), move_f);
    }

    public HTMLPart getHTMLPart(int idx) {
        return this.doc.get(idx);
    }

    public int getHTMLPartCount() {
        return this.doc.size();
    }

    public void removeHTMLPart(int idx) {
        HTMLPart p = this.doc.remove(idx);
        if (p == null) {
            return;
        }
        this.removeHTMLPart(p);
    }

    public void removeHTMLPart(HTMLPart part) {
        if (part == null) {
            return;
        }
        this.setModify();
        if (part instanceof Tag) {
            Tag tag = (Tag)part;
            this.tag_only.remove(tag);
            this.getAssignedPage().removeNameEntry(tag);
        }
        part.setAssignedTag(null);
        this.doc.remove(part);
    }

    public void removeHTMLPart() {
        int cnt = this.doc.size();
        --cnt;
        while (cnt >= 0) {
            this.removeHTMLPart(cnt);
            --cnt;
        }
    }

    public void exclude(Tag tag) {
        int idx = this.indexOf(tag);
        this.removeHTMLPart(tag);
        int cnt = tag.getHTMLPartCount();
        for (int i = cnt - 1; i >= 0; --i) {
            this.addHTMLPart(idx, tag.getHTMLPart(i));
        }
    }

    public int indexOf(HTMLPart part) {
        if (part == null) {
            return -1;
        }
        return this.doc.indexOf(part);
    }

    protected String getFirstTag() {
        boolean xml = false;
        xml = this.getAssignedPage().isXML();
        StringBuilder buf = new StringBuilder("<");
        boolean name_f = this instanceof Anchor || this instanceof Form || this instanceof Control;
        String myname = this.getName();
        if (!name_f) {
            name_f = name_ok_map.get(myname) != null;
        }
        buf = buf.append(myname);
        for (String k : this.attr.keySet()) {
            if ("name".equals(k) && !name_f) continue;
            buf = buf.append(" ");
            buf = buf.append(this.attr.get(k).toHtmlString(xml));
        }
        if (xml && this.isSimpleTag()) {
            buf = buf.append(" /");
        }
        buf = buf.append(">");
        return buf.toString();
    }

    protected String getLastTag() {
        StringBuilder buf = new StringBuilder("</");
        buf = buf.append(this.name);
        buf = buf.append(">");
        return buf.toString();
    }

    public static HTMLPart.StringMode selectMode(String tag_name) {
        tag_name = tag_name.toLowerCase(Locale.ENGLISH);
        HTMLPart.StringMode mode = HTMLPart.StringMode.BODY;
        if ("textarea".equals(tag_name) || "pre".equals(tag_name)) {
            mode = HTMLPart.StringMode.TEXTAREA;
        } else if (Tag.isPlainTag(tag_name)) {
            mode = HTMLPart.StringMode.PLAIN;
        }
        return mode;
    }

    private HTMLPart.StringMode selectMode() {
        return Tag.selectMode(this.name);
    }

    private String getHTMLParts(HTMLPart.StringMode mode) {
        int cnt = this.getHTMLPartCount();
        StringBuilder buf = new StringBuilder();
        if (mode != HTMLPart.StringMode.TEXTAREA) {
            mode = this.selectMode();
        }
        for (int i = 0; i < cnt; ++i) {
            buf = buf.append(this.getHTMLPart(i).toString(mode));
        }
        return buf.toString();
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        if (!this.visible_f) {
            return "";
        }
        StringBuilder buf = new StringBuilder("\n");
        buf = buf.append(this.getFirstTag());
        buf = buf.append(this.getHTMLParts(mode));
        if (this.nest_f) {
            buf = buf.append(this.getLastTag());
        }
        return buf.toString();
    }

    @Override
    public void write(PrintWriter w, HTMLPart.StringMode mode) {
        this.dirty_f = false;
        if (!this.visible_f) {
            return;
        }
        w.print("\r\n");
        w.print(this.getFirstTag());
        int cnt = this.getHTMLPartCount();
        if (mode != HTMLPart.StringMode.TEXTAREA) {
            mode = this.selectMode();
        }
        for (int i = 0; i < cnt; ++i) {
            this.getHTMLPart(i).write(w, mode);
        }
        if (this.nest_f) {
            w.print(this.getLastTag());
        }
    }

    protected String getValueAttribute() {
        Attribute attr = this.getAttribute(VALUE);
        if (attr == null) {
            return null;
        }
        AttributeValuable text = attr.get();
        if (text == null) {
            return null;
        }
        return text.toString(HTMLPart.StringMode.PLAIN);
    }

    public String getValueString() {
        if (this.nest_f) {
            int cnt = this.getHTMLPartCount();
            for (int i = 0; i < cnt; ++i) {
                HTMLPart pt = this.getHTMLPart(i);
                if (!(pt instanceof Text)) continue;
                return ((Text)pt).toString(HTMLPart.StringMode.PLAIN);
            }
            return null;
        }
        return this.getValueAttribute();
    }

    protected void setValueAttribute(String v) {
        Attribute attr = this.getAttribute(VALUE);
        if (attr == null) {
            try {
                this.setAttribute(new Attribute(VALUE, v));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        attr.set(v);
    }

    public void setValueString(String v) {
        if (this.nest_f) {
            int cnt = this.getHTMLPartCount();
            for (int i = 0; i < cnt; ++i) {
                HTMLPart pt = this.getHTMLPart(i);
                if (!(pt instanceof Text)) continue;
                ((Text)pt).setText(v, HTMLPart.StringMode.PLAIN);
                return;
            }
            this.addHTMLPart((HTMLPart)new Text(v));
            return;
        }
        this.setValueAttribute(v);
    }

    public boolean isEmptyValue() {
        String str = this.getValueString();
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public Tag[] getTagArray() {
        return this.tag_only.toArray(new Tag[0]);
    }

    public Tag[] getAllTagByClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList<Tag> list = new ArrayList<Tag>();
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            Tag[] sub = crt[i].getAllTagByClass(cls);
            for (int j = 0; j < sub.length; ++j) {
                list.add(sub[j]);
            }
            if (!cls.isAssignableFrom(crt[i].getClass())) continue;
            list.add(crt[i]);
        }
        return Tag.sort(list.toArray(new Tag[0]));
    }

    public Tag[] getAllTagByType(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        ArrayList<Tag> list = new ArrayList<Tag>();
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            Tag[] sub = crt[i].getAllTagByType(name);
            for (int j = 0; j < sub.length; ++j) {
                list.add(sub[j]);
            }
            if (!name.equals(crt[i].getName())) continue;
            list.add(crt[i]);
        }
        return Tag.sort(list.toArray(new Tag[0]));
    }

    public Tag getFirstTagByType(String name) {
        if (name == null) {
            return null;
        }
        name = name.toLowerCase(Locale.ENGLISH);
        Tag[] crt = this.getTagArray();
        for (int i = 0; i < crt.length; ++i) {
            if (name.equals(crt[i].getName())) {
                return crt[i];
            }
            Tag sub = crt[i].getFirstTagByType(name);
            if (sub == null) continue;
            return sub;
        }
        return null;
    }

    public boolean isInner(HTMLPart target) {
        return this.getDirectInnerTag(target) != null;
    }

    public Tag getDirectInnerTag(HTMLPart target) {
        if (this == target) {
            return null;
        }
        if (target instanceof Tag) {
            return ((Tag)target).getOuterTag();
        }
        int cnt = this.doc.size();
        for (int i = 0; i < cnt; ++i) {
            Tag tag;
            HTMLPart part = this.doc.get(i);
            if (part == target) {
                return this;
            }
            if (!(part instanceof Tag) || (tag = ((Tag)part).getDirectInnerTag(target)) == null) continue;
            return tag;
        }
        return null;
    }

    public boolean isContain(Tag[] tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 0; i < tag.length; ++i) {
            if (this != tag[i]) continue;
            return true;
        }
        return false;
    }

    protected Text makeText(String str) {
        return new Text(str);
    }

    public void replaceBR() {
        HTMLPart p;
        int i;
        int cnt = this.getHTMLPartCount();
        for (i = 0; i < cnt; ++i) {
            Tag tag;
            p = this.getHTMLPart(i);
            if (!(p instanceof Tag) || !"br".equals((tag = (Tag)p).getName()) || tag.getAllAttribute().length > 0) continue;
            this.removeHTMLPart(i);
            this.addHTMLPart(i, (HTMLPart)this.makeText("\n"));
        }
        for (i = cnt - 1; i > 0; --i) {
            HTMLPart p2;
            p = this.getHTMLPart(i);
            if (!(p instanceof Text) || !((p2 = this.getHTMLPart(i - 1)) instanceof Text)) continue;
            Text next = (Text)p;
            Text pre = (Text)p2;
            pre.append(next);
            this.removeHTMLPart(i);
        }
    }

    public void setAssignedPage(Page p) {
        if (p == null) {
            p = null_page;
        }
        this.embed_page = p;
    }

    private ArrayList<HTMLPart> getInnerHTMLPart(ArrayList<HTMLPart> list, ArrayList<HTMLPart> d) {
        int tgt_cnt = d.size();
        if (tgt_cnt == 0) {
            return list;
        }
        int cnt = this.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            HTMLPart data = this.getHTMLPart(i);
            for (int j = tgt_cnt; j >= 0; --j) {
                if (data != d.get(j)) continue;
                list.add(data);
                d.remove(data);
                if (--tgt_cnt != 0) continue;
                return list;
            }
            if (!(data instanceof Tag)) continue;
            Tag tag = (Tag)data;
            list = tag.getInnerHTMLPart(list, d);
        }
        return list;
    }

    public HTMLPart[] getInnerHTMLPart(HTMLPart[] d) {
        if (d == null) {
            return new HTMLPart[0];
        }
        ArrayList<HTMLPart> list = new ArrayList<HTMLPart>();
        ArrayList<HTMLPart> tgt = new ArrayList<HTMLPart>();
        for (int i = 0; i < d.length; ++i) {
            tgt.add(d[i]);
        }
        return this.getInnerHTMLPart(list, tgt).toArray(new HTMLPart[0]);
    }

    public HTMLPart getFirstInnerHTMLPart(HTMLPart[] d) {
        if (d == null) {
            return null;
        }
        if (d.length == 0) {
            return null;
        }
        int cnt = this.getHTMLPartCount();
        for (int i = 0; i < cnt; ++i) {
            Tag tag;
            HTMLPart ret;
            HTMLPart data = this.getHTMLPart(i);
            for (int j = 0; j < d.length; ++j) {
                if (data != d[j]) continue;
                return data;
            }
            if (!(data instanceof Tag) || (ret = (tag = (Tag)data).getFirstInnerHTMLPart(d)) == null) continue;
            return ret;
        }
        return null;
    }

    public void setEventHandler(String triger, String function) {
        Page page = this.getAssignedPage();
        String id = this.makeID();
        StringBuilder buf = new StringBuilder();
        buf = buf.append("paraselene_safe_add_event('");
        buf = buf.append(id);
        buf = buf.append("','");
        buf = buf.append(triger);
        buf = buf.append("',");
        buf = buf.append(function);
        buf = buf.append(");");
        page.addOnLoadScript(buf.toString());
    }

    public void setAnonymousEventHandler(String triger, String ... function) {
        Page page = this.getAssignedPage();
        String id = this.makeID();
        StringBuilder script = new StringBuilder();
        for (int i = 0; i < function.length; ++i) {
            if (i > 0) {
                script = script.append("\r\n");
            }
            script = script.append(function[i]);
        }
        String ano = script.toString();
        StringBuilder buf = new StringBuilder("paraselene_handler_");
        buf = buf.append(id);
        int hc = ano.hashCode();
        if (hc < 0) {
            hc *= -1;
        }
        buf = buf.append(Integer.toString(hc, 36));
        ano = buf.toString();
        buf = new StringBuilder("var ");
        buf = buf.append(ano);
        buf = buf.append("=");
        buf = buf.append((CharSequence)script);
        buf = buf.append(";");
        page.addOnLoadScript(buf.toString());
        this.setEventHandler(triger, ano);
    }

    public String[] getClassAttribute() {
        Attribute cls = this.getAttribute("class");
        if (cls == null) {
            return new String[0];
        }
        String str = cls.getString();
        if (str == null) {
            return new String[0];
        }
        return str.split("\\p{Space}");
    }

    public static Tag makeScript(String ... script) {
        Tag tag = new Tag("script", false){

            @Override
            public void setModify() {
            }
        };
        tag.setAttribute(new Attribute("type", "text/javascript"));
        tag.addHTMLPart((HTMLPart)new JavaScript(script));
        return tag;
    }

    private String makeCookieName() throws IOException {
        String name = this.getNameAttribute();
        if (name == null) {
            throw new IOException("no name attribute.");
        }
        Page page = this.getAssignedPage();
        if (page == null) {
            throw new IOException("no page assigned.");
        }
        String pid = page.getID().toString();
        StringBuilder buf = new StringBuilder("paraselene");
        buf = buf.append("-");
        buf = buf.append(pid);
        buf = buf.append("-");
        buf = buf.append(name);
        return buf.toString();
    }

    private Object getCookieValue(String str) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(new BigInteger(str, 36).toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    private String makeCookieValue(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        return new BigInteger(baos.toByteArray()).toString(36);
    }

    protected Object getCookieValue(RequestParameter req) throws IOException, ClassNotFoundException {
        Cookie c = req.getCookie(this.makeCookieName());
        if (c == null) {
            return null;
        }
        return this.getCookieValue(c.getValue());
    }

    protected Cookie makeCookieValue(RequestParameter req, Object val, int expiry, boolean ssl_f) throws IOException {
        Cookie c = new Cookie(this.makeCookieName(), this.makeCookieValue(val));
        c.setMaxAge(expiry);
        c.setPath(req.getContextPath());
        c.setSecure(ssl_f);
        return c;
    }

    public void importFromCookie(RequestParameter req) {
        if (!this.isEmptyValue()) {
            return;
        }
        try {
            String val = (String)this.getCookieValue(req);
            if (val != null) {
                this.setValueString(val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Forward exportToCookie(RequestParameter req, Forward fw, int expiry, boolean ssl_f) {
        if (this.isEmptyValue()) {
            return fw;
        }
        try {
            fw.addCookie(this.makeCookieValue(req, this.getValueString(), expiry, ssl_f));
        }
        catch (Exception e) {
            // empty catch block
        }
        return fw;
    }

    static {
        String[] name_ok = new String[]{"applet", "area", "embed", "frame", "frameset", "iframe", "ilayer", "img", "layer", "map", "meta", "object", "param"};
        for (int i = 0; i < name_ok.length; ++i) {
            name_ok_map.put(name_ok[i], name_ok[i]);
        }
        VALUE = "value";
        plain_tag = new String[]{"code", "comment", "plaintext", "xmp", "script", "style", "listing"};
        plain_map = new HashMap();
        for (int i = 0; i < plain_tag.length; ++i) {
            plain_map.put(plain_tag[i], plain_tag[i]);
        }
        BI13 = new BigInteger("13");
    }
}

