/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import paraselene.Page;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Null;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.PathData;

public class TransactionSequencer
implements Serializable {
    private static final long serialVersionUID = 2L;
    static final String[] SELENE = new String[]{"lu", "mo", "on", "na", "art", "mis", "dia"};
    public static final String EXTENSION = "." + SELENE[3];
    public static final String[] LINK_DEF = new String[]{"PARASELENE(PAGE)", "PARASELENE(HTTP)", "PARASELENE(HTTPS)"};
    private volatile int seq = 0;
    private HashMap<Integer, Boolean> no_map = new HashMap();
    private static final String[] HEAD = new String[]{"seleno", "lilith"};
    private static final int HEAD_LENGTH = 6;

    TransactionSequencer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int newNo(PageID id) {
        long dt = new Date().getTime() / 1000L & 0x7FFFFFL;
        int ret = (int)(dt << 8);
        TransactionSequencer transactionSequencer = this;
        synchronized (transactionSequencer) {
            this.seq += (int)(Math.random() * 5.0);
            this.no_map.put(ret |= this.seq & 0xFF, false);
        }
        return ret;
    }

    public static String makeURI(TransactionSequencer seq, PageID from, PageID to, int from_key, int to_key, boolean flag) {
        StringBuilder buf = new StringBuilder();
        if (flag && seq != null) {
            buf = buf.append(SELENE[0]);
            buf = buf.append(".");
            buf = buf.append(HEAD[0]);
            buf = buf.append(Integer.toString(seq.newNo(to), 36));
            buf = buf.append(".");
        }
        if (from != null) {
            buf = buf.append(SELENE[1]);
            buf = buf.append(".");
            buf = buf.append(Integer.toString(from.getID(), 36));
            buf = buf.append(".");
            if (flag && from_key != 0) {
                buf = buf.append(SELENE[4]);
                buf = buf.append(".");
                buf = buf.append(Integer.toString(from_key, 36));
                buf = buf.append(".");
            }
        }
        if (flag && to_key != 0) {
            buf = buf.append(SELENE[5]);
            buf = buf.append(".");
            buf = buf.append(Integer.toString(to_key, 36));
            buf = buf.append(".");
        }
        buf = buf.append(SELENE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[3]);
        return buf.toString();
    }

    static String makeRedirectURI(TransactionSequencer seq, PageID to) {
        StringBuilder buf = new StringBuilder();
        buf = buf.append(SELENE[0]);
        buf = buf.append(".");
        buf = buf.append(HEAD[1]);
        buf = buf.append(Integer.toString(seq.newNo(null), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[2]);
        buf = buf.append(".");
        buf = buf.append(Integer.toString(to.getID(), 36));
        buf = buf.append(".");
        buf = buf.append(SELENE[3]);
        return buf.toString();
    }

    private static Page getPage(String no, PageFactory fact) {
        Page ret = null;
        try {
            ret = fact.getPage(Integer.parseInt(no, 36));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            return new Null();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PathData parsePath(TransactionSequencer seq, String uri, PageFactory fact, HistorySet hset) {
        String[] path = uri.split("\\?");
        if (path != null) {
            uri = path[0];
        }
        path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SELENE[3].equals(body[body.length - 1])) continue;
            PathData ret = new PathData();
            int cnt = body.length - 1;
            boolean redirect_f = false;
            boolean request_id = false;
            for (int j = 0; j < cnt; j += 2) {
                if (seq != null && SELENE[0].equals(body[j])) {
                    if (body[j + 1].length() <= 6) {
                        return null;
                    }
                    String head = body[j + 1].substring(0, 6);
                    String number = body[j + 1].substring(6);
                    if (HEAD[1].equals(head)) {
                        redirect_f = true;
                    } else if (!HEAD[0].equals(head)) {
                        return null;
                    }
                    int no = Integer.parseInt(number, 36);
                    TransactionSequencer transactionSequencer = seq;
                    synchronized (transactionSequencer) {
                        Boolean flag = seq.no_map.get(no);
                        if (flag == null) {
                            return null;
                        }
                        request_id = true;
                        ret.called = flag;
                        seq.no_map.put(no, true);
                        continue;
                    }
                }
                if (SELENE[1].equals(body[j])) {
                    ret.from = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                if (SELENE[2].equals(body[j])) {
                    if (redirect_f) {
                        ret.redirect = TransactionSequencer.getPage(body[j + 1], fact);
                        continue;
                    }
                    ret.to = TransactionSequencer.getPage(body[j + 1], fact);
                    continue;
                }
                if (SELENE[4].equals(body[j])) {
                    ret.from_histry = Integer.parseInt(body[j + 1], 36);
                    continue;
                }
                if (!SELENE[5].equals(body[j])) continue;
                ret.to_histry = Integer.parseInt(body[j + 1], 36);
                if (hset == null || ret.to_histry != Integer.MAX_VALUE) continue;
                ret.to_histry = hset.toInt();
            }
            if (ret.from != null) {
                Page out = ret.to;
                if (out == null) {
                    out = ret.redirect;
                }
                if (out != null && seq != null && out.isCheckRepeatSameRequest() && !request_id) {
                    return null;
                }
            }
            return ret;
        }
        return null;
    }

    static boolean isMustSession(String uri) {
        String[] path = uri.split("/");
        for (int i = path.length - 1; i >= 0; --i) {
            String[] body = path[i].split("\\.");
            if (body.length == 0 || !SELENE[3].equals(body[body.length - 1])) continue;
            int cnt = body.length - 1;
            for (int j = 0; j < cnt; j += 2) {
                if (SELENE[0].equals(body[j])) {
                    return true;
                }
                if (!SELENE[1].equals(body[j])) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

