/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.test;


import java.net.*;
import javax.servlet.http.*;
import paraselene.supervisor.*;


/**
 * テスト用リクエスト。
 */
public class TestRequest extends RequestParameter {
	/**
	 * コンストラクタ。
	 * テスト時に参照しない項目はnullを設定して下さい。
	 * @param m メソッド。
	 * @param s セッション。
	 * @param c クッキー。
	 * @param ip リモートIP。
	 * @param u URI。
	 * @param sv サーブレット。
	 */
	public TestRequest( Method m, TestSession s, Cookie[] c, String ip, URI u, Supervisor sv ) {
		super();
		setMethod( m );
		setSession( s );
		setCookie( c );
		setRemoteAddr( ip );
		setURI( u );
		setSupervisor( sv );
	}

}

