/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;
import java.text.*;

/**
 * HTTP 日付フォーマット。
 */
public class HTTPDate implements java.io.Serializable, Comparable<HTTPDate>{
	private static final long serialVersionUID = 1L;
	private Date date;

	/**
	 * コンストラクタ。システム時刻より構築します。
	 */
	public HTTPDate() {
		date = new Date();
	}

	/**
	 * コンストラクタ。指定時刻より構築します。
	 * @param d 指定時刻。
	 */
	public HTTPDate( Date d ) {
		date = d;
	}

	private SimpleDateFormat getFormat() {
		SimpleDateFormat sdf = new SimpleDateFormat( "EEE, dd MMM yyyy HH:mm:ss z",
			DateFormatSymbols.getInstance( Locale.ROOT ) );
		sdf.setTimeZone( TimeZone.getTimeZone( "GMT" ) );
		return sdf;
	}

	/**
	 * コンストラクタ。指定時刻より構築します。
	 * @param s Wed, 09 Feb 1994 22:23:32 GMT のような文字列。
	 */
	public HTTPDate( String s ) throws ParseException {
		date = getFormat().parse( s );
	}

	/**
	 * 文字列化。
	 * @return Wed, 09 Feb 1994 22:23:32 GMT のような文字列。
	 */
	public String toString() {
		return getFormat().format( date );
	}

	/**
	 * 比較。
	 * @param o 比較対象。
	 * @return このオブジェクトが指定されたオブジェクトより小さい場合は負の整数、
	 * 等しい場合はゼロ、大きい場合は正の整数を返します。
	 */
	public int compareTo( HTTPDate o ) {
		long	sub = this.date.getTime() - o.date.getTime();
		if ( sub == 0 )	return 0;
		if ( sub < 0 )	return -1;
		return 1;
	}

	/**
	 * 比較。
	 * @param o 比較対象。
	 * @return true:一致する、false:不一致。
	 */
	public boolean equals( Object o ) {
		if ( o instanceof HTTPDate )	return compareTo( (HTTPDate)o ) == 0;
		return false;
	}

	/**
	 * ハッシュ値。
	 * @return ハッシュ値。
	 */
	public int hashCode() {
		return date.hashCode();
	}
}

