package #1.#x;

import paraselene.*;
import paraselene.supervisor.*;

/**
 * ページ種別。
 */
public enum PageType implements PageID {
#2
private static final long serialVersionUID = 1L;
private static volatile java.util.HashMap<Integer,PageType>	map = new java.util.HashMap<Integer,PageType>();
public static void init() {
try {
Page	page;
paraselene.supervisor.PageFactory	pf = PageLoader.getPageFactory();
#3
pf.start();
} catch( Exception e ) {
Option.debug( e );
}
}

	private int id;
	private PageType( int h ) {
		id = h;
	}
	/**
	 * ハッシュ値を返す。
	 * @return ハッシュ値。
	 */
	public int getID() {
		return id;
	}
	/**
	 * ページの比較。
	 * @param p 比較ページ。
	 * @return true:同一ページ、false:異なるページ。
	 */
	public boolean isSame( paraselene.Page p ) {
		return p.getID() == this;
	}
	/**
	 * ページファクトリーの取得。
	 * @return ページファクトリー。
	 */
	public PageFactory getPageFactory() {
		return PageLoader.getPageFactory();
	}
	/**
	 * ページIDの取得。
	 * @param id ID値。
	 * @return ページID。無ければnull。
	 */
	public PageID getPageID( int id ) {
		return map.get( id );
	}
}

