/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import paraselene.*;
import java.util.*;
import java.net.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;


class DataHolder {
	Supervisor	sv;
	RequestParameter	request;
	HttpServletRequest	req;
	HttpServletResponse	response;
	SessionData	data;
	boolean	session_null = true;
	boolean search_engine = false;

	DataHolder( Supervisor s ) { sv = s; }
}

class RedirectData implements Serializable {
	private static final long serialVersionUID = 2L;
	URI		posted;
	String	uri;
	URI		redirect_path;
	Forward	fw;
	Page[]	out_page;
}

class SessionData implements Serializable, HttpSessionBindingListener {
	private static final long serialVersionUID = 25L;
	TransactionSequencer seq = new TransactionSequencer();
	HistorySet hist = null;
	private HashMap<PageID, RedirectData>	pending = new HashMap<PageID, RedirectData>();
	private volatile int client;

/******* CACHE ******
	private class Waiter implements Serializable {
		private static final long serialVersionUID = 25L;
		volatile boolean flag = true;
	}
	private static final String	DUMMY = paraselene.tag.form.Form.FORM_DUMMY;
	private ArrayList<String>	cache_dummy_key = new ArrayList<String>();
	private ArrayList<CacheAjax>	cache_ajax = new ArrayList<CacheAjax>();
	private HashMap<String, Waiter>	working_ajax = new HashMap<String, Waiter>();
	private static final int CACHE_MAX = 5;

	private String getCacheKey( RequestParameter param ) {
		return param.makeCacheKey();
	}

	void cacheEntry( RequestParameter param, CacheAjax ca ) {
		String	key = getCacheKey( param );
		if ( key == null )	return;
		synchronized( cache_dummy_key ) {
			cache_dummy_key.add( key );
			cache_ajax.add( ca );
			if ( cache_dummy_key.size() > CACHE_MAX ) {
				cache_dummy_key.remove( 0 );
				cache_ajax.remove( 0 );
			}
		}
		cacheUnlock( param );
	}

	void cacheUnlock( RequestParameter param ) {
		if ( param == null )	return;
		String	key = getCacheKey( param );
		if ( key == null )	return;
		Waiter	o = null;
		synchronized( working_ajax ) {
			o = working_ajax.remove( key );
		}
		if ( o == null )	return;
		synchronized( o ) {
			o.flag = false;
			Option.trace( "%s release", key );
			o.notifyAll();
		}
	}

	Forward cacheResponse( RequestParameter param, HttpServletResponse res ) throws IOException {
		String	key = getCacheKey( param );
		if ( key == null )	return null;
		Waiter	o1 = null, o2 = new Waiter();
		synchronized( working_ajax ) {
			o1 = working_ajax.get( key );
			if ( o1 == null ) {
				Option.trace( "%s ajax lock", key );
				working_ajax.put( key, o2 );
			}
		}
		if ( o1 != null ) {
			synchronized( o1 ) {
				if ( o1.flag ) {
					Option.trace( "%s waiting", key );
					while( true ){
						try {
							o1.wait();
							break;
						}
						catch( InterruptedException e ){}
					}
				}
			}
			return cacheResponse( param, res );
		}
		synchronized( cache_dummy_key ) {
			for ( int i = cache_dummy_key.size() - 1; i >= 0; i-- ) {
				String	ck = cache_dummy_key.get( i );
				if ( ck.equals( key ) ) {
					cacheUnlock( param );
					CacheAjax	ca = cache_ajax.get( i );
					ca.writeTo( res );
					Option.trace( "used cache response" );
					return new NullForward();
				}
			}
		}
		return null;
	}
******************************/

	private String cut( String org, int len ) {
		if ( org == null )	return null;
		int	org_len = org.length();
		if ( org_len < len )	len = org_len;
		return org.substring( 0, len );
	}

	private int getClient( HttpServletRequest req ) {
		String[]	data = new String[] {
			cut( req.getHeader( RequestParameter.UA_HEAD ), 80 ),
			req.getRemoteAddr()
		};
		StringBuilder	buf = new StringBuilder();
		for ( int i = 0; i < data.length; i++ ) {
			if ( data[i] == null )	data[i] = "non";
			buf = buf.append( "*" );
			buf = buf.append( data[i] );
		}
		String	str = buf.toString();
		Option.trace( str );
		return str.hashCode();
	}

	SessionData( HttpServletRequest req ) {
		client = getClient( req );
		hist = new HistorySet( req.getSession().getId() );
	}

	boolean isSame( HttpServletRequest req ) {
		if ( client == getClient( req ) )	return true;
		client = 0;
		System.out.println( "unmatched client" );
		return false;
	}

	boolean write( Supervisor sv, Page out, DataHolder holder ) throws Exception {
		PageID	id = out.getID();
		RedirectData	data = null;
		synchronized( pending ) {
			data = pending.get( id );
		}
		id.getPageFactory().returnPage( out );
		if ( data == null ) {
			Option.trace( "redirect pending data null" );
			return false;
		}
		if ( holder.request.getURI().toString().indexOf( data.uri ) < 0 ) {
			Option.trace( "redirect path unmatched pending(%s) call(%s)", data.uri, holder.request.getURI().toString() );
			return false;
		}
		sv.write( data.out_page, false, data.fw, holder );
		return true;
	}

	Forward redirect( Page[] out_ret, Forward fw, RequestParameter req ) throws Exception {
		RedirectData	rd = new RedirectData();
		rd.fw = fw;
		rd.out_page = out_ret;
		rd.posted = req.getURI();
		rd.uri = TransactionSequencer.makeRedirectURI( seq, out_ret[0].getID() );
		String	path = URIValue.makeAbsolutePath(
			URIValue.Scheme.getScheme( rd.posted ), rd.posted.getPort(), rd.uri
		);
		synchronized( pending ) {
			pending.put( out_ret[0].getID(), rd );
		}
		rd.redirect_path = new URI( path );
		return new Forward( rd.redirect_path, false );
	}

	Forward redirect( URI post ) {
		Collection<RedirectData>	list = pending.values();
		for ( RedirectData rd : pending.values() ) {
			if ( rd.posted.equals( post ) ) {
				return new Forward( rd.redirect_path, false );
			}
		}
/*
		int	cnt = list.size();
		for ( int i = 0; i < cnt; i++ ) {
			RedirectData	rd = list.get( i );
			if ( rd.posted.equals( post ) ) {
				return new Forward( rd.redirect_path, false );
			}
		}
*/
		return null;
	}

	public void valueBound( HttpSessionBindingEvent ev ) {}
	public void valueUnbound( HttpSessionBindingEvent ev ) {
		if ( !planed_clear )	hist.drop();
	}
	boolean	planed_clear = false;
}



