/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ui;

import paraselene.*;
import paraselene.tag.*;
import paraselene.supervisor.*;
import java.util.*;
import java.io.*;

/**
 * ページインスタンスに対する入出力バイパスを持つ div タグ。
 * このタグに addHTMLPart してもブラウザへ出力されません。
 */
public class PageBypassedDiv extends Tag implements PageHooker {
	private static final long serialVersionUID = 2L;
	private Page	link_page;
	private Page	view_page;

	/**
	 * コンストラクタ。
	 */
	public PageBypassedDiv() {
		super( "div", false );
	}

	/**
	 * コンストラクタ。
	 * @param history 履歴。
	 * @param page バイパスするページ。
	 */
	public PageBypassedDiv( History history, Page page ) {
		this();
		setBypassPage( history, page );
	}

	/**
	 * バイパス先の設定。
	 * @param history 履歴。
	 * @param page バイパスするページ。
	 */
	public void setBypassPage( History history, Page page ) {
		history.removeSatellitePage( link_page );
		view_page = page;
		link_page = page;
		history.addSatellitePage( page );
	}

	public Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception {
		return fw;
	}

	public void afterOutput( Page from, Page to, RequestParameter req ) throws Exception {
		if ( view_page == null )	return;
		to.addOnLoadScript( view_page.getOnLoadScript() );
		view_page.resetOnLoadScript();
	}

	/**
	 * バイパス先の取得。
	 * @return バイパスしているページ。
	 */
	public Page getBypassPage() {
		return link_page;
	}

	public void write( PrintWriter w, StringMode mode ) {
		if ( !isVisible() )	return;
		w.print( getFirstTag() );
		Tag	body = view_page.getFirstTagByType( "body" );
		if ( body != null ) {
			int	cnt = body.getHTMLPartCount();
			if ( mode != StringMode.TEXTAREA )	mode = StringMode.BODY;
			for ( int i = 0; i < cnt; i++ ) {
				body.getHTMLPart( i ).write( w, mode );
			}
		}
		w.print( getLastTag() );
	}

	void getModifiedTag( ArrayList<Tag> list ) {
		Tag	body = view_page.getFirstTagByType( "body" );
		if ( body != null ) {
			Tag[]	tag = body.getModifiedTag();
			for ( int i = 0; i < tag.length; i++ ) {
				list.add( tag[i] );
			}
		}
	}

	/**
	 * フレームワークが使用します。
	 */
	public void setView( Page view ) {
		view_page = view;
		if ( view_page == null ) {
			view_page = link_page;
		}
	}
}

