/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

/**
 * 輝度と色差での色表現。{@link Color}クラスへの入出力として使用可能です。<br>
 * YUV は RGB より表現可能範囲が広いため、Colorクラスへ設定する際に
 * YUV の設定値が RGB 空間外であると、RGBに収まるように丸め込まれます。
 * このため、YUV を Colorクラスへsetして、その直後getしても同一の値が
 * 返るとは限りません。
 */
public class YUV {
	/**
	 * 輝度。値の範囲は符号なし8ビットです。
	 */
	public int y;
	/**
	 * 赤の色差。値の範囲は符号あり8ビットです。
	 */
	public int u;
	/**
	 * 青の色差。値の範囲は符号あり8ビットです。
	 */
	public int v;

	/**
	 * コンストラクタ。
	 * @param y 輝度。
	 * @param u 赤の色差。
	 * @param v 青の色差。
	 */
	public YUV( int y, int u, int v ) {
		this.y = y;
		this.u = u;
		this.v = v;
	}
}

